/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.v1.write;

import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.CounterRecordFile;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.Compression;
import com.arm.streamline.common.utility.io.LittleEndianDataOutputStream;
import com.arm.streamline.report.api.write.counters.IReportBinnedCounterWriter;
import com.arm.streamline.report.shared.Limits;
import com.arm.streamline.report.shared.io.IndexDataFile;
import com.arm.streamline.report.shared.zoomlevelgeneration.AllModesZoomLevelGenerator;
import com.arm.streamline.report.shared.zoomlevelgeneration.AllZoomLevelsGenerator;
import com.arm.streamline.report.shared.zoomlevelgeneration.AverageZoomLevelGenerator;
import com.arm.streamline.report.shared.zoomlevelgeneration.BinningDataMode;
import com.arm.streamline.report.shared.zoomlevelgeneration.IZoomLevelBinDataWriter;
import com.arm.streamline.report.shared.zoomlevelgeneration.IZoomLevelGenerator;
import com.arm.streamline.report.shared.zoomlevelgeneration.IZoomLevelLimitsTracker;
import com.arm.streamline.report.shared.zoomlevelgeneration.MaxZoomLevelGenerator;
import com.arm.streamline.report.shared.zoomlevelgeneration.MinZoomLevelGenerator;
import com.arm.streamline.report.shared.zoomlevelgeneration.SumZoomLevelGenerator;
import com.arm.utils.ArrayUtils;
import com.arm.utils.function.IThrowingConsumer;
import com.arm.utils.function.IThrowingObjLongBiFunction;
import gnu.trove.TLongCollection;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.ToIntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ReportBinnedCounterWriter<T>
implements IReportBinnedCounterWriter<T> {
    public static final String LIMITS_BIN = "limits.bin";
    public static final int UNKNOWN_UTID = -1;
    private final @NonNull List<@NonNull LimitsTracker> allLimitsTrackers = new ArrayList<LimitsTracker>();
    private final long binDurationInNanoSeconds;
    private final @NonNull ToIntFunction<@NonNull T> channelMapper;
    private final @NonNull IThrowingConsumer<? super @NonNull TLongSet, IOException> limitsWriter;
    private final int numberOfChannels;
    private final int @NonNull [] numberOfTicksPerBin;
    private final @NonNull IZoomLevelGenerator zoomLevelGenerator;

    public static @NonNull TLongSet getHighResolutionLimits(int @NonNull [] scales, @NonNull TLongCollection interestingIndices) {
        TLongHashSet limitIndices = new TLongHashSet();
        int[] nArray = scales;
        int n = scales.length;
        int n2 = 0;
        while (n2 < n) {
            int scale = nArray[n2];
            if (scale > 1000) {
                TLongIterator it = interestingIndices.iterator();
                while (it.hasNext()) {
                    limitIndices.add(it.next() * (long)scale / 1000L);
                }
            }
            ++n2;
        }
        return limitIndices;
    }

    public static void writeLimits(@NonNull File outputPath, @NonNull TLongCollection limitSet) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (LittleEndianDataOutputStream limitFile = new LittleEndianDataOutputStream(new File(outputPath, LIMITS_BIN));){
            long[] limits = limitSet.toArray();
            Arrays.sort(limits);
            long[] lArray = limits;
            int n = limits.length;
            int n2 = 0;
            while (n2 < n) {
                long limit = lArray[n2];
                limitFile.writeLELong(limit);
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public ReportBinnedCounterWriter(@NonNull File baseDirectory, @NonNull CounterRecord counterRecord, long binDurationInNanoSeconds, int numberOfChannels, @NonNull BinningDataMode @NonNull [] binningDataModes, int @NonNull [] numberOfTicksPerBin, int @NonNull [] labelsPerBin, @NonNull ToIntFunction<@NonNull T> channelMapper) throws IOException {
        this(binDurationInNanoSeconds, numberOfChannels, binningDataModes, numberOfTicksPerBin, labelsPerBin, channelMapper, (IThrowingObjLongBiFunction<BinningDataMode, IZoomLevelBinDataWriter, IOException>)((IThrowingObjLongBiFunction)(mode, label) -> new LegacyBinDataWriter(baseDirectory, (BinningDataMode)((Object)mode), label)), (IThrowingConsumer<? super TLongSet, IOException>)((IThrowingConsumer)limits -> ReportBinnedCounterWriter.writeLimits(baseDirectory, (TLongCollection)limits)));
        CommonFileUtils.makeDirectory((File)baseDirectory);
        CounterRecordFile.writeCounterRecord((File)baseDirectory, (CounterRecord)counterRecord, (int)numberOfChannels);
    }

    public ReportBinnedCounterWriter(long binDurationInNanoSeconds, int numberOfChannels, @NonNull BinningDataMode @NonNull [] binningDataModes, int @NonNull [] numberOfTicksPerBin, int @NonNull [] labelsPerBin, @NonNull ToIntFunction<@NonNull T> channelMapper, @NonNull IThrowingObjLongBiFunction<@NonNull BinningDataMode, @NonNull IZoomLevelBinDataWriter, IOException> writerFactory, @NonNull IThrowingConsumer<? super @NonNull TLongSet, IOException> limitsWriter) throws IOException {
        this.channelMapper = channelMapper;
        this.binDurationInNanoSeconds = binDurationInNanoSeconds;
        this.numberOfChannels = numberOfChannels;
        this.numberOfTicksPerBin = numberOfTicksPerBin;
        this.limitsWriter = limitsWriter;
        this.zoomLevelGenerator = new AllZoomLevelsGenerator(numberOfTicksPerBin, labelsPerBin, (n2, l) -> new AllModesZoomLevelGenerator(binningDataModes, m -> {
            @NonNull LimitsTracker limitsTracker = new LimitsTracker(numberOfChannels);
            this.allLimitsTrackers.add(limitsTracker);
            switch (m) {
                case AVERAGE: {
                    return new AverageZoomLevelGenerator(n2, numberOfChannels, (IZoomLevelBinDataWriter)writerFactory.apply((Object)BinningDataMode.AVERAGE, (long)l), limitsTracker);
                }
                case MAXIMUM: {
                    return new MaxZoomLevelGenerator(n2, numberOfChannels, (IZoomLevelBinDataWriter)writerFactory.apply((Object)BinningDataMode.MAXIMUM, (long)l), limitsTracker);
                }
                case MINIMUM: {
                    return new MinZoomLevelGenerator(n2, numberOfChannels, (IZoomLevelBinDataWriter)writerFactory.apply((Object)BinningDataMode.MINIMUM, (long)l), limitsTracker);
                }
                case SUM: {
                    return new SumZoomLevelGenerator(n2, numberOfChannels, (IZoomLevelBinDataWriter)writerFactory.apply((Object)BinningDataMode.SUM, (long)l), limitsTracker);
                }
            }
            throw new AssertionError((Object)m);
        }));
    }

    @Override
    public void close() throws IOException {
        this.zoomLevelGenerator.close();
        this.limitsWriter.accept((Object)this.calculateLimitsSet());
    }

    @Override
    public void consumeCounterValue(@NonNull T channel, @Nullable Integer utid, long value, boolean happenedInBin) throws IOException {
        int channelNumber = this.channelMapper.applyAsInt(channel);
        assert (channelNumber >= 0 && channelNumber < this.numberOfChannels);
        this.zoomLevelGenerator.consumeCounterValue(channelNumber, utid, value, happenedInBin);
    }

    @Override
    public long getBinDurationInNanoSeconds() {
        return this.binDurationInNanoSeconds;
    }

    @Override
    public void nextBin() throws IOException {
        this.zoomLevelGenerator.nextBaseBin();
    }

    private @NonNull TLongSet calculateLimitsSet() {
        TLongHashSet interestingIndices = new TLongHashSet();
        TLongHashSet limitSet = new TLongHashSet();
        for (LimitsTracker limitsTracker : this.allLimitsTrackers) {
            interestingIndices.addAll(limitsTracker.aggregateLimits.getIndices());
            Limits[] limitsArray = limitsTracker.perCoreLimits;
            int n = limitsTracker.perCoreLimits.length;
            int n2 = 0;
            while (n2 < n) {
                Limits perCoreLimits = limitsArray[n2];
                interestingIndices.addAll(perCoreLimits.getIndices());
                ++n2;
            }
        }
        limitSet.addAll((TLongCollection)ReportBinnedCounterWriter.getHighResolutionLimits(this.numberOfTicksPerBin, (TLongCollection)interestingIndices));
        limitSet.addAll((TLongCollection)interestingIndices);
        return limitSet;
    }

    @Override
    public void discard() {
        this.zoomLevelGenerator.discard();
    }

    public static final class LegacyBinDataWriter
    implements IZoomLevelBinDataWriter {
        private final @NonNull IndexDataFile dataFile;

        public LegacyBinDataWriter(@NonNull File baseDirectory, @NonNull BinningDataMode mode, long label) throws IOException {
            this.dataFile = new IndexDataFile(switch (mode) {
                case BinningDataMode.AVERAGE -> new File(baseDirectory, String.format("average_%d.bin", label));
                case BinningDataMode.MAXIMUM -> new File(baseDirectory, String.format("maximum_%d.bin", label));
                case BinningDataMode.MINIMUM -> new File(baseDirectory, String.format("minimum_%d.bin", label));
                case BinningDataMode.SUM -> new File(baseDirectory, String.format("data_%d.bin", label));
                default -> throw new AssertionError((Object)mode);
            });
        }

        @Override
        public void close() throws IOException {
            this.dataFile.close();
        }

        @Override
        public long getCurrentIndex() throws IOException {
            return this.dataFile.getIndex();
        }

        @Override
        public void next() throws IOException {
            this.dataFile.writeIndex();
        }

        @Override
        public void writeData(int channelNumber, @Nullable Integer uid, long value) throws IOException {
            int uidKey = uid != null ? uid : -1;
            Compression.packInt((long)uidKey, (OutputStream)this.dataFile);
            Compression.packInt((long)channelNumber, (OutputStream)this.dataFile);
            Compression.packInt((long)value, (OutputStream)this.dataFile);
        }
    }

    private static final class LimitsTracker
    implements IZoomLevelLimitsTracker {
        public final @NonNull Limits aggregateLimits = new Limits();
        public final @NonNull Limits @NonNull [] perCoreLimits;

        public LimitsTracker(int channelCount) {
            this.perCoreLimits = (Limits[])ArrayUtils.create(Limits[]::new, (int)channelCount, Limits::new);
        }

        @Override
        public void updateAggregateLimits(long binIndex, @NonNull BinningDataMode mode, long limit) throws IOException {
            this.aggregateLimits.updateLimits(limit, binIndex);
        }

        @Override
        public void updatePerChannelLimits(long binIndex, int channelNumber, @NonNull BinningDataMode mode, long limit) throws IOException {
            this.perCoreLimits[channelNumber].updateLimits(limit, binIndex);
        }
    }
}

