/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.shared.icounter;

import com.arm.streamline.common.model.icounters.ICounterInstructionCounterMetadata;
import com.arm.streamline.common.model.icounters.IInstructionCounterMetadata;
import com.arm.streamline.common.model.icounters.IRatioInstructionCounterDataPoint;
import com.arm.streamline.common.model.icounters.IRatioInstructionCounterMetadata;
import com.arm.streamline.common.model.icounters.ITopDownInstructionCounterMetadata;
import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.set.hash.TLongHashSet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementUnion;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.Version;
import org.simpleframework.xml.core.Persister;

public abstract class InstructionCounterMetadataXml
implements IInstructionCounterMetadata {
    public static final @NonNull InstructionCounterMetadataXml load(@NonNull File xmlPath) throws IOException {
        try {
            try {
                @NonNull Serializer serializer = InstructionCounterMetadataXml.createSerializer();
                @NonNull InstructionCounterFile root = (InstructionCounterFile)serializer.read(InstructionCounterFile.class, xmlPath);
                return root.metadata;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public static final void save(@NonNull File xmlPath, @NonNull InstructionCounterMetadataXml metadata) throws IOException {
        try {
            @NonNull Serializer serializer = InstructionCounterMetadataXml.createSerializer();
            @NonNull InstructionCounterFile root = new InstructionCounterFile(metadata);
            serializer.write((Object)root, xmlPath);
        }
        catch (IOException | Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static @NonNull Serializer createSerializer() {
        return new Persister();
    }

    private InstructionCounterMetadataXml() {
    }

    public abstract <T, R, E extends Throwable> R accept(@NonNull IInstructionCounterMetadataXmlVisitor<T, R, E> var1, T var2) throws E;

    public static final class CounterInstructionCounterMetadata
    extends InstructionCounterMetadataXml
    implements ICounterInstructionCounterMetadata {
        private final @Nullable Integer colourRGB;
        private final @NonNull String description;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ICounterInstructionCounterMetadata.Mode mode;
        private final @NonNull String title;
        private final @Nullable Integer clusterID;
        private final @NonNull String unit;

        public CounterInstructionCounterMetadata(@Attribute(name="title", required=true) @NonNull String title, @Attribute(name="description", required=false, empty="") @NonNull String description, @Attribute(name="unit", required=false, empty="") @NonNull String unit, @Attribute(name="clusterID", required=false, empty="") @Nullable Integer clusterID, @Attribute(name="colour-rgb", required=false) @Nullable Integer colourRGB, @Attribute(name="mode", required=false) // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ICounterInstructionCounterMetadata.Mode mode) {
            this.title = title;
            this.description = description;
            this.unit = unit;
            this.colourRGB = colourRGB;
            this.mode = mode;
            this.clusterID = clusterID;
        }

        @Override
        public <T, R, E extends Throwable> R accept(@NonNull IInstructionCounterMetadataXmlVisitor<T, R, E> visitor, T data) throws E {
            return visitor.visit(this, data);
        }

        public boolean equals(Object obj) {
            return ICounterInstructionCounterMetadata.equals((ICounterInstructionCounterMetadata)this, (Object)obj);
        }

        @Attribute(name="colour-rgb", required=false)
        public @Nullable Integer getColourRGB() {
            return this.colourRGB;
        }

        @Attribute(name="description", required=false, empty="")
        public @NonNull String getDescription() {
            return this.description;
        }

        @Attribute(name="mode", required=false)
        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable ICounterInstructionCounterMetadata.Mode getMode() {
            return this.mode;
        }

        @Attribute(name="title", required=true)
        public @NonNull String getTitle() {
            return this.title;
        }

        @Attribute(name="unit", required=false, empty="")
        public @NonNull String getUnit() {
            return this.unit;
        }

        public int hashCode() {
            return ICounterInstructionCounterMetadata.hashCode((ICounterInstructionCounterMetadata)this);
        }

        public @NonNull String toString() {
            return ICounterInstructionCounterMetadata.toString((ICounterInstructionCounterMetadata)this);
        }

        @Attribute(name="clusterID", required=false, empty="")
        public @Nullable Integer getClusterID() {
            return this.clusterID;
        }
    }

    public static interface IInstructionCounterMetadataXmlVisitor<T, R, E extends Throwable> {
        public R visit(@NonNull CounterInstructionCounterMetadata var1, T var2) throws E;

        public R visit(@NonNull RatioInstructionCounterMetadata var1, T var2) throws E;

        public R visit(@NonNull MetricInstructionCounterMetadata var1, T var2) throws E;
    }

    @Root(name="instruction-counter")
    public static final class InstructionCounterFile {
        public static final double VERSION = 1.0;
        @ElementUnion(value={@Element(name="counter", required=true, type=CounterInstructionCounterMetadata.class), @Element(name="ratio", required=true, type=RatioInstructionCounterMetadata.class), @Element(name="top-down", required=true, type=MetricInstructionCounterMetadata.class)})
        public @NonNull InstructionCounterMetadataXml metadata;
        @Version(name="version", required=false, revision=1.0)
        public double version;

        public InstructionCounterFile() {
        }

        public InstructionCounterFile(@NonNull InstructionCounterMetadataXml metadata) {
            this.metadata = metadata;
            this.version = 1.0;
        }
    }

    public static final class MetricInstructionCounterMetadata
    extends InstructionCounterMetadataXml
    implements ITopDownInstructionCounterMetadata {
        private final @NonNull String description;
        private final @NonNull String id;
        private final @NonNull String title;
        private final @NonNull String unit;

        public MetricInstructionCounterMetadata(@Attribute(name="id", required=true) @NonNull String id, @Attribute(name="title", required=true) @NonNull String title, @Attribute(name="description", required=false, empty="") @NonNull String description, @Attribute(name="unit", required=false, empty="") @NonNull String unit) {
            this.id = id;
            this.title = title;
            this.description = description;
            this.unit = unit;
        }

        @Override
        public <T, R, E extends Throwable> R accept(@NonNull IInstructionCounterMetadataXmlVisitor<T, R, E> visitor, T data) throws E {
            return visitor.visit(this, data);
        }

        public boolean equals(Object obj) {
            return ITopDownInstructionCounterMetadata.equals((ITopDownInstructionCounterMetadata)this, (Object)obj);
        }

        @Attribute(name="description", required=false, empty="")
        public @NonNull String getDescription() {
            return this.description;
        }

        @Attribute(name="id", required=true)
        public @NonNull String getID() {
            return this.id;
        }

        @Attribute(name="title", required=true)
        public @NonNull String getTitle() {
            return this.title;
        }

        @Attribute(name="unit", required=false, empty="")
        public @NonNull String getUnit() {
            return this.unit;
        }

        public int hashCode() {
            return ITopDownInstructionCounterMetadata.hashCode((ITopDownInstructionCounterMetadata)this);
        }

        public @NonNull String toString() {
            return ITopDownInstructionCounterMetadata.toString((ITopDownInstructionCounterMetadata)this);
        }
    }

    public static final class RatioInstructionCounterDataPoint
    implements IRatioInstructionCounterDataPoint {
        private final @Nullable Integer colourRGB;
        private final int id;
        private final @NonNull String name;

        public RatioInstructionCounterDataPoint(@Attribute(name="id", required=true) int id, @Attribute(name="name", required=true) @NonNull String name, @Attribute(name="colour-rgb", required=false) @Nullable Integer colourRGB) {
            this.id = id;
            this.name = name;
            this.colourRGB = colourRGB;
        }

        public boolean equals(Object obj) {
            return IRatioInstructionCounterDataPoint.equals((IRatioInstructionCounterDataPoint)this, (Object)obj);
        }

        @Attribute(name="colour-rgb", required=false)
        public @Nullable Integer getColourRGB() {
            return this.colourRGB;
        }

        @Attribute(name="id", required=true)
        public int getID() {
            return this.id;
        }

        @Attribute(name="name", required=true)
        public @NonNull String getName() {
            return this.name;
        }

        public int hashCode() {
            return IRatioInstructionCounterDataPoint.hashCode((IRatioInstructionCounterDataPoint)this);
        }

        public @NonNull String toString() {
            return IRatioInstructionCounterDataPoint.toString((IRatioInstructionCounterDataPoint)this);
        }
    }

    public static final class RatioInstructionCounterMetadata
    extends InstructionCounterMetadataXml
    implements IRatioInstructionCounterMetadata {
        private final int @Nullable [] dataPointIDsShownByDefault;
        private final @NonNull List<@NonNull RatioInstructionCounterDataPoint> dataPoints;
        private final @NonNull String description;
        private final @NonNull String title;
        private final @NonNull String unit;
        private final @Nullable Integer clusterID;

        public RatioInstructionCounterMetadata(@Attribute(name="title", required=true) @NonNull String title, @Attribute(name="description", required=false, empty="") @NonNull String description, @Attribute(name="unit", required=false, empty="") @NonNull String unit, @Attribute(name="clusterID", required=false, empty="") @Nullable Integer clusterID, @ElementArray(name="data-points-shown-by-default", entry="id", required=false, empty=true) int @Nullable [] dataPointIDsShownByDefault, @ElementList(entry="data-point", inline=true, required=false, empty=false, type=RatioInstructionCounterDataPoint.class) @NonNull List<@NonNull RatioInstructionCounterDataPoint> dataPoints) {
            this.title = title;
            this.description = description;
            this.unit = unit;
            this.clusterID = clusterID;
            this.dataPoints = Collections.unmodifiableList(dataPoints);
            TLongHashSet seenIDs = new TLongHashSet();
            for (RatioInstructionCounterDataPoint dataPoint : dataPoints) {
                if (seenIDs.add((long)dataPoint.getID())) continue;
                throw new IllegalArgumentException("Duplicate IDs in data points");
            }
            if (dataPointIDsShownByDefault != null) {
                TIntHashSet deduplicatedDataPointIDsShownByDefault = new TIntHashSet();
                int[] nArray = dataPointIDsShownByDefault;
                int n = dataPointIDsShownByDefault.length;
                int n2 = 0;
                while (n2 < n) {
                    int dpID = nArray[n2];
                    if (!seenIDs.contains((long)dpID)) {
                        throw new IllegalArgumentException("Invalid IDs in dataPointIDsShownByDefault");
                    }
                    deduplicatedDataPointIDsShownByDefault.add(dpID);
                    ++n2;
                }
                this.dataPointIDsShownByDefault = deduplicatedDataPointIDsShownByDefault.toArray();
                Arrays.sort(this.dataPointIDsShownByDefault);
            } else {
                this.dataPointIDsShownByDefault = null;
            }
        }

        @Override
        public <T, R, E extends Throwable> R accept(@NonNull IInstructionCounterMetadataXmlVisitor<T, R, E> visitor, T data) throws E {
            return visitor.visit(this, data);
        }

        public boolean equals(Object obj) {
            return IRatioInstructionCounterMetadata.equals((IRatioInstructionCounterMetadata)this, (Object)obj);
        }

        @ElementArray(name="data-points-shown-by-default", entry="id", required=false, empty=true)
        public int @Nullable [] getDataPointIDsShownByDefault() {
            return this.dataPointIDsShownByDefault;
        }

        @ElementList(entry="data-point", inline=true, required=false, empty=false, type=RatioInstructionCounterDataPoint.class)
        public @NonNull List<? extends @NonNull IRatioInstructionCounterDataPoint> getDataPoints() {
            return this.dataPoints;
        }

        @Attribute(name="description", required=false, empty="")
        public @NonNull String getDescription() {
            return this.description;
        }

        @Attribute(name="title", required=true)
        public @NonNull String getTitle() {
            return this.title;
        }

        @Attribute(name="unit", required=false, empty="")
        public @NonNull String getUnit() {
            return this.unit;
        }

        public int hashCode() {
            return IRatioInstructionCounterMetadata.hashCode((IRatioInstructionCounterMetadata)this);
        }

        public @NonNull String toString() {
            return IRatioInstructionCounterMetadata.toString((IRatioInstructionCounterMetadata)this);
        }

        @Attribute(name="clusterID", required=false, empty="")
        public @Nullable Integer getClusterID() {
            return this.clusterID;
        }
    }
}

