/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.uids;

import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.NonUniqueId;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.streamline.report.model.uids.UniqueThread;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class UniqueIds
implements IUniqueIds {
    private final @NonNull TLongObjectMap<UniqueProcess> kernelProcesses = new TLongObjectHashMap();
    private int nextUniqueId = 0;
    private final @NonNull TIntObjectMap<UniqueProcess> processesByUid = new TIntObjectHashMap();
    private final @NonNull Map<@NonNull AbstractPerVmId.PerVmNonUniqueTid, @NonNull Set<@NonNull UniqueThread>> threadsById = new HashMap<AbstractPerVmId.PerVmNonUniqueTid, Set<UniqueThread>>();
    private final @NonNull Map<@NonNull UniqueProcess, @NonNull Set<@NonNull UniqueThread>> threadsByProcess = new HashMap<UniqueProcess, Set<UniqueThread>>();
    private final @NonNull TIntObjectMap<UniqueThread> threadsByUid = new TIntObjectHashMap();

    private static void throwBadUid(int uid) throws IOException {
        throw new IOException(MessageFormat.format("Invalid UID detected ({0})", uid));
    }

    public UniqueIds(@NonNull Map<@NonNull NonUniqueId<AbstractPerVmId.PerVmNonUniqueTid>, @NonNull NonUniqueId<AbstractPerVmId.PerVmNonUniquePid>> userThreadsToProcess, @NonNull Map<@NonNull NonUniqueId<AbstractPerVmId.PerVmNonUniqueTid>, @NonNull NonUniqueId<AbstractPerVmId.PerVmNonUniquePid>> kernelThreadsToProcess, @NonNull Set<@NonNull NonUniqueId<AbstractPerVmId.PerVmNonUniqueTid>> idleThreads) {
        @NonNull HashMap<@NonNull K, @NonNull V> processes = new HashMap();
        kernelThreadsToProcess.forEach((thread, process) -> this.addThread(processes, (NonUniqueId<AbstractPerVmId.PerVmNonUniqueTid>)thread, (NonUniqueId<AbstractPerVmId.PerVmNonUniquePid>)process, idleThreads.contains(thread), true));
        userThreadsToProcess.forEach((thread, process) -> this.addThread(processes, (NonUniqueId<AbstractPerVmId.PerVmNonUniqueTid>)thread, (NonUniqueId<AbstractPerVmId.PerVmNonUniquePid>)process, idleThreads.contains(thread), false));
    }

    public UniqueIds(@NonNull TLongObjectMap<UniqueProcess> kernelProcesses, @NonNull Collection<@NonNull UniqueThread> threads, @NonNull Collection<@NonNull UniqueProcess> processes) throws IOException {
        int highestUid = -1;
        for (UniqueProcess process : processes) {
            if (process.uid < 0 || this.processesByUid.putIfAbsent(process.uid, (Object)process) != null) {
                UniqueIds.throwBadUid(process.uid);
            }
            highestUid = Integer.max(highestUid, process.uid);
        }
        for (UniqueThread thread : threads) {
            if (thread.uid < 0 || this.processesByUid.containsKey(thread.uid) || this.threadsByUid.putIfAbsent(thread.uid, (Object)thread) != null) {
                UniqueIds.throwBadUid(thread.uid);
            }
            this.threadsById.computeIfAbsent((AbstractPerVmId.PerVmNonUniqueTid)thread.getNonUid().getId(), k -> new HashSet()).add(thread);
            this.threadsByProcess.computeIfAbsent(thread.process, k -> new HashSet()).add(thread);
            highestUid = Integer.max(highestUid, thread.uid);
        }
        TLongObjectIterator it = kernelProcesses.iterator();
        while (it.hasNext()) {
            it.advance();
            long vmUID = it.key();
            @Nullable UniqueProcess kernelProcess = (UniqueProcess)it.value();
            if (kernelProcess == null) {
                throw new NullPointerException();
            }
            if (!processes.contains(kernelProcess)) {
                UniqueIds.throwBadUid(kernelProcess.uid);
                continue;
            }
            if (vmUID != ((AbstractPerVmId.PerVmNonUniquePid)kernelProcess.nonUid.getId()).vmUID) {
                throw new AssertionError();
            }
        }
        this.nextUniqueId = highestUid + 1;
        this.kernelProcesses.putAll(kernelProcesses);
    }

    @Override
    public @NonNull Optional<UniqueProcess> findProcess(int uid) {
        return Optional.ofNullable((UniqueProcess)this.processesByUid.get(uid));
    }

    @Override
    public @NonNull Optional<UniqueThread> findThread(int uid) {
        return Optional.ofNullable((UniqueThread)this.threadsByUid.get(uid));
    }

    @Override
    public @NonNull Optional<UniqueProcess> getKernelProcess(long vmUID) {
        return Optional.ofNullable((UniqueProcess)this.kernelProcesses.get(vmUID));
    }

    @Override
    public int getNextUniqueId() {
        return this.nextUniqueId;
    }

    @Override
    public Stream<UniqueProcess> getProcesses() {
        return this.processesByUid.valueCollection().stream();
    }

    @Override
    public Stream<UniqueThread> getThreads() {
        return this.threadsByUid.valueCollection().stream();
    }

    @Override
    public @NonNull Stream<@NonNull UniqueThread> getThreadsById(@NonNull AbstractPerVmId.PerVmNonUniqueTid id) {
        @Nullable Set<@NonNull UniqueThread> threadSet = this.threadsById.get(id);
        if (threadSet != null) {
            return threadSet.stream();
        }
        return Stream.empty();
    }

    @Override
    public @NonNull Stream<@NonNull UniqueThread> getThreadsOf(@NonNull UniqueProcess process) {
        @Nullable Set<@NonNull UniqueThread> threadSet = this.threadsByProcess.get(process);
        if (threadSet != null) {
            return threadSet.stream();
        }
        return Stream.empty();
    }

    @Override
    public boolean isEmpty() {
        return this.threadsByUid.isEmpty();
    }

    @Override
    public boolean isIdleUID(int uid) {
        @Nullable UniqueThread uniqueThread = (UniqueThread)this.threadsByUid.get(uid);
        if (uniqueThread != null && uniqueThread.isIdle) {
            return true;
        }
        @Nullable UniqueProcess uniqueProcess = (UniqueProcess)this.processesByUid.get(uid);
        if (uniqueProcess == null) {
            return false;
        }
        @Nullable Set<UniqueThread> threads = this.threadsByProcess.get(uniqueProcess);
        if (threads == null) {
            return false;
        }
        for (UniqueThread thread : threads) {
            if (!thread.isIdle) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isKernelUID(int uid) {
        @Nullable UniqueThread uniqueThread = (UniqueThread)this.threadsByUid.get(uid);
        if (uniqueThread != null && uniqueThread.isKernel) {
            return true;
        }
        for (UniqueProcess process : this.kernelProcesses.valueCollection()) {
            if (process.uid != uid) continue;
            return true;
        }
        return false;
    }

    private void addThread(@NonNull Map<@NonNull NonUniqueId<AbstractPerVmId.PerVmNonUniquePid>, @NonNull UniqueProcess> processes, @NonNull NonUniqueId<AbstractPerVmId.PerVmNonUniqueTid> thread, @NonNull NonUniqueId<AbstractPerVmId.PerVmNonUniquePid> process, boolean isIdle, boolean isKernel) {
        assert (thread.getId().vmUID == process.getId().vmUID);
        UniqueProcess upid = processes.computeIfAbsent(process, x -> {
            UniqueProcess newUpid = new UniqueProcess((NonUniqueId<AbstractPerVmId.PerVmNonUniquePid>)x, this.nextUniqueId++);
            this.processesByUid.put(newUpid.uid, (Object)newUpid);
            return newUpid;
        });
        UniqueThread utid = new UniqueThread(thread, this.nextUniqueId++, isIdle, isKernel, upid);
        this.threadsByUid.put(utid.uid, (Object)utid);
        this.threadsById.computeIfAbsent(thread.getId(), k -> new HashSet()).add(utid);
        this.threadsByProcess.computeIfAbsent(upid, k -> new HashSet()).add(utid);
        if (isKernel) {
            this.kernelProcesses.put(process.getId().vmUID, (Object)upid);
        }
    }
}

