/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.uids;

import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.utils.OptionalUtils;
import java.util.Optional;
import java.util.OptionalInt;
import org.eclipse.jdt.annotation.NonNull;

public final class PerVmOptionalNonUniqueTid
implements Comparable<PerVmOptionalNonUniqueTid> {
    public final @NonNull OptionalInt id;
    public final long vmUID;

    public PerVmOptionalNonUniqueTid(long vmUID) {
        this.vmUID = vmUID;
        this.id = OptionalInt.empty();
    }

    public PerVmOptionalNonUniqueTid(long vmUID, int id) {
        this.vmUID = vmUID;
        this.id = OptionalInt.of(id);
    }

    public PerVmOptionalNonUniqueTid(long vmUID, @NonNull OptionalInt id) {
        this.vmUID = vmUID;
        this.id = id;
    }

    @Override
    public int compareTo(PerVmOptionalNonUniqueTid o) {
        int vmResult = Long.compare(this.vmUID, o.vmUID);
        if (vmResult != 0) {
            return vmResult;
        }
        if (this.id.isPresent()) {
            if (o.id.isPresent()) {
                return Integer.compare(this.id.getAsInt(), o.id.getAsInt());
            }
            return 1;
        }
        if (o.id.isPresent()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PerVmOptionalNonUniqueTid) {
            PerVmOptionalNonUniqueTid that = (PerVmOptionalNonUniqueTid)obj;
            return this.id == that.id && this.vmUID == that.vmUID;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (int)(this.vmUID ^ this.vmUID >>> 32);
        return result;
    }

    public @NonNull Optional<AbstractPerVmId.PerVmNonUniqueTid> mapToOptionalPerVmNonUniqueTid() {
        return OptionalUtils.mapToObj((OptionalInt)this.id, validId -> new AbstractPerVmId.PerVmNonUniqueTid(this.vmUID, validId));
    }

    public String toString() {
        return String.format("{%d : %s}", this.vmUID, OptionalUtils.mapToObj((OptionalInt)this.id, i -> Integer.toString(i)).orElse("<none>"));
    }
}

