/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.topology;

import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.utility.ClusterNameUtils;
import com.arm.streamline.report.model.topology.GatorClusters;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.report.model.topology.ICores;
import com.arm.utils.text.NumericStringComparator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class XmlClustersInfo
implements IClustersInfo {
    public static final Pattern COUNTER_PATTERN = Pattern.compile("(_cnt[0-9]+|_ccnt)$");
    private static final String UNKNOWN = "Unknown";
    private final boolean gatorClusterInformationMissing;
    private final @NonNull GatorClusters mClusters;
    private final int mCoreCount;
    private final @Nullable ICores mCoresFile;

    public XmlClustersInfo(@NonNull GatorClusters gatorClusters, @NonNull ICores coresFile) {
        this.gatorClusterInformationMissing = gatorClusters.getClusterNames().isEmpty();
        this.mClusters = gatorClusters;
        this.mCoreCount = coresFile.getNumCores();
        this.mCoresFile = coresFile;
    }

    public XmlClustersInfo(@NonNull GatorClusters gatorClusters, @NonNull List<@NonNull String> counterNames, int coreCount) {
        this.gatorClusterInformationMissing = gatorClusters.getClusterNames().isEmpty();
        this.mCoreCount = coreCount;
        this.mCoresFile = null;
        this.mClusters = XmlClustersInfo.bigLittle(gatorClusters, counterNames, coreCount);
    }

    public XmlClustersInfo(@NonNull GatorClusters gatorClusters, @NonNull List<@NonNull String> counterNames, @NonNull List<@NonNull CounterRecord> counterRecords, int coreCount) {
        this.gatorClusterInformationMissing = gatorClusters.getClusterNames().isEmpty();
        this.mCoreCount = coreCount;
        this.mCoresFile = null;
        if (counterNames.size() > 0) {
            this.mClusters = XmlClustersInfo.bigLittle(gatorClusters, counterNames, coreCount);
        } else {
            ArrayList<@NonNull String> counterListFromCounterRecords = new ArrayList<String>();
            for (CounterRecord record : counterRecords) {
                String counter = record.getCounter();
                if (counter == null) continue;
                counterListFromCounterRecords.add(counter);
            }
            this.mClusters = XmlClustersInfo.bigLittle(gatorClusters, counterListFromCounterRecords, coreCount);
        }
    }

    @Override
    public @Nullable Integer findClusterIndex(int core) {
        TIntIntMap map;
        if (this.isCpuClusterIdsValid() && (map = this.mClusters.getCpuClusterIds()).containsKey(core)) {
            return map.get(core);
        }
        @Nullable ICores mCoresFile = this.mCoresFile;
        if (mCoresFile == null) {
            return null;
        }
        return mCoresFile.getClusterIndex(core, this);
    }

    @Override
    public @Nullable Integer findClusterIndex(@Nullable String clusterName) {
        if (clusterName != null) {
            return this.getCounterClusterIndex(clusterName);
        }
        return null;
    }

    @Override
    public @Nullable String getClusterHumanName(int clusterId) {
        @Nullable String clusterName = this.getClusterName(clusterId);
        @Nullable String prettyClusterName = ClusterNameUtils.getArchName((String)clusterName);
        return prettyClusterName != null ? prettyClusterName : clusterName;
    }

    @Override
    public Integer getClusterIndex(CounterRecord record) {
        return this.getClusterIndex(record, false);
    }

    private @Nullable Integer getClusterIndex(CounterRecord record, boolean force) {
        if (force || this.hasClusters()) {
            String counterAttribute = record.getCounter();
            if (counterAttribute == null) {
                return null;
            }
            return this.getCounterClusterIndex(record.getCounter());
        }
        return null;
    }

    @Override
    public @Nullable String getClusterName(int clusterId) {
        return (String)this.mClusters.getClusterNames().get(clusterId);
    }

    @Override
    public TIntObjectMap<String> getClusterNames() {
        return this.mClusters.getClusterNames();
    }

    @Override
    public TIntList getCores(int clusterIndex) {
        TIntArrayList cores = new TIntArrayList();
        if (this.isCpuClusterIdsValid()) {
            int[] nArray = this.mClusters.getCpuClusterIds().keys();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int core = nArray[n2];
                if (this.mClusters.getCpuClusterIds().get(core) == clusterIndex) {
                    cores.add(core);
                }
                ++n2;
            }
            return cores;
        }
        @Nullable ICores mCoresFile = this.mCoresFile;
        if (mCoresFile == null) {
            int core = 0;
            while (core < this.mCoreCount) {
                cores.add(core);
                ++core;
            }
            return cores;
        }
        return mCoresFile.getCores(clusterIndex, this);
    }

    @Override
    public TIntIntMap getCpuClusterIds() {
        return this.mClusters.getCpuClusterIds();
    }

    @Override
    public int getNumberOfClusters() {
        return this.mClusters.getClusterNames().size();
    }

    @Override
    public boolean hasClusters() {
        return this.mClusters.getClusterNames().size() > 1;
    }

    @Override
    public boolean isGatorClusterInformationMissing() {
        return this.gatorClusterInformationMissing;
    }

    @Override
    public void updateCounterRecordsWithClusterInformation(boolean forceClusters, List<@NonNull CounterRecord> counterRecordList) {
        boolean clusters = forceClusters || this.hasClusters();
        for (CounterRecord record : counterRecordList) {
            if (!clusters) {
                record.setCluster(null);
                continue;
            }
            @Nullable Integer clusterIndex = this.getClusterIndex(record, forceClusters);
            if (clusterIndex == null) continue;
            record.setCluster(clusterIndex);
        }
    }

    @Override
    public void writeXML(@NonNull File outputPath) {
        this.mClusters.write(outputPath);
    }

    private static @NonNull GatorClusters bigLittle(@NonNull GatorClusters gatorClusters, @NonNull List<@NonNull String> counterNames, int coreCount) {
        int clusterId;
        boolean valid = false;
        if (gatorClusters.getCpuClusterIds().size() == coreCount && gatorClusters.getClusterNames().size() > 0) {
            valid = true;
        }
        if (valid) {
            return gatorClusters;
        }
        ArrayList<Object> clusterNamesList = new ArrayList<Object>();
        TIntObjectHashMap clusterNamesMap = new TIntObjectHashMap();
        TObjectIntHashMap clusterNamesReverseMap = new TObjectIntHashMap();
        for (String counter : counterNames) {
            String cortexName = ClusterNameUtils.getArchName((String)counter);
            if (cortexName == null || clusterNamesList.contains(cortexName)) continue;
            clusterNamesList.add(cortexName);
        }
        int index = clusterNamesList.size() - 1;
        Collections.sort(clusterNamesList, NumericStringComparator.CASELESS_COMPARATOR);
        for (String string : clusterNamesList) {
            clusterId = index--;
            clusterNamesMap.put(clusterId, (Object)string);
            clusterNamesReverseMap.put((Object)string, clusterId);
        }
        if (clusterNamesMap.size() == 0) {
            clusterNamesMap.put(0, (Object)UNKNOWN);
        }
        TIntIntHashMap tIntIntHashMap = new TIntIntHashMap();
        int core = 0;
        while (core < coreCount) {
            if (gatorClusters.getCpuClusterIds().containsKey(core)) {
                clusterId = gatorClusters.getCpuClusterIds().get(core);
                String clusterName = ClusterNameUtils.getArchName((String)((String)gatorClusters.getClusterNames().get(clusterId)));
                if (clusterName != null && clusterNamesReverseMap.containsKey((Object)clusterName)) {
                    int realClusterId = clusterNamesReverseMap.get((Object)clusterName);
                    tIntIntHashMap.put(core, realClusterId);
                }
            }
            ++core;
        }
        return new GatorClusters((TIntObjectMap<String>)clusterNamesMap, (TIntIntMap)tIntIntHashMap);
    }

    private Integer getCounterClusterIndex(String counter) {
        String counterRecordArchName = ClusterNameUtils.getArchName((String)counter);
        int[] nArray = this.mClusters.getClusterNames().keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int clusterIndex = nArray[n2];
            String clusterName = (String)this.mClusters.getClusterNames().get(clusterIndex);
            String archName = ClusterNameUtils.getArchName((String)clusterName);
            if (archName != null && archName.equals(counterRecordArchName)) {
                return clusterIndex;
            }
            ++n2;
        }
        return null;
    }

    private boolean isCpuClusterIdsValid() {
        return this.mClusters.getCpuClusterIds().size() > 0;
    }
}

