/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.pe;

public final class ProcessingElementTopology
implements Comparable<ProcessingElementTopology> {
    public final int clusterID;
    public final int coreID;
    public final int osID;
    public final int threadID;

    public ProcessingElementTopology(int osID, int clusterID, int coreID, int threadID) {
        this.osID = osID;
        this.clusterID = clusterID;
        this.coreID = coreID;
        this.threadID = threadID;
    }

    @Override
    public int compareTo(ProcessingElementTopology o) {
        int clusterResult = Integer.compare(this.clusterID, o.clusterID);
        if (clusterResult != 0) {
            return clusterResult;
        }
        int coreResult = Integer.compare(this.coreID, o.coreID);
        if (coreResult != 0) {
            return coreResult;
        }
        int threadResult = Integer.compare(this.threadID, o.threadID);
        if (threadResult != 0) {
            return threadResult;
        }
        return Integer.compare(this.osID, o.osID);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProcessingElementTopology) {
            ProcessingElementTopology that = (ProcessingElementTopology)obj;
            return this.osID == that.osID && this.clusterID == that.clusterID && this.coreID == that.coreID && this.threadID == that.threadID;
        }
        return false;
    }

    public int hashCode() {
        return Integer.hashCode(this.osID);
    }

    public String toString() {
        return String.format("%d:{%d.%d.%d}", this.osID, this.clusterID, this.coreID, this.threadID);
    }
}

