/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.io.legacyimpl.timeline;

import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.utils.function.IThrowingIntFunction;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AbstractLadderDataSource<T> {
    private static final int LADDER_CAPACITY = (int)Math.log10(Scales.NANOSECONDS_PER_DENSEST_CALLPATH_BIN) * 2 - 1;
    private static final int SCALE_CAPACITY = (int)Math.log10(Scales.NANOSECONDS_PER_DENSEST_CALLPATH_BIN);
    private final @NonNull List<@NonNull T> dataFiles = new ArrayList<T>();
    private final @NonNull TIntList ladderTicksPerBin = new TIntArrayList(LADDER_CAPACITY);
    private final @NonNull TIntList ladderIndexToScaleIndex = new TIntArrayList(LADDER_CAPACITY);
    private final @NonNull TIntList scaleTicksPerBin = new TIntArrayList(SCALE_CAPACITY);

    protected <E extends Throwable> AbstractLadderDataSource(@NonNull IThrowingIntFunction<@Nullable T, E> dataFileFactory) throws E {
        int lastValidTimePerBin = 0;
        ZoomLevel[] zoomLevelArray = Scales.CALLPATH_BINS_PER_SECOND;
        int n = Scales.CALLPATH_BINS_PER_SECOND.length;
        int n2 = 0;
        while (n2 < n) {
            ZoomLevel zoomLevel = zoomLevelArray[n2];
            int ticksPerBin = zoomLevel.getCallPathTicks();
            @Nullable Object dataFile = dataFileFactory.apply(ticksPerBin);
            if (dataFile != null) {
                assert (lastValidTimePerBin == 0 || ticksPerBin > lastValidTimePerBin);
                assert (lastValidTimePerBin == 0 || ticksPerBin % lastValidTimePerBin == 0);
                lastValidTimePerBin = ticksPerBin;
                this.dataFiles.add(dataFile);
                this.scaleTicksPerBin.add(ticksPerBin);
            }
            ++n2;
        }
        int scaleCount = this.scaleTicksPerBin.size();
        int indexCount = Math.max(scaleCount * 2 - 1, 0);
        int i = 0;
        while (i < indexCount) {
            if (i < scaleCount) {
                this.ladderIndexToScaleIndex.add(i);
            } else {
                this.ladderIndexToScaleIndex.add(indexCount - i - 1);
            }
            this.ladderTicksPerBin.add(this.scaleTicksPerBin.get(this.ladderIndexToScaleIndex.get(i)));
            ++i;
        }
    }

    protected final @NonNull T getDataFileByLadderIndex(int ladderIndex) {
        return this.dataFiles.get(this.ladderIndexToScaleIndex.get(ladderIndex));
    }

    /*
     * Unable to fully structure code
     */
    protected final void walkLadder(long startTick, long endTick, @NonNull ILadderStepAction action) throws InterruptedException {
        ladderTicksPerBin = this.ladderTicksPerBin;
        scaleTicksPerBin = this.scaleTicksPerBin;
        ladderSize = ladderTicksPerBin.size();
        scalesSize = scaleTicksPerBin.size();
        if (ladderSize == 0) {
            return;
        }
        shortestBinDuration = ladderTicksPerBin.get(0);
        if (!AbstractLadderDataSource.$assertionsDisabled && startTick % (long)shortestBinDuration != 0L) {
            throw new AssertionError();
        }
        start = startTick = (long)shortestBinDuration * (startTick / (long)shortestBinDuration);
        i = 0;
        while (i < ladderSize) {
            ticksPerBin = ladderTicksPerBin.get(i);
            v0 = nextTicksPerBin = i < scalesSize - 1 ? ladderTicksPerBin.get(i + 1) : 0;
            if (AbstractLadderDataSource.$assertionsDisabled || nextTicksPerBin == 0 || ticksPerBin < nextTicksPerBin && nextTicksPerBin % ticksPerBin == 0) ** GOTO lbl22
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (nextTicksPerBin != 0 && start % (long)nextTicksPerBin == 0L) break;
                action.step(i, start / (long)ticksPerBin);
                start += (long)ticksPerBin;
lbl22:
                // 2 sources

                ** while (start + (long)ticksPerBin <= endTick + 1L)
            }
lbl23:
            // 2 sources

            ++i;
        }
    }

    @FunctionalInterface
    public static interface ILadderStepAction {
        public void step(int var1, long var2);
    }
}

