/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.io.legacyimpl.metrics;

import com.arm.streamline.common.utility.io.CountedInputStream;
import com.arm.streamline.common.utility.io.IProgressProvider;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import com.arm.utils.function.IIntLongConsumer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.NonNull;

public abstract class CallPathMetricsLoader {
    private static final int DYNAMIC_DATA_SIZE = 12;

    public static void loadCallPathCounts(@NonNull IProgressTracker tracker, @NonNull File dataPointDir, @NonNull IIntLongConsumer consumer) throws IOException, InterruptedException {
        @NonNull File file = new File(new File(dataPointDir, "metrics"), "callpaths.bin");
        int count = (int)(file.length() / 12L);
        tracker.setSubTaskTitle(file.getPath());
        try {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (CountedInputStream countDynamicIn = new CountedInputStream(file);){
                    tracker.setProgressProvider((IProgressProvider)countDynamicIn);
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (LittleEndianDataInputStream dynamicIn = new LittleEndianDataInputStream((InputStream)countDynamicIn);){
                        int i = 0;
                        while (i < count) {
                            int id = dynamicIn.readLEInt();
                            long value = dynamicIn.readLELong();
                            if (i % 1000 == 0) {
                                tracker.update();
                            }
                            consumer.accept(id, value);
                            ++i;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                tracker.update();
                tracker.setProgressProvider(null);
            }
        }
        finally {
            tracker.update();
            tracker.setProgressProvider(null);
        }
    }
}

