/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.instructionandsource;

import com.arm.streamline.report.model.icounters.instructionandsource.IInstructionsAndSourcefileLineIncidentCounterValues;
import com.arm.streamline.report.model.icounters.instructionandsource.InMemoryInstructionsAndSourcefileLineIncidentCounterValues;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.Throwing;
import com.arm.utils.io.ByteChannelUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ByteChannel;
import java.nio.channels.SeekableByteChannel;
import org.eclipse.jdt.annotation.NonNull;

public final class OnDiskInstructionsAndSourcefileLineIncidentCounterValues
implements IInstructionsAndSourcefileLineIncidentCounterValues,
Closeable {
    private @NonNull BufferedChannel functionStream;
    private @NonNull BufferedChannel instructionStream;
    private @NonNull BufferedChannel sourceLineStream;
    private final @NonNull IThrowingFunction<@NonNull String, @NonNull SeekableByteChannel, IOException> fileFactory;

    public OnDiskInstructionsAndSourcefileLineIncidentCounterValues(@NonNull IThrowingFunction<@NonNull String, @NonNull SeekableByteChannel, IOException> fileFactory, long @NonNull [] instructionCount, long @NonNull [] sourceFileLineCount, long @NonNull [] functionCumulativeSourceFileLineCount) throws IOException {
        this.fileFactory = fileFactory;
        BufferedChannel functionStream = new BufferedChannel((SeekableByteChannel)fileFactory.apply((Object)"functions"));
        BufferedChannel instructionStream = (BufferedChannel)Throwing.closeIfThrows(() -> new BufferedChannel((SeekableByteChannel)fileFactory.apply((Object)"instructions")), (Closeable[])new Closeable[]{functionStream});
        BufferedChannel sourceLineStream = (BufferedChannel)Throwing.closeIfThrows(() -> new BufferedChannel((SeekableByteChannel)fileFactory.apply((Object)"sourceline")), (Closeable[])new Closeable[]{functionStream, instructionStream});
        try {
            functionStream.reset(functionCumulativeSourceFileLineCount);
            instructionStream.reset(instructionCount);
            sourceLineStream.reset(sourceFileLineCount);
        }
        catch (Throwable t) {
            try {
                Throwing.closeAll((Closeable[])new Closeable[]{functionStream, instructionStream, sourceLineStream});
            }
            catch (Throwable t1) {
                t.addSuppressed(t1);
            }
            throw t;
        }
        this.functionStream = functionStream;
        this.instructionStream = instructionStream;
        this.sourceLineStream = sourceLineStream;
    }

    @Override
    public void close() throws IOException {
        Throwing.closeAll((Closeable[])new Closeable[]{this.functionStream, this.instructionStream, this.sourceLineStream});
    }

    @Override
    public long getFunctionCumulativeSourceFileLineCount(int index) {
        return this.functionStream.get(index);
    }

    @Override
    public long getInstructionCount(int index) {
        return this.instructionStream.get(index);
    }

    @Override
    public long getSourceFileLineCount(int index) {
        return this.sourceLineStream.get(index);
    }

    @Override
    public @NonNull IInstructionsAndSourcefileLineIncidentCounterValues replace(@NonNull InMemoryInstructionsAndSourcefileLineIncidentCounterValues that) throws IOException {
        Throwing.closeAll((Closeable[])new Closeable[]{this.functionStream, this.instructionStream, this.sourceLineStream});
        BufferedChannel functionStream = new BufferedChannel((SeekableByteChannel)this.fileFactory.apply((Object)"functions"));
        BufferedChannel instructionStream = (BufferedChannel)Throwing.closeIfThrows(() -> new BufferedChannel((SeekableByteChannel)this.fileFactory.apply((Object)"instructions")), (Closeable[])new Closeable[]{functionStream});
        BufferedChannel sourceLineStream = (BufferedChannel)Throwing.closeIfThrows(() -> new BufferedChannel((SeekableByteChannel)this.fileFactory.apply((Object)"sourceline")), (Closeable[])new Closeable[]{functionStream, instructionStream});
        try {
            functionStream.reset(that.functionCumulativeSourceFileLineCount);
            instructionStream.reset(that.instructionCount);
            sourceLineStream.reset(that.sourceFileLineCount);
        }
        catch (Throwable t) {
            try {
                Throwing.closeAll((Closeable[])new Closeable[]{functionStream, instructionStream, sourceLineStream});
            }
            catch (Throwable t1) {
                t.addSuppressed(t1);
            }
            throw t;
        }
        this.functionStream = functionStream;
        this.instructionStream = instructionStream;
        this.sourceLineStream = sourceLineStream;
        return this;
    }

    static final class BufferedChannel
    implements Closeable {
        private static final int BUFFER_SIZE = 1024;
        private final @NonNull ByteBuffer buffer = ByteBuffer.allocate(8192);
        private int bufferBaseOffset = -1;
        private int bufferEndOffset = -1;
        private final @NonNull SeekableByteChannel channel;
        private int length = 0;
        private @NonNull Reference<long[]> originalData = new WeakReference<Object>(null);

        public BufferedChannel(@NonNull SeekableByteChannel channel) throws IOException {
            this.channel = channel;
            this.buffer.order(ByteOrder.nativeOrder());
            if (!this.channel.isOpen()) {
                throw new IOException();
            }
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }

        public synchronized long get(int index) {
            if (index < 0 || index >= this.length) {
                throw new IndexOutOfBoundsException();
            }
            long[] originalData = this.originalData.get();
            if (originalData != null) {
                return originalData[index];
            }
            if (this.bufferBaseOffset < 0 || index < this.bufferBaseOffset || index >= this.bufferEndOffset) {
                int maxBufferLength = Math.min(this.length, 1024);
                int maxBufferOffset = this.length - maxBufferLength;
                int alignedIndex = maxBufferLength * (index / maxBufferLength);
                int baseOffset = Math.min(maxBufferOffset, alignedIndex);
                int endOffset = baseOffset + maxBufferLength;
                assert (index >= baseOffset && index < endOffset);
                this.buffer.clear();
                try {
                    this.channel.position(baseOffset * 8);
                    ByteChannelUtils.readBytes((ByteChannel)this.channel, (ByteBuffer)this.buffer);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                this.bufferBaseOffset = baseOffset;
                this.bufferEndOffset = endOffset;
            }
            return this.buffer.getLong((index - this.bufferBaseOffset) * 8);
        }

        public synchronized void reset(long @NonNull [] data) throws IOException {
            this.channel.position(0L);
            this.buffer.clear();
            long[] lArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                long d = lArray[n2];
                this.buffer.putLong(d);
                if (!this.buffer.hasRemaining()) {
                    this.buffer.flip();
                    this.channel.write(this.buffer);
                    this.buffer.clear();
                }
                ++n2;
            }
            if (this.buffer.position() != 0) {
                this.buffer.flip();
                this.channel.write(this.buffer);
                this.buffer.clear();
            }
            assert (this.channel.position() == (long)(data.length * 8));
            this.length = data.length;
            this.bufferBaseOffset = -1;
            this.bufferEndOffset = -1;
            this.originalData = new SoftReference<long[]>(data);
        }
    }
}

