/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.impl;

import com.arm.streamline.common.model.icounters.IRatioInstructionCounterDataPoint;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumnDisplayTypeVisitor;
import com.arm.streamline.report.model.icounters.IInstructionCounterRatioColumnWithValuePercentSubColumns;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.report.model.icounters.PercentAndValue;
import com.arm.streamline.report.model.icounters.RatioValue;
import com.arm.streamline.report.model.icounters.impl.InstructionCounterPercentAndValueColumn;
import com.arm.utils.ArrayUtils;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class InstructionCounterRatioColumnWithValueAndPercentSubColumns<T>
implements IInstructionCounterRatioColumnWithValuePercentSubColumns<T> {
    protected final @NonNull IInstructionCounterSource instructionCounterSource;
    protected final long @NonNull [] maxValues;
    protected final @NonNull InstructionCounterRatioNumberSubColumn<T> @NonNull [] subColumns;
    protected final @NonNull String units;
    private final @NonNull String description;
    private final boolean showRatioByDefault;
    private final @NonNull String title;

    public InstructionCounterRatioColumnWithValueAndPercentSubColumns(@NonNull IInstructionCounterSource instructionCounterSource, @NonNull String title, @NonNull String description, @NonNull String units, @NonNull List<? extends @NonNull IRatioInstructionCounterDataPoint> dataPoints, int @Nullable [] dataPointIDsShownByDefault) {
        this.instructionCounterSource = instructionCounterSource;
        this.title = title;
        this.description = description;
        this.units = units.trim();
        this.showRatioByDefault = dataPoints.size() > 2 || dataPointIDsShownByDefault == null || dataPointIDsShownByDefault.length == dataPoints.size();
        @NonNull InstructionCounterRatioNumberSubColumn @NonNull [] subColumns = new InstructionCounterRatioNumberSubColumn[dataPoints.size()];
        this.subColumns = subColumns;
        this.maxValues = new long[subColumns.length];
        int i = 0;
        while (i < subColumns.length) {
            @NonNull IRatioInstructionCounterDataPoint dataPoint = dataPoints.get(i);
            @NonNull String name = dataPoint.getName();
            @Nullable Integer colourRGB = dataPoint.getColourRGB();
            boolean visibleByDefault = dataPointIDsShownByDefault == null || ArrayUtils.indexOf((int[])dataPointIDsShownByDefault, (int)dataPoint.getID()) >= 0;
            subColumns[i] = new InstructionCounterRatioNumberSubColumn(this, i, title, description, units, name, colourRGB, visibleByDefault);
            this.maxValues[i] = Integer.MAX_VALUE;
            ++i;
        }
    }

    @Override
    public <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<T, U, R, E> visitor, U data) throws E {
        return visitor.displayAsRatioWithValueAndPercentSubColumns(data, this);
    }

    @Override
    public @NonNull IInstructionCounterSource getInstructionCounterSource() {
        return this.instructionCounterSource;
    }

    @Override
    public long @NonNull [] getMaxPossibleDisplayValues() {
        return this.maxValues;
    }

    @Override
    public @Nullable IInstructionCounterColumn<T> getParentColumn() {
        return null;
    }

    @Override
    public @NonNull String getTitle() {
        return this.title;
    }

    @Override
    public @NonNull String getTitleTooltip() {
        return this.description;
    }

    @Override
    public boolean isVisibleByDefault() {
        return this.showRatioByDefault;
    }

    @Override
    public @NonNull RatioValue @Nullable [] mapRatioValue(@NonNull T value) {
        @NonNull RatioValue @NonNull [] values = new RatioValue[this.subColumns.length];
        boolean anyNonNull = false;
        int i = 0;
        while (i < this.subColumns.length) {
            @Nullable Long v = this.getDataPointValue(value, this.subColumns[i].dataPointIndex);
            values[i] = new RatioValue(this.subColumns[i].getRatioName(), v != null ? v : 0L, this.subColumns[i].getColour());
            anyNonNull |= v != null;
            ++i;
        }
        return anyNonNull ? values : null;
    }

    @Override
    public @NonNull IInstructionCounterRatioColumnWithValuePercentSubColumns.IInstructionCounterRatioPercentAndValueSubColumn<T> @NonNull [] valueSubColumns() {
        return this.subColumns;
    }

    protected abstract @Nullable PercentAndValue calculatePercentAndValue(@NonNull T var1, int var2);

    protected abstract @Nullable Long getDataPointValue(@NonNull T var1, int var2);

    protected static final class InstructionCounterRatioNumberSubColumn<T>
    extends InstructionCounterPercentAndValueColumn<T>
    implements IInstructionCounterRatioColumnWithValuePercentSubColumns.IInstructionCounterRatioPercentAndValueSubColumn<T> {
        private static final @NonNull String FORMAT_PERCENT_AND_VALUE_DESCRIPTION = "Value \"{0}\" of \"{1}\", displayed as both value and as a percentage of total value of \"{0}\", where \"{1}\" is {2}";
        private static final @NonNull String FORMAT_PERCENT_AND_VALUE_TITLE = "{0} (#/%)";
        private static final @NonNull String FORMAT_PERCENT_DESCRIPTION = "Value \"{0}\" of \"{1}\", displayed as a percentage of total value of \"{0}\", where \"{1}\" is {2}";
        private static final @NonNull String FORMAT_PERCENT_TITLE = "% {0}";
        private static final @NonNull String FORMAT_VALUE_DESCRIPTION = "Value \"{0}\" of \"{1}\", where \"{1}\" is {2}";
        private static final @NonNull String FORMAT_VALUE_TITLE = "{0}";
        protected final @Nullable Integer colourRGB;
        protected final int dataPointIndex;
        protected final @NonNull InstructionCounterRatioColumnWithValueAndPercentSubColumns<T> parent;
        protected final @NonNull String ratioName;
        protected final @NonNull String units;
        protected final boolean visibleByDefault;

        public InstructionCounterRatioNumberSubColumn(@NonNull InstructionCounterRatioColumnWithValueAndPercentSubColumns<T> parent, int dataPointIndex, @NonNull String ratioTitle, @NonNull String ratioDescription, @NonNull String units, @NonNull String ratioName, @Nullable Integer colourRGB, boolean visibleByDefault) {
            super(parent.instructionCounterSource, MessageFormat.format(FORMAT_PERCENT_AND_VALUE_TITLE, ratioName), MessageFormat.format(FORMAT_PERCENT_AND_VALUE_DESCRIPTION, ratioName, ratioTitle, ratioDescription), MessageFormat.format(FORMAT_PERCENT_TITLE, ratioName), MessageFormat.format(FORMAT_PERCENT_DESCRIPTION, ratioName, ratioTitle, ratioDescription), MessageFormat.format(FORMAT_VALUE_TITLE, ratioName), MessageFormat.format(FORMAT_VALUE_DESCRIPTION, ratioName, ratioTitle, ratioDescription));
            this.parent = parent;
            this.dataPointIndex = dataPointIndex;
            this.units = units;
            this.ratioName = ratioName;
            this.colourRGB = colourRGB;
            this.visibleByDefault = visibleByDefault;
        }

        @Override
        public @Nullable Integer getColour() {
            return this.colourRGB;
        }

        @Override
        public @Nullable IInstructionCounterColumn<T> getParentColumn() {
            return this.parent;
        }

        @Override
        public @NonNull String getRatioName() {
            return this.ratioName;
        }

        @Override
        public boolean isVisibleByDefault() {
            return this.visibleByDefault;
        }

        @Override
        protected @Nullable PercentAndValue calculatePercentAndValue(@NonNull T mappedValue) {
            return this.parent.calculatePercentAndValue(mappedValue, this.dataPointIndex);
        }

        @Override
        protected long getMaxPossibleDisplayValue() {
            return this.parent.maxValues[this.dataPointIndex];
        }

        @Override
        protected @NonNull String makeValueTooltip(@NonNull T mappedValue, @NonNull PercentAndValue percentAndValue) {
            if (this.units.isEmpty()) {
                return String.format("%s: %d (%.01f%%)", this.ratioName, percentAndValue.value, percentAndValue.percent);
            }
            return String.format("%s: %d %s (%.01f%%)", this.ratioName, percentAndValue.value, this.units, percentAndValue.percent);
        }
    }
}

