/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.impl;

import com.arm.streamline.report.model.icounters.IInstructionCounterColumnDisplayTypeVisitor;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class InstructionCounterPercentColumn<T>
implements IInstructionCounterPercentColumn<T> {
    private final @NonNull IInstructionCounterSource instructionCounterSource;
    private final @NonNull String title;
    private final @NonNull String tooltip;

    public InstructionCounterPercentColumn(@NonNull IInstructionCounterSource instructionCounterSource, @NonNull String title, @NonNull String tooltip) {
        this.title = title;
        this.tooltip = tooltip;
        this.instructionCounterSource = instructionCounterSource;
    }

    @Override
    public final <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<T, U, R, E> visitor, U data) throws E {
        return visitor.displayAsPercent(data, this);
    }

    @Override
    public final @NonNull IInstructionCounterSource getInstructionCounterSource() {
        return this.instructionCounterSource;
    }

    @Override
    public final @NonNull String getTitle() {
        return this.title;
    }

    @Override
    public final @NonNull String getTitleTooltip() {
        return this.tooltip;
    }

    @Override
    public final @NonNull String getValueTooltip(@NonNull T value) {
        @Nullable T mappedValue = this.validateAndMapValue(value);
        if (mappedValue == null) {
            return this.getTitleTooltip();
        }
        return this.makeValueTooltip(mappedValue);
    }

    @Override
    public final @Nullable Double mapToPercent(@NonNull T data) {
        @Nullable T mappedValue = this.validateAndMapValue(data);
        if (mappedValue == null) {
            return null;
        }
        return this.calculatePercent(mappedValue);
    }

    protected abstract @Nullable Double calculatePercent(@NonNull T var1);

    protected abstract @NonNull String makeValueTooltip(@NonNull T var1);

    protected @Nullable T validateAndMapValue(@NonNull T rowValue) {
        return rowValue;
    }
}

