/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.impl;

import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumnDisplayTypeVisitor;
import com.arm.streamline.report.model.icounters.IInstructionCounterNumberColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentAndValueColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.report.model.icounters.PercentAndValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class InstructionCounterPercentAndValueColumn<T>
implements IInstructionCounterPercentAndValueColumn<T> {
    private final @NonNull IInstructionCounterSource instructionCounterSource;
    private final @NonNull IInstructionCounterPercentColumn<T> percentSubColumn;
    private final @NonNull String title;
    private final @NonNull String tooltip;
    private final @NonNull IInstructionCounterNumberColumn<T> valueSubColumn;

    public InstructionCounterPercentAndValueColumn(final @NonNull IInstructionCounterSource instructionCounterSource, @NonNull String title, @NonNull String tooltip, final @NonNull String percentSubTitle, final @NonNull String percentSubTooltip, final @NonNull String valueSubTitle, final @NonNull String valueSubTooltip) {
        this.title = title;
        this.tooltip = tooltip;
        this.instructionCounterSource = instructionCounterSource;
        this.percentSubColumn = new IInstructionCounterPercentColumn<T>(){

            @Override
            public <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<T, U, R, E> visitor, U data) throws E {
                return visitor.displayAsPercent(data, this);
            }

            @Override
            public @NonNull IInstructionCounterSource getInstructionCounterSource() {
                return instructionCounterSource;
            }

            @Override
            public @Nullable IInstructionCounterColumn<T> getParentColumn() {
                return InstructionCounterPercentAndValueColumn.this;
            }

            @Override
            public @NonNull String getTitle() {
                return percentSubTitle;
            }

            @Override
            public @NonNull String getTitleTooltip() {
                return percentSubTooltip;
            }

            @Override
            public @NonNull String getValueTooltip(@NonNull T value) {
                return InstructionCounterPercentAndValueColumn.this.getValueTooltip(value);
            }

            @Override
            public @Nullable Double mapToPercent(@NonNull T data) {
                @Nullable PercentAndValue result = InstructionCounterPercentAndValueColumn.this.mapToPercentAndValue(data);
                return result != null ? Double.valueOf(result.percent) : null;
            }
        };
        this.valueSubColumn = new IInstructionCounterNumberColumn<T>(){

            @Override
            public <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<T, U, R, E> visitor, U data) throws E {
                return visitor.displayAsNumber(data, this);
            }

            @Override
            public @NonNull IInstructionCounterSource getInstructionCounterSource() {
                return instructionCounterSource;
            }

            @Override
            public long getMaxPossibleDisplayValue() {
                return InstructionCounterPercentAndValueColumn.this.getMaxPossibleDisplayValue();
            }

            @Override
            public @Nullable IInstructionCounterColumn<T> getParentColumn() {
                return InstructionCounterPercentAndValueColumn.this;
            }

            @Override
            public @NonNull String getTitle() {
                return valueSubTitle;
            }

            @Override
            public @NonNull String getTitleTooltip() {
                return valueSubTooltip;
            }

            @Override
            public @NonNull String getValueTooltip(@NonNull T value) {
                return InstructionCounterPercentAndValueColumn.this.getValueTooltip(value);
            }

            @Override
            public @Nullable Long mapToNumber(@NonNull T data) {
                @Nullable PercentAndValue result = InstructionCounterPercentAndValueColumn.this.mapToPercentAndValue(data);
                return result != null ? Long.valueOf(result.value) : null;
            }
        };
    }

    @Override
    public final <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<T, U, R, E> visitor, U data) throws E {
        return visitor.displayAsPercentAndValue(data, this);
    }

    @Override
    public final @NonNull IInstructionCounterSource getInstructionCounterSource() {
        return this.instructionCounterSource;
    }

    @Override
    public final @NonNull String getTitle() {
        return this.title;
    }

    @Override
    public final @NonNull String getTitleTooltip() {
        return this.tooltip;
    }

    @Override
    public final @NonNull String getValueTooltip(@NonNull T value) {
        @Nullable T mappedValue = this.validateAndMapValue(value);
        if (mappedValue == null) {
            return this.getTitleTooltip();
        }
        @Nullable PercentAndValue percentAndValue = this.mapToPercentAndValue(mappedValue);
        if (percentAndValue == null) {
            return this.getTitleTooltip();
        }
        return this.makeValueTooltip(mappedValue, percentAndValue);
    }

    @Override
    public final @Nullable PercentAndValue mapToPercentAndValue(@NonNull T data) {
        @Nullable T mappedValue = this.validateAndMapValue(data);
        if (mappedValue == null) {
            return null;
        }
        return this.calculatePercentAndValue(mappedValue);
    }

    @Override
    public final @NonNull IInstructionCounterPercentColumn<T> percentSubColumn() {
        return this.percentSubColumn;
    }

    @Override
    public final @NonNull IInstructionCounterNumberColumn<T> valueSubColumn() {
        return this.valueSubColumn;
    }

    protected abstract @Nullable PercentAndValue calculatePercentAndValue(@NonNull T var1);

    protected abstract long getMaxPossibleDisplayValue();

    protected abstract @NonNull String makeValueTooltip(@NonNull T var1, @NonNull PercentAndValue var2);

    protected @Nullable T validateAndMapValue(@NonNull T rowValue) {
        return rowValue;
    }
}

