/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.callpathsandfunctions;

import com.arm.streamline.common.utility.UnsignedUtil;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctions;
import com.arm.streamline.report.model.icounters.io.legacyimpl.IFunctionsReader;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;

public final class InstructionCounterFunctions
implements IInstructionCounterFunctions {
    private final @NonNull List<@NonNull IFunction> mFunctions = new ArrayList<IFunction>();
    private final @NonNull TLongObjectHashMap<List<@NonNull IFunction>> mOrderedFunctionsBySection = new TLongObjectHashMap();

    @Override
    public @NonNull IFunction get(int index) {
        return this.mFunctions.get(index);
    }

    @Override
    public @NonNull IFunction getAnonymous() {
        return this.get(0);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public IFunction getFunctionInSection(long section, long address) {
        @NonNull List list = (List)this.mOrderedFunctionsBySection.get(section);
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            @NonNull IFunction function = (IFunction)list.get(mid);
            long cmp = function.getAddress() - address;
            if (cmp < 0L) {
                if (UnsignedUtil.greaterThan((long)(function.getAddress() + (long)function.getSize()), (long)address)) {
                    return function;
                }
                low = mid + 1;
                continue;
            }
            if (cmp > 0L) {
                high = mid - 1;
                continue;
            }
            return function;
        }
        return null;
    }

    @Override
    public @NonNull Iterator<@NonNull IFunction> iterator() {
        return this.mFunctions.iterator();
    }

    public @NonNull FunctionLimits load(@NonNull IFunctionsReader reader) throws IOException, InterruptedException {
        @NonNull String[] largestFunctionName = new String[]{""};
        int @NonNull [] largestFunctionSize = new int[1];
        int @NonNull [] maxColumn = new int[1];
        int @NonNull [] maxLine = new int[1];
        reader.read(function -> {
            this.mFunctions.add((IFunction)function);
            long section = function.getSection();
            ArrayList<@NonNull IFunction> list = (ArrayList<IFunction>)this.mOrderedFunctionsBySection.get(section);
            if (list == null) {
                list = new ArrayList<IFunction>();
                this.mOrderedFunctionsBySection.put(section, list);
            }
            list.add((IFunction)function);
            @NonNull String functionName = function.getName();
            if (functionName.length() > largestFunctionName[0].length()) {
                stringArray[0] = functionName;
            }
            nArray[0] = Math.max(largestFunctionSize[0], function.getSize());
            nArray2[0] = Math.max(maxColumn[0], function.getStartColumn());
            nArray3[0] = Math.max(maxLine[0], function.getStartLine());
        });
        this.sortFunctions();
        return new FunctionLimits(largestFunctionName[0], largestFunctionSize[0], maxColumn[0], maxLine[0]);
    }

    @Override
    public int size() {
        return this.mFunctions.size();
    }

    @Override
    public @NonNull Stream<@NonNull IFunction> stream() {
        return this.mFunctions.stream();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void sortFunctions() {
        @NonNull Comparator<@NonNull IFunction> comparator = new Comparator<IFunction>(){

            @Override
            public int compare(@NonNull IFunction f1, @NonNull IFunction f2) {
                long result = f1.getAddress() - f2.getAddress();
                return result > 0L ? 1 : (result < 0L ? -1 : 0);
            }
        };
        @NonNull TLongObjectIterator iterator = this.mOrderedFunctionsBySection.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            Collections.sort((List)iterator.value(), comparator);
        }
    }

    public static final class FunctionLimits {
        public final @NonNull String largestFunctionName;
        public final int largestFunctionSize;
        public final int maxColumn;
        public final int maxLine;

        public FunctionLimits(@NonNull String largestFunctionName, int largestFunctionSize, int maxColumn, int maxLine) {
            this.largestFunctionName = largestFunctionName;
            this.largestFunctionSize = largestFunctionSize;
            this.maxColumn = maxColumn;
            this.maxLine = maxLine;
        }
    }
}

