/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters.callpathsandfunctions;

import com.arm.streamline.report.model.CallPathNodeType;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPaths;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionViews;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.CallPath;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.IInstructionCounterCallPathCounterSetFactory;
import com.arm.streamline.report.model.icounters.io.legacyimpl.ICallPathsReader;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class InstructionCounterCallPaths
implements IInstructionCounterCallPaths {
    private final @NonNull List<@NonNull ICallPath> mAllCallChainLinks = new ArrayList<ICallPath>();
    private final @NonNull TIntObjectHashMap<CallPath> mCallChainLinkByID = new TIntObjectHashMap();
    private @NonNull String mLargestCallPathName = "";
    private int mMaxStack;
    private final @NonNull List<@NonNull ICallPath> mRootCallChainLinks = new ArrayList<ICallPath>();

    @Override
    public @Nullable ICallPath getCallPathByID(int id) {
        return (ICallPath)this.mCallChainLinkByID.get(id);
    }

    @Override
    public String getLargestCallPathName() {
        return this.mLargestCallPathName;
    }

    public int getMaxStack() {
        return this.mMaxStack;
    }

    @Override
    public List<@NonNull ICallPath> getRootCallPaths() {
        return Collections.unmodifiableList(this.mRootCallChainLinks);
    }

    public <T extends IInstructionCounterCallPathCounterSetFactory & IInstructionCounterFunctionViews> @NonNull T load(@NonNull ICallPathsReader<CallPath, @NonNull T> reader) throws IOException, InterruptedException {
        ICallPath root;
        @NonNull IInstructionCounterCallPathCounterSetFactory result = (IInstructionCounterCallPathCounterSetFactory)reader.read(callPath -> {
            String name;
            this.mMaxStack = Math.max(this.mMaxStack, callPath.getStackSize());
            this.mAllCallChainLinks.add((ICallPath)callPath);
            this.mCallChainLinkByID.put(callPath.getID(), callPath);
            if (callPath.getParentCallChainLink() == null) {
                assert (callPath.getType() == CallPathNodeType.VMUID || callPath.getType() == CallPathNodeType.UID);
                assert (this.mRootCallChainLinks.isEmpty() || this.mRootCallChainLinks.get(0).getType() == callPath.getType());
                this.mRootCallChainLinks.add((ICallPath)callPath);
            }
            if ((name = callPath.getName()).length() > this.mLargestCallPathName.length()) {
                this.mLargestCallPathName = name;
            }
        });
        if (this.mRootCallChainLinks.size() == 1 && (root = this.mRootCallChainLinks.get(0)).getType() == CallPathNodeType.VMUID) {
            @NonNull List<@NonNull ICallPath> children = root.getChildren();
            this.mRootCallChainLinks.clear();
            this.mRootCallChainLinks.addAll(children);
        }
        return (T)result;
    }
}

