/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model.icounters;

import org.eclipse.jdt.annotation.NonNull;

public final class HistogramDataPoint {
    public final int skip;
    public final int width;

    public static final long @NonNull [] calculateAbsoluteBaseValues(@NonNull HistogramDataPoint @NonNull [] datapoints) {
        long @NonNull [] result = new long[datapoints.length];
        long lastValue = 0L;
        int i = 0;
        while (i < datapoints.length) {
            result[i] = lastValue += (long)datapoints[i].skip;
            lastValue += (long)datapoints[i].width;
            ++i;
        }
        return result;
    }

    public static final @NonNull HistogramDataPoint @NonNull [] calculateHistogramDataPoints(int @NonNull [] datapoints, int width) {
        @NonNull HistogramDataPoint @NonNull [] result = new HistogramDataPoint[datapoints.length];
        long lastValue = 0L;
        int i = 0;
        while (i < datapoints.length) {
            long skip = (long)datapoints[i] - lastValue;
            if (skip < 0L || skip > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            result[i] = new HistogramDataPoint(Math.toIntExact(skip), width);
            lastValue = datapoints[i] + width;
            ++i;
        }
        return result;
    }

    public static @NonNull HistogramDataPoint @NonNull [] calculateHistogramDataPointsOnLog2Nplus1Scale(int @NonNull [] dataPoints) {
        @NonNull HistogramDataPoint @NonNull [] result = new HistogramDataPoint[dataPoints.length];
        long previousLimit = 0L;
        int i = 0;
        while (i < dataPoints.length) {
            long baseValue = dataPoints[i] > 0 ? 1L << dataPoints[i] - 1 : 0L;
            long nextValue = 1L << dataPoints[i];
            long width = nextValue - baseValue;
            long skip = baseValue - previousLimit;
            previousLimit = nextValue;
            if (skip < 0L || skip > Integer.MAX_VALUE || width < 0L || width > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            result[i] = new HistogramDataPoint(Math.toIntExact(skip), Math.toIntExact(width));
            ++i;
        }
        return result;
    }

    public HistogramDataPoint(int skip, int width) {
        if (skip < 0 || width < 1) {
            throw new IllegalArgumentException();
        }
        this.skip = skip;
        this.width = width;
    }
}

