/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.utils.NullChecking;
import gnu.trove.TCollections;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SamplesData
implements Comparable<SamplesData> {
    private final @NonNull TObjectLongHashMap<ICallPath> mData = new TObjectLongHashMap();
    private long mTotal;
    private final @NonNull IFunction mFunction;

    public SamplesData(ICallPath callPath, long samples) {
        @NonNull IInstructionCounterFunctionView functionView = (IInstructionCounterFunctionView)NullChecking.neverNull((Object)callPath.getFunction());
        this.mFunction = functionView.getFunction();
        this.add(callPath, samples);
    }

    public void add(ICallPath callPath, long samples) {
        @Nullable IInstructionCounterFunctionView cpf = callPath.getFunction();
        assert (cpf != null && cpf.getFunction() == this.mFunction);
        this.mData.put((Object)callPath, samples);
        this.mTotal += samples;
    }

    @Override
    public int compareTo(SamplesData other) {
        if (this.mTotal > other.mTotal) {
            return -1;
        }
        if (this.mTotal < other.mTotal) {
            return 1;
        }
        return this.mFunction.compareTo(other.mFunction);
    }

    public @NonNull TObjectLongMap<ICallPath> getData() {
        return TCollections.unmodifiableMap(this.mData);
    }

    public @NonNull IFunction getFunction() {
        return this.mFunction;
    }

    public long getTotalSamples() {
        return this.mTotal;
    }
}

