/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.RandomAccessLittleEndianFile;
import com.arm.streamline.report.model.IIndexedDataProvider;
import com.arm.streamline.report.model.IndexData;
import com.arm.utils.collections.LRUCache;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class IndexedFile<T_Data> {
    private final LRUCache<Long, @Nullable T_Data> mDataCache;
    private final File mDataFile;
    private RandomAccessLittleEndianFile mDataIO;
    private final long mDataLength;
    private final IIndexedDataProvider<T_Data> mDataProvider;
    private final LRUCache<Long, IndexEntry> mIndexCache;
    private final long mIndexCount;
    private final @NonNull File mIndexFile;
    private IndexData mIndexIO;
    private long mIndexLastRead;
    private long mIndexLastSeek;
    private final long mIndexLength;

    private static long readIndexCount(File indexFile) throws IOException, FileNotFoundException {
        long indexLength = indexFile.length();
        if (indexLength >= 16L) {
            Throwable throwable = null;
            Object var4_4 = null;
            try (RandomAccessLittleEndianFile raf = new RandomAccessLittleEndianFile(indexFile, "r");){
                raf.seek(indexLength - 16L);
                return raf.readLELong() + 1L;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return 0L;
    }

    public IndexedFile(File baseDir, IIndexedDataProvider<T_Data> provider, int cacheSize) throws IOException {
        if (baseDir == null || provider == null) {
            throw new NullPointerException();
        }
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            throw new FileNotFoundException(baseDir.getAbsolutePath());
        }
        if (cacheSize < 1) {
            throw new IllegalArgumentException();
        }
        this.mDataProvider = provider;
        this.mIndexFile = new File(baseDir, "index");
        this.mDataFile = new File(baseDir, "data");
        if (!this.mIndexFile.exists() || !this.mIndexFile.isFile()) {
            throw new FileNotFoundException(this.mIndexFile.getAbsolutePath());
        }
        if (!this.mDataFile.exists() || !this.mDataFile.isFile()) {
            throw new FileNotFoundException(this.mDataFile.getAbsolutePath());
        }
        this.mIndexLength = this.mIndexFile.length();
        this.mDataLength = this.mDataFile.length();
        this.mIndexCount = IndexedFile.readIndexCount(this.mIndexFile);
        this.mIndexCache = new LRUCache(10000);
        this.mDataCache = new LRUCache(cacheSize);
    }

    public void cleanup() {
        CommonFileUtils.ignoredClose((Closeable)this.mIndexIO);
        this.mIndexIO = null;
        CommonFileUtils.ignoredClose((Closeable)this.mDataIO);
        this.mDataIO = null;
    }

    public synchronized @Nullable T_Data getDataBlock(long index) throws IOException {
        try {
            T_Data T_Data = this.getDataBlockNoCleanup(index);
            return T_Data;
        }
        finally {
            this.cleanup();
        }
    }

    public int getDataBlockCount() {
        return (int)this.mIndexCount;
    }

    public @Nullable T_Data getDataBlockNoCleanup(long index) throws IOException {
        Object data;
        IndexEntry value = this.getIndex(index);
        if (value == null) {
            return null;
        }
        Long key = value.dataPosition;
        if (this.mDataCache.containsKey((Object)key)) {
            data = this.mDataCache.get((Object)key);
        } else {
            if (this.mDataIO == null) {
                this.mDataIO = new RandomAccessLittleEndianFile(this.mDataFile, "r");
            }
            byte[] buffer = new byte[(int)value.dataLength];
            this.mDataIO.seek(value.dataPosition);
            this.mDataIO.readFully(buffer);
            data = this.mDataProvider.loadData(buffer, false);
            this.mDataCache.put((Object)key, data);
        }
        return (T_Data)data;
    }

    public synchronized ArrayList<@Nullable T_Data> getDataBlocks(int index, int count) throws IOException {
        ArrayList<@Nullable T_Data> list = new ArrayList<T_Data>();
        try {
            int i = 0;
            while (i < count) {
                list.add(this.getDataBlockNoCleanup(index + i));
                ++i;
            }
        }
        finally {
            this.cleanup();
        }
        return list;
    }

    private long binarySearch(long index) throws IOException {
        long high = this.mIndexLength / 16L;
        long low = 0L;
        if (high >= low && this.mIndexIO == null) {
            this.mIndexIO = IndexData.createForFile(this.mIndexFile);
        }
        while (high >= low) {
            long mid = (low + high) / 2L;
            long v0 = index;
            this.mIndexIO.seek(mid * 16L);
            if (!this.mIndexIO.hasRemaining()) {
                throw new EOFException();
            }
            long v1 = this.mIndexIO.readNext();
            if (v0 == v1) {
                return mid;
            }
            if (v0 < v1) {
                high = mid - 1L;
                continue;
            }
            low = mid + 1L;
        }
        return -low - 1L;
    }

    private @Nullable IndexEntry findIndex(long index) throws IOException {
        long dataPositionForFollowingBlock;
        if (this.mIndexIO == null) {
            this.mIndexIO = IndexData.createForFile(this.mIndexFile);
        }
        boolean performAggressiveSearch = true;
        if (index >= this.mIndexLastRead) {
            long seek = this.mIndexLastSeek;
            this.mIndexIO.seek(seek);
            int range = 10;
            long check = this.mIndexIO.readNext();
            if (check == this.mIndexLastRead) {
                long dataPosition = 0L;
                while (check < index && range-- > 0) {
                    if ((seek += 16L) >= this.mIndexLength) break;
                    dataPosition = this.mIndexIO.readNext();
                    check = this.mIndexIO.readNext();
                }
                if (check == index) {
                    this.mIndexLastRead = index;
                    this.mIndexLastSeek = seek;
                    performAggressiveSearch = false;
                } else if (check > index) {
                    long dataPositionForFollowingBlock2 = this.mIndexIO.readNext();
                    return new IndexEntry(dataPosition, dataPositionForFollowingBlock2 - dataPosition);
                }
            }
        }
        if (performAggressiveSearch) {
            long i = this.binarySearch(index);
            if (i < 0L && (i = 0L - i - 2L) < 0L) {
                return null;
            }
            this.mIndexIO.seek(i * 16L);
            this.mIndexLastRead = this.mIndexIO.readNext();
            this.mIndexLastSeek = i * 16L;
        }
        long dataPosition = this.mIndexIO.readNext();
        if (!this.mIndexIO.hasRemaining()) {
            dataPositionForFollowingBlock = this.mDataLength;
        } else {
            this.mIndexIO.readNext();
            dataPositionForFollowingBlock = this.mIndexIO.readNext();
        }
        return new IndexEntry(dataPosition, dataPositionForFollowingBlock - dataPosition);
    }

    private @Nullable IndexEntry getIndex(long index) {
        IndexEntry value = (IndexEntry)this.mIndexCache.get((Object)index);
        if (value != null) {
            return value;
        }
        try {
            value = this.findIndex(index);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mIndexCache.put((Object)index, (Object)value);
        return value;
    }

    private static class IndexEntry {
        public final long dataPosition;
        public final long dataLength;

        public IndexEntry(long dataPosition, long dataLength) {
            this.dataPosition = dataPosition;
            this.dataLength = dataLength;
        }
    }
}

