/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.streamline.common.report.model.Messages;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.CountedInputStream;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.io.IProgressProvider;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.report.model.IImagesFile;
import com.arm.streamline.report.model.PathSubstitutionsFile;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.ISourcefileLineMap;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImagesFile
implements IImagesFile {
    public static final String ATTR_DIR = "dir";
    public static final String ATTR_FILE = "file";
    public static final String ATTR_IMAGE = "image";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_SAMPLES_OFFSET = "samples_offset";
    public static final String ATTR_SAMPLES_QUANTITY = "samples_quantity";
    public static final String ATTR_TIME_STAMP = "modified_time";
    public static final String STATIC_FILENAME = "icounter/images.xml";
    public static final String TAG_DIR = "dir";
    public static final String TAG_DIRS = "dirs";
    public static final String TAG_FILE = "file";
    public static final String TAG_FILES = "files";
    public static final String TAG_IMAGE_DATA = "image_data";
    private static final @NonNull String INVALID_DIRECTORY = "Source File #{0}: Invalid directory index ({1}).";
    private static final @NonNull String INVALID_IMAGE = "Source File #{0}: Invalid image index ({1}).";
    private static final @NonNull String INVALID_SAMPLES_OFFSET = "Source File #{0}: Invalid samples offset ({1}).";
    private static final @NonNull String INVALID_SAMPLES_QUANTITY = "Source File #{0}: Invalid samples quantity ({1}).";
    private static final @NonNull String INVALID_SOURCE_FILE_NAME = "Source File #{0}: Must have a name.";
    private final @NonNull List<@NonNull String> mSourceDirectories = new ArrayList<String>();
    private final @NonNull List<@NonNull SourceFile> mFiles = new ArrayList<SourceFile>();
    private @NonNull String mLargestFileName = "";
    private @NonNull String mParentPath;
    private final @NonNull PathSubstitutionsFile pathSubstitutionsFile;

    private static @NonNull File getFile(File reportDir) {
        return CommonFileUtils.getFile((File)new File(reportDir, STATIC_FILENAME));
    }

    private static @NonNull String validateName(int index, @Nullable String name) throws IOException {
        if (name == null || name.length() == 0) {
            throw new IOException(MessageFormat.format(INVALID_SOURCE_FILE_NAME, index));
        }
        return name;
    }

    public ImagesFile(@NonNull IProgressTracker tracker, @NonNull File reportDirectory, @NonNull ISourcefileLineMap sourcefileLineMap, @NonNull PathSubstitutionsFile pathSubstitutionsFile) throws IOException, InterruptedException {
        tracker.setSubTaskTitle(Messages.FILE_SETS);
        @NonNull File file = ImagesFile.getFile(reportDirectory);
        this.pathSubstitutionsFile = pathSubstitutionsFile;
        this.mParentPath = ((File)NullChecking.neverNull((Object)((File)NullChecking.neverNull((Object)file.getParentFile())).getParentFile())).getAbsolutePath();
        Throwable throwable = null;
        Object var7_8 = null;
        try (CountedInputStream cin = new CountedInputStream(file);){
            tracker.setProgressProvider((IProgressProvider)cin);
            Throwable throwable2 = null;
            Object var10_13 = null;
            try (XMLParser in = XMLParser.create((InputStream)cin);){
                String tag;
                while ((tag = in.nextTag()) != null) {
                    if (TAG_IMAGE_DATA.equals(tag)) {
                        this.loadImageData(in, tracker, sourcefileLineMap);
                    } else {
                        in.skip();
                    }
                    tracker.update();
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            if (this.mFiles.isEmpty()) {
                if (this.mSourceDirectories.isEmpty()) {
                    this.mSourceDirectories.add(this.mParentPath);
                }
                SourceFile srcFile = new SourceFile(this, sourcefileLineMap);
                this.mFiles.add(srcFile);
                this.mLargestFileName = srcFile.getName();
            }
            tracker.update();
            tracker.setProgressProvider(null);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public @NonNull String getSourceDirectory(int index) {
        @NonNull String dir = this.mSourceDirectories.get(index);
        if (!this.pathSubstitutionsFile.isSpecialDirectory(dir, false)) {
            return PathSubstitutionsFile.adjustPathForSubstitutions(dir, this.pathSubstitutionsFile.getPathSubstitutions());
        }
        return dir;
    }

    @Override
    public @NonNull List<@NonNull SourceFile> getFiles() {
        return this.mFiles;
    }

    public List<SourceFile> getFilesWithName(String name) {
        ArrayList<SourceFile> files = new ArrayList<SourceFile>();
        name = FilePath.getLeafName((String)name);
        for (SourceFile file : this.mFiles) {
            if (!((String)NullChecking.neverNull((Object)FilePath.getLeafName((String)file.getName()))).equals(name)) continue;
            files.add(file);
        }
        return files;
    }

    @Override
    public String getLargestFileName() {
        return this.mLargestFileName;
    }

    public String getParentPath() {
        return this.mParentPath;
    }

    @Override
    public @NonNull List<@NonNull String> getUnadjustedSourceDirectories() {
        return this.mSourceDirectories;
    }

    private void loadDirectories(@NonNull XMLParser in, @NonNull IProgressTracker tracker) throws IOException, InterruptedException {
        String tag;
        String marker = in.getMarker();
        while ((tag = in.nextTag(marker)) != null) {
            if ("dir".equals(tag)) {
                String dir = in.getAttribute(ATTR_NAME);
                if (dir == null) {
                    dir = this.mParentPath;
                } else if (!FilePath.isFullPath((String)dir)) {
                    dir = FilePath.getFullPath((String)this.mParentPath, (String)dir);
                }
                this.mSourceDirectories.add((String)NullChecking.neverNull((Object)FilePath.normalizeFullPath((String)dir)));
            }
            in.skip();
            tracker.update();
        }
        if (this.mSourceDirectories.isEmpty()) {
            this.mSourceDirectories.add(this.mParentPath);
        }
    }

    private void loadFiles(@NonNull XMLParser in, @NonNull IProgressTracker tracker, @NonNull ISourcefileLineMap sourcefileLineMap) throws IOException, InterruptedException {
        String tag;
        String marker = in.getMarker();
        int count = 0;
        while ((tag = in.nextTag(marker)) != null) {
            if ("file".equals(tag)) {
                SourceFile file;
                String fileName;
                if ((fileName = (file = this.newSourceFile(in, sourcefileLineMap, count++)).getName()).length() > this.mLargestFileName.length()) {
                    this.mLargestFileName = fileName;
                }
                this.mFiles.add(file);
            } else {
                in.skip();
            }
            tracker.update();
        }
        this.mFiles.sort((a, b) -> Integer.compare(a.getIndex(), b.getIndex()));
    }

    private void loadImageData(@NonNull XMLParser in, @NonNull IProgressTracker tracker, @NonNull ISourcefileLineMap sourcefileLineMap) throws IOException, InterruptedException {
        String tag;
        String marker = in.getMarker();
        while ((tag = in.nextTag(marker)) != null) {
            if (TAG_DIRS.equals(tag)) {
                this.loadDirectories(in, tracker);
            } else if (TAG_FILES.equals(tag)) {
                this.loadFiles(in, tracker, sourcefileLineMap);
            } else {
                in.skip();
            }
            tracker.update();
        }
    }

    private @NonNull SourceFile newSourceFile(@NonNull XMLParser in, @NonNull ISourcefileLineMap sourcefileLineMap, int index) throws IOException {
        int mIndex = in.getIntegerAttribute("file", index);
        @NonNull String mName = ImagesFile.validateName(mIndex, in.getAttribute(ATTR_NAME));
        int mDirIndex = in.getIntegerAttribute("dir", 0);
        if (mDirIndex < 0) {
            throw new IOException(MessageFormat.format(INVALID_DIRECTORY, mIndex, mDirIndex));
        }
        int mImageIndex = in.getIntegerAttribute(ATTR_IMAGE, 0);
        if (mImageIndex < 0) {
            throw new IOException(MessageFormat.format(INVALID_IMAGE, mIndex, mImageIndex));
        }
        int mSamplesOffset = in.getIntegerAttribute(ATTR_SAMPLES_OFFSET, 0);
        if (mSamplesOffset < 0) {
            throw new IOException(MessageFormat.format(INVALID_SAMPLES_OFFSET, mIndex, mSamplesOffset));
        }
        int mSamplesQuantity = in.getIntegerAttribute(ATTR_SAMPLES_QUANTITY, 0);
        if (mSamplesQuantity < 0) {
            throw new IOException(MessageFormat.format(INVALID_SAMPLES_QUANTITY, mIndex, mSamplesQuantity));
        }
        long mTimeStamp = in.getLongAttribute(ATTR_TIME_STAMP, 0L);
        in.skip();
        return new SourceFile(this, sourcefileLineMap, mIndex, mName, mDirIndex, mImageIndex, mSamplesOffset, mSamplesQuantity, mTimeStamp);
    }
}

