/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.report.model;

import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.SourceFile;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IInstructionsFile {
    public static final int IS_16_BIT_MASK = 0x10000000;
    public static final int IS_A64_MASK = 0x40000000;
    public static final int IS_BREAK_MASK = 0x2000000;
    public static final int IS_FUNCTION_MASK = 0x1000000;
    public static final int IS_INLINED = 0x20000000;
    public static final int IS_SCRIPT = Integer.MIN_VALUE;
    public static final int IS_T32_MASK = 0x4000000;
    public static final int IS_T32EE_MASK = 0x8000000;
    public static final int STATIC_DATA_SIZE = 20;
    public static final @NonNull String STATIC_FILENAME = "icounter/instructions.bin";
    public static final @NonNull IInstructionsFileEntryVisitor<Void, @Nullable ISourceReference, RuntimeException> VISITOR_CREATE_SOURCE_REFERENCE = new IInstructionsFileEntryVisitor<Void, ISourceReference, RuntimeException>(){

        @Override
        public @Nullable ISourceReference visit(@NonNull IInstructionsFileBreakEntry entry, Void data) throws RuntimeException {
            return null;
        }

        @Override
        public @Nullable ISourceReference visit(@NonNull IInstructionsFileFunctionEntry entry, Void data) throws RuntimeException {
            return null;
        }

        @Override
        public @Nullable ISourceReference visit(@NonNull IInstructionsFileInstructionEntry entry, Void data) throws RuntimeException {
            return entry.createSourceReference();
        }
    };
    public static final @NonNull IInstructionsFileEntryVisitor<Void, @NonNull IFunction, RuntimeException> VISITOR_FIND_PROCEEDING_FUNCTION = new IInstructionsFileEntryVisitor<Void, IFunction, RuntimeException>(){

        @Override
        public @NonNull IFunction visit(@NonNull IInstructionsFileBreakEntry entry, Void data) throws RuntimeException {
            @Nullable IInstructionsFileFunctionEntry function = entry.getFunction();
            if (function == null) {
                throw new AssertionError((Object)"Invalid instructions file (missing proceeding function entry)");
            }
            return this.visit(function, data);
        }

        @Override
        public @NonNull IFunction visit(@NonNull IInstructionsFileFunctionEntry entry, Void data) throws RuntimeException {
            return entry.getFunction();
        }

        @Override
        public @NonNull IFunction visit(@NonNull IInstructionsFileInstructionEntry entry, Void data) throws RuntimeException {
            return this.visit(entry.getFunction(), data);
        }
    };
    public static final @NonNull IInstructionsFileEntryVisitor<Void, @NonNull String, RuntimeException> VISITOR_FUNCTION_ADDRESS_DESCRIPTION = new IInstructionsFileEntryVisitor<Void, String, RuntimeException>(){

        @Override
        public @NonNull String visit(@NonNull IInstructionsFileBreakEntry entry, Void data) throws RuntimeException {
            @Nullable IInstructionsFileFunctionEntry function = entry.getFunction();
            if (function == null) {
                return "";
            }
            return this.visit(function, data);
        }

        @Override
        public @NonNull String visit(@NonNull IInstructionsFileFunctionEntry entry, Void data) throws RuntimeException {
            return entry.getFunctionAddressDescription(entry.getFunction().getAddress());
        }

        @Override
        public @NonNull String visit(@NonNull IInstructionsFileInstructionEntry entry, Void data) throws RuntimeException {
            return entry.getFunction().getFunctionAddressDescription(entry.getAddress());
        }
    };
    public static final @NonNull IInstructionsFileEntryVisitor<Void, @NonNull Boolean, RuntimeException> VISITOR_IS_INLINED = new IInstructionsFileEntryVisitor<Void, Boolean, RuntimeException>(){

        @Override
        public @NonNull Boolean visit(@NonNull IInstructionsFileBreakEntry entry, Void data) throws RuntimeException {
            return Boolean.FALSE;
        }

        @Override
        public @NonNull Boolean visit(@NonNull IInstructionsFileFunctionEntry entry, Void data) throws RuntimeException {
            return Boolean.FALSE;
        }

        @Override
        public @NonNull Boolean visit(@NonNull IInstructionsFileInstructionEntry entry, Void data) throws RuntimeException {
            return entry.isInlined();
        }
    };

    public static @Nullable ISourceReference createSourceReference(@NonNull IInstructionsFile instructions, int index) {
        @NonNull IInstructionsFileEntry entry = instructions.getEntry(index);
        return entry.accept(VISITOR_CREATE_SOURCE_REFERENCE, null);
    }

    public static @NonNull IFunction findProceedingFunction(@NonNull IInstructionsFile instructions, int index) {
        @NonNull IInstructionsFileEntry entry = instructions.getEntry(index);
        return entry.accept(VISITOR_FIND_PROCEEDING_FUNCTION, null);
    }

    public static @NonNull String getFunctionAddressDescription(@NonNull IInstructionsFile instructions, int index) {
        @NonNull IInstructionsFileEntry entry = instructions.getEntry(index);
        return entry.accept(VISITOR_FUNCTION_ADDRESS_DESCRIPTION, null);
    }

    public static boolean isInlined(@NonNull IInstructionsFile instructions, int index) {
        @NonNull IInstructionsFileEntry entry = instructions.getEntry(index);
        return entry.accept(VISITOR_IS_INLINED, null);
    }

    public int findFirstFunctionIndexAtOrBefore(int var1);

    public int findFirstInstructionIndexOnOrAfter(int var1);

    public long getAddressForIndex(int var1);

    public int getCount();

    public @NonNull IInstructionsFileEntry getEntry(int var1);

    public int @NonNull [] getIndexesForAddress(long var1);

    public boolean has64BitAddresses();

    public static interface IInstructionsFileBreakEntry
    extends IInstructionsFileEntry {
        public long getBytesInBreak();

        public @Nullable IInstructionsFileFunctionEntry getFunction();
    }

    public static interface IInstructionsFileEntry {
        public <T, R, E extends Throwable> R accept(@NonNull IInstructionsFileEntryVisitor<T, R, E> var1, T var2) throws E;

        public int getIndex();
    }

    public static interface IInstructionsFileEntryVisitor<T, R, E extends Throwable> {
        public R visit(@NonNull IInstructionsFileBreakEntry var1, T var2) throws E;

        public R visit(@NonNull IInstructionsFileFunctionEntry var1, T var2) throws E;

        public R visit(@NonNull IInstructionsFileInstructionEntry var1, T var2) throws E;
    }

    public static interface IInstructionsFileFunctionEntry
    extends IInstructionsFileEntry {
        public @NonNull IFunction getFunction();

        public @NonNull String getFunctionAddressDescription(long var1);

        public boolean isScript();
    }

    public static interface IInstructionsFileInstructionEntry
    extends IInstructionsFileEntry {
        public static final /* synthetic */ int[] $SWITCH_TABLE$com$arm$streamline$report$model$IInstructionsFile$IInstructionsFileInstructionEntry$Type;

        public @Nullable ISourceReference createSourceReference();

        public long getAddress();

        public @NonNull String getDisassembly();

        public @NonNull IInstructionsFileFunctionEntry getFunction();

        public int getLine();

        public int getOpcode();

        public @Nullable SourceFile getSourceFile();

        public @NonNull Type getType();

        public boolean isInlined();

        default public boolean isOpcode16Bit() {
            @NonNull Type type = this.getType();
            switch (type) {
                case A32: 
                case A64: 
                case SCRIPT: 
                case T32_32BIT: 
                case T32EE_32BIT: {
                    return false;
                }
                case T32_16BIT: 
                case T32EE_16BIT: {
                    return true;
                }
            }
            throw new AssertionError((Object)type);
        }

        default public boolean isOpcodeThumb() {
            @NonNull Type type = this.getType();
            switch (type) {
                case A32: 
                case A64: 
                case SCRIPT: {
                    return false;
                }
                case T32_16BIT: 
                case T32_32BIT: 
                case T32EE_16BIT: 
                case T32EE_32BIT: {
                    return true;
                }
            }
            throw new AssertionError((Object)type);
        }

        default public int getFormattedOpcode() {
            boolean is16Bit = this.isOpcode16Bit();
            boolean thumb = this.isOpcodeThumb();
            int opCode = this.getOpcode();
            if (thumb && !is16Bit) {
                return (opCode & 0xFFFF) << 16 | opCode >> 16 & 0xFFFF;
            }
            return opCode;
        }

        public static enum Type {
            A32,
            A64,
            SCRIPT,
            T32_16BIT,
            T32_32BIT,
            T32EE_16BIT,
            T32EE_32BIT;

        }
    }
}

