/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.spe;

import com.arm.streamline.common.xml.spe.SpeParsingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public class SpeVersion {
    private static final String SPE_VERSION_REGEX = "^[v](\\d+)[p](\\d+)$";
    private static final int MAJOR_VERSION_REGEX_GROUP = 1;
    private static final int MINOR_VERSION_REGEX_GROUP = 2;
    private final int majorVersion;
    private final int minorVersion;

    public SpeVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public SpeVersion(@NonNull String speVersionString) throws SpeParsingException {
        Matcher matcher = Pattern.compile(SPE_VERSION_REGEX).matcher(speVersionString);
        if (!matcher.find()) {
            throw new SpeParsingException("SPE version is not of the correct format in the xml");
        }
        this.majorVersion = Integer.parseInt(matcher.group(1));
        this.minorVersion = Integer.parseInt(matcher.group(2));
    }

    public int compareTo(SpeVersion other) {
        if (this.majorVersion > other.majorVersion) {
            return 1;
        }
        if (this.majorVersion < other.majorVersion) {
            return -1;
        }
        if (this.minorVersion > other.minorVersion) {
            return 1;
        }
        if (this.minorVersion < other.minorVersion) {
            return -1;
        }
        return 0;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }
}

