/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.spe;

import com.arm.streamline.common.xml.counters.CounterModelMessages;
import com.arm.streamline.common.xml.counters.IAvailableEvent;
import com.arm.streamline.common.xml.spe.SpeCounterProperties;
import com.arm.streamline.common.xml.spe.SpeDataSourceProperties;
import com.arm.streamline.common.xml.spe.SpeFilterEventProperties;
import com.arm.streamline.common.xml.spe.SpePacketEventProperties;
import com.arm.streamline.common.xml.spe.SpeVersion;
import com.arm.utils.NullChecking;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SpeTargetDescription
implements IAvailableEvent {
    private final @NonNull Set<@NonNull SpeCounterProperties> counters = new HashSet<SpeCounterProperties>();
    private final @NonNull Set<@NonNull SpeDataSourceProperties> dataSources = new HashSet<SpeDataSourceProperties>();
    private final @NonNull Set<@NonNull SpeFilterEventProperties> filterEvents = new HashSet<SpeFilterEventProperties>();
    private final boolean isAvailableInTarget;
    private final @NonNull Set<@NonNull SpePacketEventProperties> packetEvents = new HashSet<SpePacketEventProperties>();
    private final @Nullable String parentId;
    private final @NonNull String speId;
    private final @NonNull String speName;
    private final @NonNull Map<@NonNull String, @NonNull SpeTargetDescription> speTargetDescriptionMap;
    private final @Nullable SpeVersion speVersion;
    private static final SpeVersion spev1p2 = new SpeVersion(1, 2);
    private static final int NOT_TAKEN_EVENT_BIT = 6;

    public SpeTargetDescription(@NonNull String speId, @NonNull String speName, @Nullable String parentId, @NonNull Set<@NonNull SpePacketEventProperties> packetEvents, @NonNull Set<@NonNull SpeFilterEventProperties> filterEvents, @NonNull Set<@NonNull SpeCounterProperties> counters, @NonNull Set<@NonNull SpeDataSourceProperties> dataSources, @NonNull Map<@NonNull String, @NonNull SpeTargetDescription> speTargetDescriptionMap, boolean isAdded, @Nullable SpeVersion speVersion) {
        this.speId = speId;
        this.speName = speName;
        this.parentId = parentId;
        this.speTargetDescriptionMap = speTargetDescriptionMap;
        this.filterEvents.addAll(filterEvents);
        this.packetEvents.addAll(packetEvents);
        this.counters.addAll(counters);
        this.dataSources.addAll(dataSources);
        this.isAvailableInTarget = isAdded;
        this.speVersion = speVersion;
    }

    public @Nullable SpeVersion getSpeVersion() {
        if (this.speVersion != null) {
            return this.speVersion;
        }
        if (this.parentId != null) {
            return ((SpeTargetDescription)NullChecking.neverNull((Object)this.speTargetDescriptionMap.get(this.parentId))).getSpeVersion();
        }
        return null;
    }

    public @NonNull Set<@NonNull SpeCounterProperties> getAllSpeCounters() {
        @NonNull HashSet<@NonNull SpeCounterProperties> allCounters = new HashSet<SpeCounterProperties>();
        if (this.parentId != null) {
            allCounters.addAll(((SpeTargetDescription)NullChecking.neverNull((Object)this.speTargetDescriptionMap.get(this.parentId))).getAllSpeCounters());
        }
        allCounters.addAll(this.counters);
        return Collections.unmodifiableSet(allCounters);
    }

    public @NonNull Set<@NonNull SpeDataSourceProperties> getAllSpeDataSources() {
        @NonNull HashSet<@NonNull SpeDataSourceProperties> allDataSources = new HashSet<SpeDataSourceProperties>();
        if (this.parentId != null) {
            allDataSources.addAll(((SpeTargetDescription)NullChecking.neverNull((Object)this.speTargetDescriptionMap.get(this.parentId))).getAllSpeDataSources());
        }
        allDataSources.addAll(this.dataSources);
        return Collections.unmodifiableSet(allDataSources);
    }

    private @NonNull Set<@NonNull SpeFilterEventProperties> getAllSpeFilterEvents() {
        @NonNull HashSet<@NonNull SpeFilterEventProperties> allEvents = new HashSet<SpeFilterEventProperties>();
        if (this.parentId != null) {
            allEvents.addAll(((SpeTargetDescription)NullChecking.neverNull((Object)this.speTargetDescriptionMap.get(this.parentId))).getAllSpeFilterEvents());
        }
        allEvents.addAll(this.filterEvents);
        return Collections.unmodifiableSet(allEvents);
    }

    public @NonNull Set<@NonNull SpeFilterEventProperties> getAllValidSpeFilterEvents() {
        return Collections.unmodifiableSet(SpeTargetDescription.removeInvalidFilterEvents(this.getAllSpeFilterEvents(), this.getSpeVersion()));
    }

    public @NonNull Set<@NonNull SpePacketEventProperties> getAllSpePacketEvents() {
        @NonNull HashSet<@NonNull SpePacketEventProperties> allEvents = new HashSet<SpePacketEventProperties>();
        if (this.parentId != null) {
            allEvents.addAll(((SpeTargetDescription)NullChecking.neverNull((Object)this.speTargetDescriptionMap.get(this.parentId))).getAllSpePacketEvents());
        }
        allEvents.addAll(this.packetEvents);
        return Collections.unmodifiableSet(allEvents);
    }

    @Override
    public @NonNull String getDescription() {
        return CounterModelMessages.SPE_DESCRIPTION;
    }

    public @NonNull String getId() {
        return this.speId;
    }

    public @NonNull String getName() {
        return this.speName;
    }

    public @Nullable String getParentId() {
        return this.parentId;
    }

    public @NonNull Set<@NonNull SpeCounterProperties> getSpeCountersForThisOnly() {
        return Collections.unmodifiableSet(this.counters);
    }

    public @NonNull Set<@NonNull SpeDataSourceProperties> getSpeDataSourcesForThisOnly() {
        return Collections.unmodifiableSet(this.dataSources);
    }

    public @NonNull Set<@NonNull SpeFilterEventProperties> getSpeFilterEventsForThisOnly() {
        return Collections.unmodifiableSet(SpeTargetDescription.removeInvalidFilterEvents(this.filterEvents, this.getSpeVersion()));
    }

    public @NonNull Set<@NonNull SpePacketEventProperties> getSpePacketEventsForThisOnly() {
        return Collections.unmodifiableSet(this.packetEvents);
    }

    @Override
    public @NonNull String getTitleNameEvent() {
        return this.speName;
    }

    public boolean isAvailableInTarget() {
        return this.isAvailableInTarget;
    }

    private static @NonNull Set<@NonNull SpeFilterEventProperties> removeInvalidFilterEvents(@NonNull Set<@NonNull SpeFilterEventProperties> speFilterEvents, @Nullable SpeVersion speVersion) {
        @NonNull HashSet<@NonNull SpeFilterEventProperties> result = new HashSet<SpeFilterEventProperties>();
        result.addAll(speFilterEvents);
        if (speVersion == null || speVersion.compareTo(spev1p2) < 0) {
            result.removeIf(filterEvent -> filterEvent.getBitPosition() == 6);
        }
        return Collections.unmodifiableSet(result);
    }
}

