/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.pmus;

import com.arm.streamline.common.utility.CommonResources;
import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.common.xml.pmus.ProcessorPmuEventDescription;
import com.arm.utils.NullChecking;
import gnu.trove.TCollections;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EventsAndPmusXml {
    public static final @NonNull Events BUILT_IN_EVENTS;
    public static final @NonNull Map<@NonNull String, @NonNull Map<@NonNull Integer, @NonNull ProcessorPmuEventDescription>> BUILT_IN_PMU_EVENTS;
    public static final @NonNull TIntSet KNOWN_PMU_CPUIDS;
    public static final @NonNull Set<@NonNull String> KNOWN_PMU_IDS;
    public static final @NonNull Set<@NonNull String> KNOWN_PMU_COUNTER_SETS;
    public static final @NonNull Map<@NonNull Integer, @NonNull ProcessorPmu> BUILT_IN_CPUID_TO_PMU;
    public static final @NonNull Set<@NonNull ProcessorPmu> BUILT_PMU;
    public static final @NonNull String EVENTS_XML = "events.xml";
    public static final @NonNull String PMUS_XML = "pmus.xml";
    public static final @NonNull Map<@NonNull String, @NonNull String> BUILTIN_PMU_ID_TO_COUNTER_SET;

    static {
        try {
            TIntSet cpuids;
            InputStream inputStreamEvents;
            Throwable throwable = null;
            Object var1_5 = null;
            try {
                inputStreamEvents = (InputStream)NullChecking.neverNull((Object)CommonResources.RESOURCES_EVENTS_XML.open());
                try {
                    BUILT_IN_EVENTS = Events.createWithAllEventsWithoutClusterInfo(inputStreamEvents);
                }
                finally {
                    if (inputStreamEvents != null) {
                        inputStreamEvents.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var1_5 = null;
            try {
                inputStreamEvents = (InputStream)NullChecking.neverNull((Object)CommonResources.RESOURCES_EVENTS_XML.open());
                try {
                    BUILT_IN_PMU_EVENTS = ProcessorPmuEventDescription.loadEventsXml(inputStreamEvents);
                }
                finally {
                    if (inputStreamEvents != null) {
                        inputStreamEvents.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            throwable = null;
            var1_5 = null;
            try (InputStream inputStreamPmus = (InputStream)NullChecking.neverNull((Object)CommonResources.RESOURCES_PMUS_XML.open());){
                BUILT_IN_CPUID_TO_PMU = ProcessorPmu.loadPMUXml(inputStreamPmus, BUILT_IN_PMU_EVENTS);
                BUILT_PMU = new HashSet<ProcessorPmu>(BUILT_IN_CPUID_TO_PMU.values());
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            KNOWN_PMU_IDS = Collections.unmodifiableSet(BUILT_PMU.stream().map(ProcessorPmu::getId).collect(Collectors.toSet()));
            KNOWN_PMU_COUNTER_SETS = Collections.unmodifiableSet(BUILT_PMU.stream().map(ProcessorPmu::getCounterSet).collect(Collectors.toSet()));
            KNOWN_PMU_CPUIDS = cpuids = TCollections.unmodifiableSet((TIntSet)new TIntHashSet(BUILT_PMU.stream().map(ProcessorPmu::getCpuids).flatMapToInt(Arrays::stream).filter(cpuid -> cpuid != 0 && (cpuid & 0xFFFFF) != 1048575).toArray()));
            boolean pmusHaveAmbiguousIds = BUILT_PMU.stream().collect(Collectors.groupingBy(pmu -> pmu.getId().toLowerCase())).entrySet().stream().anyMatch(e -> ((List)e.getValue()).size() > 1);
            assert (!pmusHaveAmbiguousIds);
            BUILTIN_PMU_ID_TO_COUNTER_SET = BUILT_PMU.stream().collect(Collectors.toMap(ProcessorPmu::getId, ProcessorPmu::getCounterSet, (a, b) -> {
                assert (a.contentEquals((CharSequence)b));
                return a;
            }));
        }
        catch (IOException exception) {
            exception.printStackTrace();
            throw new AssertionError((Object)String.format("Cannot load built-in %s or %s file at startup.", EVENTS_XML, PMUS_XML));
        }
    }

    public static @NonNull Events getEvents(@NonNull File barmanRawFile) throws IOException {
        return EventsAndPmusXml.getEventsFromXml(new File(barmanRawFile.getParentFile(), EVENTS_XML));
    }

    public static @NonNull Events getEventsFromXml(@Nullable File eventsXml) {
        if (eventsXml != null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (FileInputStream fileInputStream = new FileInputStream(eventsXml);){
                    return Events.createWithAllEventsWithoutClusterInfo(fileInputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return BUILT_IN_EVENTS;
    }

    public static @NonNull Events getEventsFromXmlPath(@Nullable String eventsXml) {
        return EventsAndPmusXml.getEventsFromXml(eventsXml != null ? new File(eventsXml) : null);
    }

    public static @Nullable ProcessorPmu getPmuByCPUID(int cpuId) {
        return BUILT_IN_CPUID_TO_PMU.get(cpuId);
    }

    public static @Nullable ProcessorPmu getPmuByName(@NonNull String name) {
        Optional<ProcessorPmu> result = BUILT_PMU.stream().filter(p -> p.getId().contentEquals(name)).findFirst();
        if (result.isEmpty()) {
            result = BUILT_PMU.stream().filter(p -> p.getCoreName().contentEquals(name)).findFirst();
        }
        return result.orElse(null);
    }

    public static @NonNull Map<Integer, ProcessorPmu> getPmus(@Nullable File barmanRawFile) throws IOException {
        if (barmanRawFile != null) {
            File parent = barmanRawFile.getParentFile();
            return EventsAndPmusXml.getPmusFromXml(new File(parent, PMUS_XML), new File(parent, EVENTS_XML));
        }
        return BUILT_IN_CPUID_TO_PMU;
    }

    public static @NonNull Map<Integer, ProcessorPmu> getPmusFromXml(@Nullable File pmusXml, @Nullable File eventsXml) {
        if (pmusXml != null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream fileInputStream = new FileInputStream(pmusXml);){
                    return ProcessorPmu.loadPMUXml((InputStream)fileInputStream, EventsAndPmusXml.getPmuEventsFromXml(eventsXml));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return BUILT_IN_CPUID_TO_PMU;
    }

    public static @NonNull Map<Integer, ProcessorPmu> getPmusFromXmlPath(@Nullable String pmusXml, @Nullable String eventsXml) {
        return EventsAndPmusXml.getPmusFromXml(pmusXml != null ? new File(pmusXml) : null, eventsXml != null ? new File(eventsXml) : null);
    }

    private static @NonNull Map<String, Map<Integer, ProcessorPmuEventDescription>> getPmuEventsFromXml(@Nullable File eventsXml) throws IOException {
        if (eventsXml != null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (FileInputStream fileInputStream = new FileInputStream(eventsXml);){
                    return ProcessorPmuEventDescription.loadEventsXml(fileInputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return BUILT_IN_PMU_EVENTS;
    }
}

