/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.utility.io;

import com.arm.utils.NullChecking;
import com.arm.utils.Platform;
import java.io.File;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FilePath {
    public static final String CURRENT_PATH = ".";
    public static final char EXTENSION_SEPARATOR_CHAR = '.';
    public static final char[] INVALID_RESOURCE_CHARACTERS;
    public static final char PATH_SEPARATOR_CHAR = '/';
    public static final String PATH_SEPARATOR;
    public static final char WINDOWS_PATH_SEPARATOR_CHAR = '\\';
    private static final String[] INVALID_RESOURCE_BASENAMES;
    private static final String[] INVALID_RESOURCE_FULLNAMES;

    static {
        PATH_SEPARATOR = Character.toString('/');
        if (Platform.isWindows()) {
            INVALID_RESOURCE_CHARACTERS = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
            INVALID_RESOURCE_BASENAMES = new String[]{"aux", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"};
            INVALID_RESOURCE_FULLNAMES = new String[]{"clock$"};
        } else if (Platform.isMacintosh()) {
            char[] cArray = new char[3];
            cArray[0] = 47;
            cArray[1] = 58;
            INVALID_RESOURCE_CHARACTERS = cArray;
            INVALID_RESOURCE_BASENAMES = null;
            INVALID_RESOURCE_FULLNAMES = null;
        } else {
            char[] cArray = new char[2];
            cArray[0] = 47;
            INVALID_RESOURCE_CHARACTERS = cArray;
            INVALID_RESOURCE_BASENAMES = null;
            INVALID_RESOURCE_FULLNAMES = null;
        }
    }

    public static final String enforceExtension(String name, String extension) {
        return FilePath.enforceExtension(name, extension, false);
    }

    public static final String enforceExtension(String name, String extension, boolean replaceExisting) {
        name = name.replace('\\', '/');
        if (((String)extension).charAt(0) != '.') {
            extension = CURRENT_PATH + (String)extension;
        }
        if (!name.endsWith((String)extension)) {
            int lastDot = name.lastIndexOf(46);
            if (name.lastIndexOf(47) > lastDot) {
                lastDot = -1;
            }
            if (lastDot != -1) {
                if (lastDot == name.length() - 1) {
                    return name + ((String)extension).substring(1);
                }
                if (replaceExisting) {
                    return name.substring(0, lastDot) + (String)extension;
                }
            }
            return name + (String)extension;
        }
        return name;
    }

    public static final String getCommonRoot(String fullPathOne, String fullPathTwo) {
        if (fullPathOne == null) {
            return null;
        }
        fullPathOne = fullPathOne.replace('\\', '/');
        int len1 = fullPathOne.length();
        if (fullPathTwo == null) {
            return null;
        }
        int len2 = (fullPathTwo = fullPathTwo.replace('\\', '/')).length();
        int max = len1 > len2 ? len2 : len1;
        int i = 0;
        while (i < max) {
            if (fullPathOne.charAt(i) != fullPathTwo.charAt(i)) {
                --i;
                break;
            }
            ++i;
        }
        if (i == max) {
            i = max - 1;
        }
        while (i >= 0 && fullPathOne.charAt(i) != '/') {
            --i;
        }
        if (i < 0) {
            return null;
        }
        return fullPathOne.substring(0, i + 1);
    }

    public static final String getExtension(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(46);
        if (index == -1 || index == path.length() - 1 || index < FilePath.getLastSeparatorIndex(path)) {
            return "";
        }
        return path.substring(index);
    }

    public static final File getFile(String path) {
        return new File(FilePath.getPathForPlatform(path));
    }

    public static final @NonNull File getFile(String baseFullPath, String relativePath) {
        return new File(FilePath.getPathForPlatform(FilePath.getFullPath(baseFullPath, relativePath)));
    }

    public static final String getFullPath(File file) {
        return file != null ? FilePath.normalizeFullPath(file.getAbsolutePath()) : null;
    }

    public static final @NonNull String getFullPath(String baseFullPath, String relativePath) {
        Object result;
        if (relativePath != null) {
            if (baseFullPath != null && baseFullPath.length() > 0) {
                baseFullPath = baseFullPath.replace('\\', '/');
                result = FilePath.isFullPath(relativePath = relativePath.replace('\\', '/')) ? relativePath : (baseFullPath.endsWith(PATH_SEPARATOR) ? baseFullPath + relativePath : baseFullPath + PATH_SEPARATOR + relativePath);
            } else {
                result = relativePath.replace('\\', '/');
            }
        } else {
            result = baseFullPath != null && baseFullPath.length() > 0 ? baseFullPath : CURRENT_PATH + PATH_SEPARATOR;
        }
        if (!FilePath.isFullPath((String)result)) {
            result = new File(CURRENT_PATH).getAbsolutePath() + PATH_SEPARATOR + (String)result;
        }
        return (String)NullChecking.neverNull((Object)FilePath.normalizeFullPath((String)result));
    }

    public static final int getLastSeparatorIndex(String path) {
        return Math.max(path.lastIndexOf(PATH_SEPARATOR), path.lastIndexOf(92));
    }

    public static final @Nullable String getLeafName(@Nullable String path) {
        if (path == null) {
            return null;
        }
        return FilePath.getLeafName(path, true);
    }

    public static final @NonNull String getLeafName(@NonNull String path, boolean includeExtension) {
        int index = (path = path.replace('\\', '/')).lastIndexOf(47);
        if (index != -1) {
            if (index == path.length() - 1) {
                return "";
            }
            path = path.substring(index + 1);
        }
        if (!includeExtension && (index = path.lastIndexOf(46)) != -1) {
            path = path.substring(0, index);
        }
        return path;
    }

    public static final String getParent(String path) {
        return FilePath.getParent(path, true);
    }

    public static final String getParent(String path, boolean includeTrailingSep) {
        if (path == null) {
            return null;
        }
        int index = (path = path.replace('\\', '/')).lastIndexOf(47);
        if (index == -1) {
            return "";
        }
        return path.substring(0, index + (includeTrailingSep ? 1 : 0));
    }

    public static final @NonNull String getPathForPlatform(String path) {
        return path.replace('\\', '/').replace('/', File.separatorChar);
    }

    public static final boolean isDriveLetter(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    public static final boolean isFullPath(String path) {
        int length;
        if (path != null && (length = path.length()) > 0) {
            char ch = path.charAt(0);
            return FilePath.isPathSeparator(ch) || length > 2 && path.charAt(1) == ':' && FilePath.isDriveLetter(ch) && FilePath.isPathSeparator(path.charAt(2));
        }
        return false;
    }

    public static final boolean isNameValidForFile(String name) {
        if (name == null || name.isEmpty() || name.equals(CURRENT_PATH) || name.equals("..")) {
            return false;
        }
        char[] cArray = INVALID_RESOURCE_CHARACTERS;
        int n = INVALID_RESOURCE_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (name.indexOf(ch) != -1) {
                return false;
            }
            ++n2;
        }
        if (Platform.isWindows()) {
            String basename;
            char lastChar = name.charAt(name.length() - 1);
            if (lastChar == '.' || Character.isWhitespace(lastChar)) {
                return false;
            }
            int dot = name.indexOf(46);
            String string = basename = dot == -1 ? name : name.substring(0, dot);
            if (Arrays.binarySearch(INVALID_RESOURCE_BASENAMES, basename.toLowerCase()) >= 0) {
                return false;
            }
            return Arrays.binarySearch(INVALID_RESOURCE_FULLNAMES, name.toLowerCase()) < 0;
        }
        return true;
    }

    public static final boolean isPathSeparator(char ch) {
        return ch == '/' || ch == '\\';
    }

    public static final @Nullable String normalizeFullPath(@Nullable String path) {
        if (path != null) {
            char ch;
            int index;
            path = ((String)path).replace('\\', '/');
            boolean isUNCPath = ((String)(path = ((String)path).replaceAll("/\\./", PATH_SEPARATOR))).lastIndexOf("//") == 0;
            path = ((String)path).replaceAll("//", PATH_SEPARATOR);
            if (isUNCPath) {
                path = PATH_SEPARATOR + (String)path;
            }
            do {
                if ((index = ((String)path).indexOf("/../")) == -1) continue;
                int length = 3;
                StringBuilder buffer = new StringBuilder((String)path);
                while (index > 0) {
                    ch = buffer.charAt(--index);
                    ++length;
                    if (ch == '/') break;
                    if (ch != ':') continue;
                    ++index;
                    --length;
                    break;
                }
                buffer.delete(index, index + length);
                path = buffer.toString();
            } while (index != -1);
            if (((String)path).endsWith("/.")) {
                path = ((String)path).substring(0, ((String)path).length() - 2);
            }
            if (((String)path).endsWith("/..")) {
                index = ((String)path).length() - 3;
                while (index > 0) {
                    if ((ch = ((String)path).charAt(--index)) == '/' || ch == ':') break;
                }
                path = ((String)path).substring(0, index);
            }
            if (((String)path).length() > 1 && ((String)path).charAt(1) == ':') {
                path = Character.toUpperCase(((String)path).charAt(0)) + ":" + ((String)path).substring(2);
            }
        }
        return path;
    }
}

