/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.warnings;

import com.arm.streamline.common.model.warnings.WarningsMessages;
import com.arm.utils.text.BasicNumberUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public enum WarningType {
    INCOMPATIBLE_CHART(WarningsMessages.WARNING_TYPE_TITLE_INCOMPATIBLE_CHART),
    INCOMPATIBLE_SNIPPET(WarningsMessages.WARNING_TYPE_TITLE_INCOMPATIBLE_STICKY_SNIPPETS),
    POWER_CHART_CORRELATION(WarningsMessages.WARNING_TYPE_TITLE_POWER_CHART_CORRELATION),
    SESSION_PROCESSOR(WarningsMessages.WARNING_TYPE_SESSION_PROCESSOR),
    DEVELOPMENT(WarningsMessages.WARNING_TYPE_SESSION_PROCESSOR),
    GATOR_PROTOCOL(WarningsMessages.WARNING_TYPE_GATOR_PROTOCOL),
    COMMUNITY_EDITION(WarningsMessages.WARNING_TYPE_COMMUNITY_EDITIION),
    ANNOTATE(WarningsMessages.WARNING_TYPE_ANNOTATE),
    DATABASE(WarningsMessages.WARNING_TYPE_DATABASE),
    THREADS(WarningsMessages.WARNING_TYPE_THREADS),
    ELF_DWARF(WarningsMessages.WARNING_TYPE_ELF_DWARF),
    LIVE(WarningsMessages.WARNING_TYPE_LIVE),
    COUNTER_CONFIGURATION(WarningsMessages.WARNING_TYPE_COUNTER_CONFIGURATION),
    CORRUPTION(WarningsMessages.WARNING_TYPE_CORRUPTION),
    OPENCL(WarningsMessages.WARNING_TYPE_OPENCL),
    MISC(WarningsMessages.WARNING_TYPE_MISC),
    CAM(WarningsMessages.WARNING_TYPE_CAM),
    LICENSING(WarningsMessages.WARNING_LICENSING),
    RETRIEVE_IMAGE(WarningsMessages.WARNING_TYPE_RETRIEVE_IMAGE),
    GATOR_SETUP(WarningsMessages.WARNING_TYPE_GATOR_SETUP),
    BARMAN_STM(WarningsMessages.WARNING_TYPE_BARMAN_STM),
    BARMAN_DWT(WarningsMessages.WARNING_TYPE_BARMAN_DWT);

    private final @NonNull String mTitle;

    public static final @NonNull WarningType get(@Nullable String buffer, @NonNull WarningType def) {
        if (buffer != null) {
            int index = BasicNumberUtils.getNonLocalizedInteger((String)buffer, (int)-1);
            @NonNull WarningType @NonNull [] choices = WarningType.values();
            if (index >= 0 && index < choices.length) {
                return choices[index];
            }
            buffer = buffer.trim().toLowerCase();
            WarningType[] warningTypeArray = choices;
            int n = choices.length;
            int n2 = 0;
            while (n2 < n) {
                WarningType type = warningTypeArray[n2];
                if (type.getXmlKey().equals(buffer)) {
                    return type;
                }
                ++n2;
            }
        }
        return def;
    }

    private WarningType(String title) {
        this.mTitle = title;
    }

    public final String getXmlKey() {
        return this.name().toLowerCase();
    }

    public final String toString() {
        return this.mTitle;
    }
}

