/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.model.warnings;

import com.arm.streamline.common.model.warnings.WarningsMessages;
import com.arm.utils.text.BasicNumberUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public enum WarningSeverity {
    LOW(WarningsMessages.WARNING_SEVERITY_LOW_TITLE),
    MEDIUM(WarningsMessages.WARNING_SEVERITY_MEDIUM_TITLE),
    HIGH(WarningsMessages.WARNING_SEVERITY_HIGH_TITLE);

    private final @NonNull String mTitle;

    public static final @NonNull WarningSeverity get(@Nullable String buffer, @NonNull WarningSeverity def) {
        if (buffer != null) {
            int index = BasicNumberUtils.getNonLocalizedInteger((String)buffer, (int)-1);
            @NonNull WarningSeverity @NonNull [] choices = WarningSeverity.values();
            if (index >= 0 && index < choices.length) {
                return choices[index];
            }
            buffer = buffer.trim().toLowerCase();
            WarningSeverity[] warningSeverityArray = choices;
            int n = choices.length;
            int n2 = 0;
            while (n2 < n) {
                WarningSeverity type = warningSeverityArray[n2];
                if (type.getXmlKey().equals(buffer)) {
                    return type;
                }
                ++n2;
            }
        }
        return def;
    }

    private WarningSeverity(String title) {
        this.mTitle = title;
    }

    public final String getXmlKey() {
        return this.name().toLowerCase();
    }

    public final String toString() {
        return this.mTitle;
    }
}

