/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processing.zoomlevelgeneration;

import com.arm.streamline.analysis.processing.binning.IAnalysisBinningThreadCounterDataPointConsumer;
import com.arm.streamline.analysis.processing.binning.IAnalysisBinningThreadCounterReader;
import java.io.Closeable;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class BaseZoomLevelGenerator
implements Closeable {
    private final @NonNull IAnalysisBinningThreadCounterReader reader;
    private final @NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer;
    private final long duration;
    private long lastTimestamp;
    private final long timeStep;

    public BaseZoomLevelGenerator(long timeStep, long duration, @NonNull IAnalysisBinningThreadCounterReader reader, @NonNull IAnalysisBinningThreadCounterDataPointConsumer consumer) throws IOException {
        this.timeStep = timeStep;
        this.duration = duration;
        this.reader = reader;
        this.consumer = consumer;
        this.lastTimestamp = -timeStep;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public long getLastTimestamp() {
        return this.lastTimestamp;
    }

    public boolean next() throws IOException {
        long timestamp = this.lastTimestamp + this.timeStep;
        if (this.lastTimestamp >= this.duration) {
            return false;
        }
        this.lastTimestamp = timestamp;
        this.reader.read(timestamp, this.consumer);
        this.consumer.commit(timestamp);
        return timestamp < this.duration;
    }
}

