/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model.threads;

import com.arm.streamline.analysis.model.threads.ExecutablePathMapping;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.analysis.model.threads.IUniqueProcessOrThread;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IUniqueThread
extends IUniqueProcessOrThread {
    public static @NonNull IUniqueThread createFakeThreadObject(int id) {
        return new FakeUniqueThread(0L, id, id);
    }

    public @Nullable ExecutablePathMapping findMMapping(long var1);

    public @Nullable IExecutablePath getExecutablePath();

    public @NonNull List<@NonNull ExecutablePathMapping> getMMaps();

    public @Nullable IUniqueThread getProcessThread();

    public boolean isIgnored();

    public boolean isProcessThread();

    public static final class FakeUniqueThread
    implements IUniqueThread {
        private final boolean idle;
        private final boolean kernel;
        private final int pid;
        private final int uid;
        private final long vmUID;

        public FakeUniqueThread(long vmUID, int uid, int pid) {
            this(vmUID, uid, pid, false, false);
        }

        public FakeUniqueThread(long vmUID, int uid, int pid, boolean kernel, boolean idle) {
            this.vmUID = vmUID;
            this.uid = uid;
            this.pid = pid;
            this.kernel = kernel;
            this.idle = idle;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof FakeUniqueThread) {
                FakeUniqueThread that = (FakeUniqueThread)obj;
                return this.vmUID == that.vmUID && this.uid == that.uid && this.pid == that.pid;
            }
            return false;
        }

        @Override
        public @Nullable ExecutablePathMapping findMMapping(long address) {
            return null;
        }

        @Override
        public long getEarliestSeenTimestamp() {
            return 0L;
        }

        @Override
        public @Nullable Long getEndTimestamp() {
            return null;
        }

        @Override
        public @Nullable IExecutablePath getExecutablePath() {
            return null;
        }

        @Override
        public long getLastSeenTimestamp() {
            return 0L;
        }

        @Override
        public @NonNull List<@NonNull ExecutablePathMapping> getMMaps() {
            return Collections.emptyList();
        }

        public @Nullable String getName() {
            return "thread-" + this.uid;
        }

        @Override
        public int getOriginalID() {
            return this.pid;
        }

        @Override
        public @Nullable IUniqueThread getProcessThread() {
            return this;
        }

        @Override
        public @Nullable Long getStartTimestamp() {
            return null;
        }

        public int getUID() {
            return this.uid;
        }

        public long getVmUID() {
            return this.vmUID;
        }

        public int hashCode() {
            return this.uid;
        }

        public boolean isIdle() {
            return this.idle;
        }

        @Override
        public boolean isIgnored() {
            return false;
        }

        public boolean isKernel() {
            return this.kernel;
        }

        @Override
        public boolean isProcessThread() {
            return true;
        }

        public String toString() {
            return this.getName();
        }
    }
}

