/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model.threads;

import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.utils.numbers.UnsignedLong;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ExecutablePathMapping
implements Comparable<ExecutablePathMapping> {
    public final @NonNull IExecutablePath executablePath;
    public final long fileOffset;
    public final long length;
    public final long mapAddress;

    public static @Nullable ExecutablePathMapping findMMapping(@NonNull List<@NonNull ExecutablePathMapping> mmaps, long address) {
        int start = 0;
        int end = mmaps.size();
        while (start < end) {
            int middle = (end + start) / 2;
            @NonNull ExecutablePathMapping mapping = mmaps.get(middle);
            int result = mapping.contains(address);
            if (result == 0) {
                return mapping;
            }
            if (result > 0) {
                start = middle + 1;
                continue;
            }
            end = middle;
        }
        return null;
    }

    public ExecutablePathMapping(@NonNull IExecutablePath executablePath, long fileOffset, long mapAddress, long length) {
        this.executablePath = executablePath;
        this.fileOffset = fileOffset;
        this.mapAddress = mapAddress;
        this.length = length;
    }

    @Override
    public int compareTo(ExecutablePathMapping o) {
        return UnsignedLong.compare((long)this.mapAddress, (long)o.mapAddress);
    }

    public int contains(long address) {
        if (UnsignedLong.compare((long)address, (long)this.mapAddress) < 0) {
            return -1;
        }
        if (UnsignedLong.compare((long)address, (long)(this.mapAddress + this.length)) >= 0) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ExecutablePathMapping) {
            ExecutablePathMapping that = (ExecutablePathMapping)obj;
            return this.executablePath.equals(that.executablePath) && this.fileOffset == that.fileOffset && this.mapAddress == that.mapAddress && this.length == that.length;
        }
        return false;
    }

    public int hashCode() {
        return ((this.executablePath.hashCode() * 31 + Long.hashCode(this.fileOffset)) * 31 + Long.hashCode(this.mapAddress)) * 31 + Long.hashCode(this.length);
    }

    public long mapAddressToOffset(long address) {
        return address - this.mapAddress + this.fileOffset;
    }

    public String toString() {
        return String.format("ExecutablePathMapping [executablePath=%s, fileOffset=0x%x, mapAddress=0x%x, length=%s]", this.executablePath, this.fileOffset, this.mapAddress, this.length);
    }
}

