/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model.metrics;

import com.arm.streamline.analysis.model.metrics.MetricConstantDefaults;
import com.arm.streamline.analysis.model.metrics.MetricCpuProperties;
import com.arm.streamline.analysis.model.metrics.MetricProcessorProperties;
import com.arm.streamline.analysis.model.metrics.MetricProcessors;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MetricProcessorHelpers {
    public static final @Nullable Double add(@Nullable Double lhs, @Nullable Double rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        return lhs + rhs;
    }

    public static final @Nullable Double sub(@Nullable Double lhs, @Nullable Double rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        return lhs - rhs;
    }

    public static final @Nullable Double mul(@Nullable Double lhs, @Nullable Double rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        return lhs * rhs;
    }

    public static final @Nullable Double div(@Nullable Double lhs, @Nullable Double rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        return lhs / rhs;
    }

    public static @Nullable Pair<@NonNull MetricProcessorProperties, @NonNull MetricConstantDefaults> findMatchingProcessor(@NonNull String metricId) {
        Pattern pattern;
        Matcher match;
        Pair<MetricProcessorProperties, MetricConstantDefaults> globalProcessor = MetricProcessors.METRIC_PROCESSORS.get(metricId);
        if (globalProcessor != null) {
            return globalProcessor;
        }
        String[] parts = metricId.split("_metric_", 2);
        if (parts.length != 2) {
            return null;
        }
        String cpu = parts[0];
        @NonNull String cntr = (String)NullChecking.neverNull((Object)parts[1]);
        @NonNull String versionToMatch = "";
        if (!cntr.endsWith("_common") && (match = (pattern = Pattern.compile("(.+)_(\\d+_\\d+)")).matcher(cntr)).matches()) {
            cntr = (String)NullChecking.neverNull((Object)match.group(1));
            versionToMatch = (String)NullChecking.neverNull((Object)match.group(2));
        }
        return MetricProcessorHelpers.findMatchingProcessor(cpu, cntr, versionToMatch);
    }

    private static @Nullable Pair<@NonNull MetricProcessorProperties, @NonNull MetricConstantDefaults> findMatchingProcessor(@NonNull String cpu, @NonNull String metric, @NonNull String versionToMatch) {
        Map<String, MetricCpuProperties> cpuProperties = MetricProcessors.METRIC_CPU_PROPERTIES.get(cpu);
        if (cpuProperties == null) {
            return null;
        }
        MetricCpuProperties versionProperties = cpuProperties.get(versionToMatch);
        if (versionProperties == null && !versionToMatch.isBlank()) {
            versionProperties = cpuProperties.get("");
        }
        if (versionProperties == null) {
            return null;
        }
        MetricProcessorProperties processor = versionProperties.processors.get(metric);
        if (processor == null && versionToMatch.isBlank()) {
            versionProperties = MetricProcessorHelpers.getEarliestVersion(cpuProperties);
            if (versionProperties == null) {
                return null;
            }
            processor = versionProperties.processors.get(metric);
        }
        if (processor == null) {
            return null;
        }
        return new Pair((Object)processor, (Object)versionProperties.constants);
    }

    private static @Nullable MetricCpuProperties getEarliestVersion(@NonNull Map<@NonNull String, @NonNull MetricCpuProperties> cpuProperties) {
        return cpuProperties.entrySet().stream().filter(e -> !((String)e.getKey()).isBlank()).sorted((a, b) -> NullChecking.compareToNullable((Comparable)((Object)((String)a.getKey())), (Comparable)((Object)((String)b.getKey())), (boolean)false)).map(e -> (MetricCpuProperties)e.getValue()).findFirst().orElse(null);
    }
}

