/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.common.model.counters.CounterMode;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DeviceTypeCalculator {
    private final @NonNull Set<@NonNull DeviceType> mDeviceTypes = new HashSet<DeviceType>();

    public static @NonNull DeviceTypeCalculator create(@NonNull Collection<@NonNull CounterRecord> counterRecords, @NonNull Collection<@NonNull String> counterNames) {
        DeviceTypeCalculator result = new DeviceTypeCalculator();
        for (CounterRecord cr : counterRecords) {
            result.addCounterName(cr.getCounter(), cr.isPerCPU(), false);
        }
        for (String name : counterNames) {
            result.addCounterName(name, true, false);
        }
        return result;
    }

    public @NonNull DeviceType addCounter(@NonNull CounterRecord counterRecord) {
        @Nullable String name = counterRecord.getCounter();
        return this.addCounterName(name, counterRecord.isPerCPU(), true);
    }

    public @NonNull DeviceType calcDeviceType(@NonNull CounterRecord counter) {
        @NonNull DeviceType deviceType = DeviceType.parseDeviceType((boolean)counter.isPerCPU(), (String)counter.getCounter());
        return this.findNonGenericDeviceType(deviceType);
    }

    public @NonNull DeviceType calcDeviceType(@NonNull CounterRecord counter, int cpuCoresCount, @Nullable Integer gpuCoresCount) throws IllegalArgumentException {
        DeviceType findNonGenericDeviceType = this.calcDeviceType(counter);
        DeviceTypeCalculator.updateCores(findNonGenericDeviceType, cpuCoresCount, gpuCoresCount, counter);
        counter.setDeviceType(findNonGenericDeviceType);
        return findNonGenericDeviceType;
    }

    private static void updateCores(@NonNull DeviceType deviceType, int cpuCoresCount, @Nullable Integer gpuCoresCount, @NonNull CounterRecord counter) throws IllegalArgumentException {
        if (deviceType.supportsMultipleCoresControlledByCounterRecord()) {
            int cores = counter.getCores();
            boolean perCore = cores > 1;
            counter.setMode(perCore ? CounterMode.PER_CORE : CounterMode.SYSTEM_WIDE);
            counter.setCores(perCore ? cores : 0);
        } else if (deviceType.isCPU()) {
            counter.setMode(CounterMode.PER_CORE);
            counter.setCores(cpuCoresCount);
        } else if (deviceType.isGPU() && !deviceType.isMaliUtgard()) {
            counter.setMode(CounterMode.PER_CORE);
            counter.setCores(gpuCoresCount != null ? gpuCoresCount : 1);
        } else if (!deviceType.supportsMultipleCores()) {
            counter.setMode(CounterMode.SYSTEM_WIDE);
            counter.setCores(0);
        }
    }

    private @NonNull DeviceType addCounterName(@Nullable String name, boolean perCPU, boolean findNonGeneric) {
        DeviceType dt = DeviceType.parseDeviceType((boolean)perCPU, (String)name);
        if ((dt.isMaliUtgard() || dt.isMaliMidgard() || dt.isMaliBifrostOrValhall()) && !dt.isGeneric()) {
            this.mDeviceTypes.add(dt);
        }
        if (findNonGeneric) {
            return this.findNonGenericDeviceType(dt);
        }
        return dt;
    }

    private @NonNull DeviceType findNonGenericDeviceType(@NonNull DeviceType deviceType) {
        if (deviceType.isGeneric()) {
            for (DeviceType dt : this.mDeviceTypes) {
                if (!(deviceType.isMaliUtgard() && dt.isMaliUtgard() || deviceType.isMaliMidgard() && dt.isMaliMidgard()) && (!deviceType.isMaliBifrostOrValhall() || !dt.isMaliBifrostOrValhall())) continue;
                return dt;
            }
        }
        return deviceType;
    }
}

