/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ChannelDescriptorUtils {
    public static @NonNull ProcessingElementReference @NonNull [] makeChannelDescriptors(@NonNull ProcessingElementReferenceSet processingElementsReferenceSet, @NonNull CounterRecord counterRecord) {
        @NonNull ProcessingElementReference @Nullable [] channelDescriptions = counterRecord.getChannelDescriptions();
        if (channelDescriptions != null) {
            return channelDescriptions;
        }
        @NonNull DeviceType deviceType = counterRecord.getDeviceTypeOrDefault();
        int cores = counterRecord.getCores();
        if (deviceType.supportsMultipleCores() && cores > 0) {
            assert (counterRecord.isPerCPU() || !deviceType.isCPU());
            return ChannelDescriptorUtils.makeChannelDescriptors(processingElementsReferenceSet, cores, deviceType);
        }
        return ChannelDescriptorUtils.makeChannelDescriptors(processingElementsReferenceSet, 1, deviceType);
    }

    public static @NonNull ProcessingElementReference @NonNull [] makeChannelDescriptors(@NonNull ProcessingElementReferenceSet processingElementsReferenceSet, int cores, @NonNull DeviceType dt) {
        switch (dt.getBasicDeviceType()) {
            case DISPLAY: 
            case SYSTEM_WIDE: {
                assert (cores <= 1);
                return new ProcessingElementReference[]{processingElementsReferenceSet.get(dt, 0L, 0)};
            }
            case VIDEO: {
                if (cores <= 1) {
                    return new ProcessingElementReference[]{processingElementsReferenceSet.get(dt, 0L, 0)};
                }
            }
            case CPU: 
            case GPU: {
                assert (cores > 0);
                @NonNull ProcessingElementReference @NonNull [] result = new ProcessingElementReference[cores];
                int core = 0;
                while (core < cores) {
                    result[core] = processingElementsReferenceSet.get(dt, 0L, core);
                    ++core;
                }
                return result;
            }
        }
        throw new AssertionError(dt);
    }
}

