/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.stream.parser;

import com.arm.streamline.analysis.dbnative.decoder.PackedValueUnpacker;
import com.arm.streamline.analysis.dbnative.stream.parser.DbConstants;
import com.arm.streamline.analysis.dbnative.stream.parser.IPrintable;
import com.arm.streamline.analysis.dbnative.stream.parser.IStreamParser;
import com.arm.streamline.analysis.dbnative.types.IndexTimestampSeqno;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ActivityStreamParser
implements IStreamParser<IStreamValue> {
    private static @NonNull StopStreamValue parseStopPayload(@NonNull IndexTimestampSeqno index, @NonNull PackedValueUnpacker reader) {
        int activity = reader.unpackOneInt();
        int deviceNo = reader.unpackOneInt();
        long utid = reader.unpackOneLong();
        return new StopStreamValue(index, activity, deviceNo, utid);
    }

    private static @NonNull SwitchStreamValue parseSwitchPayload(@NonNull IndexTimestampSeqno index, @NonNull PackedValueUnpacker reader) {
        int activity = reader.unpackOneInt();
        int deviceNo = reader.unpackOneInt();
        long utid = reader.unpackOneLong();
        int reason = reader.unpackOneInt();
        return new SwitchStreamValue(index, activity, deviceNo, utid, reason);
    }

    @Override
    public @NonNull IStreamValue parseDataPayload(@NonNull IndexTimestampSeqno index, @NonNull PackedValueUnpacker reader) {
        byte rType = reader.takeOneByte();
        switch (rType) {
            case 0: {
                return ActivityStreamParser.parseSwitchPayload(index, reader);
            }
            case 1: {
                return ActivityStreamParser.parseStopPayload(index, reader);
            }
        }
        throw new AssertionError((Object)"Unexpected rtype");
    }

    public static interface IStreamValue
    extends IPrintable {
        public <R, E extends Throwable> R accept(@NonNull IStreamValueVisitor<R, E> var1) throws E;
    }

    public static interface IStreamValueVisitor<R, E extends Throwable> {
        public R stop(int var1, long var2, long var4, int var6, @Nullable Integer var7) throws E;

        public R swtch(int var1, long var2, long var4, int var6, int var7, @Nullable Integer var8) throws E;
    }

    public static final class StopStreamValue
    implements IStreamValue {
        private final int activity;
        private final int deviceNo;
        private final @NonNull IndexTimestampSeqno index;
        private final @Nullable Integer utid;

        public StopStreamValue(@NonNull IndexTimestampSeqno index, int activity, int deviceNo, long utid) {
            this.index = index;
            this.activity = activity;
            this.deviceNo = deviceNo;
            this.utid = DbConstants.toUtid(utid);
        }

        @Override
        public <R, E extends Throwable> R accept(@NonNull IStreamValueVisitor<R, E> visitor) throws E {
            return visitor.stop(this.deviceNo, this.index.timestamp, this.index.sequenceNo, this.activity, this.utid);
        }

        @Override
        public void printToStream(@NonNull Appendable destination) throws IOException {
            destination.append("        " + String.valueOf(this.index) + " :: " + String.format("%1$2s", this.deviceNo) + " :: " + String.format("%1$4s", this.utid) + " :: stop :: " + this.activity);
            destination.append(System.lineSeparator());
        }
    }

    public static final class SwitchStreamValue
    implements IStreamValue {
        private final int activity;
        private final int deviceNo;
        private final @NonNull IndexTimestampSeqno index;
        private final int reason;
        private final @Nullable Integer utid;

        public SwitchStreamValue(@NonNull IndexTimestampSeqno index, int activity, int deviceNo, long utid, int reason) {
            this.index = index;
            this.activity = activity;
            this.deviceNo = deviceNo;
            this.utid = DbConstants.toUtid(utid);
            this.reason = reason;
        }

        @Override
        public <R, E extends Throwable> R accept(@NonNull IStreamValueVisitor<R, E> visitor) throws E {
            return visitor.swtch(this.deviceNo, this.index.timestamp, this.index.sequenceNo, this.activity, this.reason, this.utid);
        }

        @Override
        public void printToStream(@NonNull Appendable destination) throws IOException {
            destination.append("        " + String.valueOf(this.index) + " :: " + String.format("%1$2s", this.deviceNo) + " :: " + String.format("%1$4s", this.utid) + " :: switch :: " + this.activity + " :: " + this.reason);
            destination.append(System.lineSeparator());
        }
    }
}

