/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.io;

import com.arm.streamline.analysis.dbnative.io.IFileDataView;
import com.arm.streamline.jni.common.MMappedFile;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;

public final class MMappedFileDataView
implements IFileDataView {
    private static final long RETRY_TIME_LIMIT_NS = 3000000000L;
    private final @NonNull MMappedFile mmappedFile;
    private final @NonNull ByteOrder order;

    private static @NonNull MMappedFile tryMMappedFile(@NonNull File dataFile) throws IOException {
        long begin = System.nanoTime();
        while (true) {
            try {
                return new MMappedFile(dataFile);
            }
            catch (IOException t) {
                long delta = System.nanoTime() - begin;
                if (delta > 3000000000L) {
                    throw t;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.gc();
                continue;
            }
            break;
        }
    }

    public MMappedFileDataView(@NonNull File dataFile) throws IOException {
        this(dataFile, ByteOrder.LITTLE_ENDIAN);
    }

    public MMappedFileDataView(@NonNull File dataFile, @NonNull ByteOrder order) throws IOException {
        this.order = order;
        this.mmappedFile = MMappedFileDataView.tryMMappedFile(dataFile);
    }

    @Override
    public void close() throws IOException {
        this.mmappedFile.close();
    }

    @Override
    public long fileSize() {
        return this.mmappedFile.size();
    }

    @Override
    public @NonNull ByteBuffer getChunk(long offset, long size) throws IOException {
        if (offset < 0L) {
            throw new IOException("Invalid offset requested");
        }
        if (size <= 0L || size > Integer.MAX_VALUE) {
            throw new IOException("Invalid size requested");
        }
        if (offset + size > this.mmappedFile.size()) {
            throw new IOException("Exceeded file length");
        }
        int iSize = Math.toIntExact(size);
        byte[] b = new byte[iSize];
        this.mmappedFile.read(offset, b);
        return ByteBuffer.wrap(b).order(this.order);
    }

    @Override
    public boolean isClosed() throws IOException {
        return this.mmappedFile.size() == 0L;
    }
}

