/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.dbnative.index;

import com.arm.streamline.analysis.dbnative.index.L1IndexChunkReader;
import com.arm.streamline.analysis.dbnative.io.IFileDataView;
import com.arm.streamline.analysis.dbnative.types.L0IndexEntry;
import com.arm.streamline.analysis.dbnative.types.L1IndexEntry;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class L1IndexIterator
implements Iterator<L1IndexEntry> {
    private final @NonNull List<@NonNull L1IndexChunkReader> chunkReaders;
    private int firstIndex;
    private boolean hasNext;

    public static @NonNull L1IndexIterator createFromL0Index(@NonNull IFileDataView data, @NonNull List<@NonNull L0IndexEntry> l0IndexList) throws IOException {
        return new L1IndexIterator(L1IndexChunkReader.createFromL0Index(data, l0IndexList));
    }

    private L1IndexIterator(@NonNull List<@NonNull L1IndexChunkReader> chunkReaders) {
        this.chunkReaders = chunkReaders;
        this.firstIndex = 0;
        Collections.sort(this.chunkReaders);
        this.hasNext = !this.empty();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public L1IndexEntry next() throws NoSuchElementException {
        if (this.empty()) {
            throw new NoSuchElementException();
        }
        L1IndexEntry entry = this.getCurrentEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        try {
            this.hasNext = this.loadNextEntry();
        }
        catch (IOException e) {
            this.hasNext = false;
            throw new NoSuchElementException("IO error");
        }
        return entry;
    }

    private boolean empty() {
        return this.firstIndex >= this.chunkReaders.size();
    }

    private @Nullable L1IndexEntry getCurrentEntry() {
        assert (this.firstIndex < this.chunkReaders.size());
        return this.chunkReaders.get(this.firstIndex).getCurrentIndexEntry();
    }

    private boolean loadNextEntry() throws IOException {
        if (!this.empty() && !this.chunkReaders.get(this.firstIndex).next()) {
            while (!this.empty() && this.chunkReaders.get(this.firstIndex).empty()) {
                ++this.firstIndex;
            }
        }
        if (this.empty()) {
            return false;
        }
        int nextIndex = this.firstIndex + 1;
        while (nextIndex < this.chunkReaders.size()) {
            L1IndexEntry a = this.chunkReaders.get(nextIndex - 1).getCurrentIndexEntry();
            L1IndexEntry b = this.chunkReaders.get(nextIndex).getCurrentIndexEntry();
            if (a != null && a.isLessThanEqualTo(b)) break;
            Collections.swap(this.chunkReaders, nextIndex - 1, nextIndex);
            ++nextIndex;
        }
        return true;
    }
}

