/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.v3.metadata;

import com.arm.streamline.analysis.model.topology.CoresFile;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import com.arm.streamline.report.model.topology.GatorClusters;
import com.arm.streamline.report.model.topology.ICores;
import com.arm.streamline.report.model.topology.XmlClustersInfo;
import com.arm.utils.NullChecking;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;

public final class DevicesXmlReader {
    private static final String TAG_DEVICES = "devices";
    private static final String TAG_CLUSTERS = "clusters";
    private static final String TAG_CLUSTER = "cluster";
    private static final String TAG_CPU = "cpu";
    private static final String TAG_TOPOLOGY = "topology";
    private static final String ATTR_ID = "id";
    private static final String ATTR_VM = "vm";
    private static final String ATTR_NO = "no";
    private static final String ATTR_CPUID = "cpuid";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CLUSTER = "cluster";
    private static final String ATTR_CORE = "core";
    private static final String ATTR_THREAD = "thread";
    public final @NonNull CoresFile coresFile;
    public final @NonNull XmlClustersInfo clustersInfo;

    public DevicesXmlReader(@NonNull File fullPath, @NonNull ProcessingElementReferenceSet processingElementReferences) throws IOException {
        TIntObjectHashMap clusters = new TIntObjectHashMap();
        ArrayList<String> uniqueClusterNames = new ArrayList<String>();
        TreeMap<ProcessingElementReference, String> rawNames = new TreeMap<ProcessingElementReference, String>();
        HashMap<ProcessingElementReference, ProcessingElementTopology> rawTopologies = new HashMap<ProcessingElementReference, ProcessingElementTopology>();
        TObjectIntHashMap rawIds = new TObjectIntHashMap(10, 0.5f, 1048575);
        TObjectIntHashMap rawClusters = new TObjectIntHashMap(10, 0.5f, -1);
        Throwable throwable = null;
        Object var10_11 = null;
        try (XMLParser in = XMLParser.create((File)CommonFileUtils.getFile((File)fullPath));){
            String tag;
            while ((tag = in.nextTag()) != null) {
                if (!TAG_DEVICES.equals(tag)) {
                    throw new IOException("Invalid devices.xml");
                }
                String marker = in.getMarker();
                while ((tag = in.nextTag(marker)) != null) {
                    if (!TAG_CLUSTERS.equals(tag)) {
                        throw new IOException("Invalid devices.xml");
                    }
                    String marker2 = in.getMarker();
                    while ((tag = in.nextTag(marker2)) != null) {
                        if (!"cluster".equals(tag)) {
                            throw new IOException("Invalid devices.xml");
                        }
                        int clusterId = in.getIntegerAttribute(ATTR_ID, 0);
                        String clusterName = in.getAttribute(ATTR_NAME);
                        clusters.put(clusterId, (Object)clusterName);
                        if (!uniqueClusterNames.contains(clusterName)) {
                            uniqueClusterNames.add(clusterName);
                        }
                        String marker3 = in.getMarker();
                        while ((tag = in.nextTag(marker3)) != null) {
                            if (!TAG_CPU.equals(tag)) {
                                throw new IOException("Invalid devices.xml");
                            }
                            int vmUID = in.getIntegerAttribute(ATTR_VM, 0);
                            int deviceNo = in.getIntegerAttribute(ATTR_NO, 0);
                            int cpuId = in.getIntegerAttribute(ATTR_CPUID, 0);
                            String name = in.getAttribute(ATTR_NAME);
                            ProcessingElementReference peReference = processingElementReferences.get(DeviceType.CPU, (long)vmUID, deviceNo);
                            rawNames.put(peReference, name);
                            rawIds.put((Object)peReference, cpuId);
                            rawClusters.put((Object)peReference, clusterId);
                            String marker4 = in.getMarker();
                            while ((tag = in.nextTag(marker4)) != null) {
                                if (!TAG_TOPOLOGY.equals(tag)) {
                                    throw new IOException("Invalid devices.xml");
                                }
                                int osID = in.getIntegerAttribute(ATTR_ID);
                                int clusterID = in.getIntegerAttribute("cluster");
                                int coreID = in.getIntegerAttribute(ATTR_CORE);
                                int threadID = in.getIntegerAttribute(ATTR_THREAD);
                                rawTopologies.put(peReference, new ProcessingElementTopology(osID, clusterID, coreID, threadID));
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ArrayList<String> orderedCoreNames = new ArrayList<String>();
        ArrayList<ProcessingElementReference> orderedCores = new ArrayList<ProcessingElementReference>();
        ArrayList<ProcessingElementTopology> orderedTopologies = new ArrayList<ProcessingElementTopology>();
        TIntArrayList orderedCpuIds = new TIntArrayList();
        TIntIntHashMap orderedCoreToCluster = new TIntIntHashMap(10, 0.5f, -1, -1);
        for (Map.Entry entry : rawNames.entrySet()) {
            ProcessingElementReference peReference = (ProcessingElementReference)entry.getKey();
            String name = (String)entry.getValue();
            int cpuId = rawIds.get((Object)peReference);
            ProcessingElementTopology topology = (ProcessingElementTopology)rawTopologies.get(peReference);
            int clusterId = rawClusters.get((Object)peReference);
            int coreNo = orderedCores.size();
            orderedCores.add(peReference);
            orderedCoreNames.add(name);
            orderedTopologies.add(topology);
            orderedCpuIds.add(cpuId);
            orderedCoreToCluster.put(coreNo, clusterId);
        }
        this.coresFile = new CoresFile(orderedCoreNames, uniqueClusterNames, orderedCores, orderedTopologies, (int[])NullChecking.neverNull((Object)orderedCpuIds.toArray()));
        this.clustersInfo = new XmlClustersInfo(new GatorClusters((TIntObjectMap)clusters, (TIntIntMap)orderedCoreToCluster), (ICores)this.coresFile);
    }
}

