/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.v3;

import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityReader;
import com.arm.streamline.analysis.database.v3.AbstractDatabaseVmStreamReader;
import com.arm.streamline.analysis.dbnative.stream.StreamValueIterator;
import com.arm.streamline.analysis.dbnative.stream.parser.ContextSwitchReason;
import com.arm.streamline.analysis.dbnative.stream.parser.SchedulerStreamParser;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.function.IThrowingSupplier;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SchedulerTraceActivityStreamReader
extends AbstractDatabaseVmStreamReader<IAnalysisActivityReader.IValue<ProcessingElementReference>, PerVmStreamValue>
implements IAnalysisActivityReader<ProcessingElementReference> {
    private final @NonNull ProcessingElementReference @NonNull [] processingElementsForAllVms;

    private static int adaptActivity(@Nullable Integer utid, IUniqueIds applications) {
        if (utid == null) {
            return 2;
        }
        IUniqueThreadID uthread = SchedulerTraceActivityStreamReader.lookupThreadId(applications, utid);
        if (uthread.isIdle()) {
            return 0;
        }
        if (uthread.isKernel()) {
            return 2;
        }
        return 1;
    }

    private static int adaptReason(@NonNull ContextSwitchReason reason) {
        switch (reason) {
            case contention: {
                return 1;
            }
            case scheduled: 
            case wait_event: 
            case stopped: 
            case exited: 
            case idle: {
                return 0;
            }
            case wait_io: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unexpected value for context switch reason: " + String.valueOf((Object)reason));
    }

    private static @NonNull IUniqueThreadID lookupThreadId(IUniqueIds applications, @NonNull Integer origUtid) {
        Optional candidate = applications.findThread(origUtid.intValue());
        if (candidate.isPresent()) {
            return (IUniqueThreadID)candidate.get();
        }
        throw new IllegalStateException("Unique thread id not found: " + String.valueOf(origUtid));
    }

    public SchedulerTraceActivityStreamReader(@NonNull ProcessingElementReference @NonNull [] processingElementsForAllVms, @NonNull List<@NonNull VmStream> vmStreams) {
        super(vmStreams);
        this.processingElementsForAllVms = processingElementsForAllVms;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public @NonNull List<@NonNull ProcessingElementReference> getChannels() {
        return Arrays.asList(this.processingElementsForAllVms);
    }

    @Override
    public @Nullable IAnalysisActivityReader.IValue<ProcessingElementReference> read() throws IOException {
        return (IAnalysisActivityReader.IValue)this.doRead();
    }

    @Override
    protected @NonNull IAnalysisActivityReader.IValue<ProcessingElementReference> mapStreamValue(@NonNull PerVmStreamValue value) {
        return value.convert(this.processingElementsForAllVms);
    }

    public static class PerVmStreamValue
    implements AbstractDatabaseVmStreamReader.IStreamValue {
        private final @NonNull IUniqueIds applications;
        private final SchedulerStreamParser.StreamValue nextItem;
        private final int vmPeOffset;

        public PerVmStreamValue(int vmPeOffset, int deviceNoCount, @NonNull IUniqueIds applications, SchedulerStreamParser.StreamValue nextItem) {
            this.vmPeOffset = vmPeOffset;
            this.applications = applications;
            this.nextItem = nextItem;
            assert (nextItem.deviceNo < deviceNoCount);
        }

        public @NonNull IAnalysisActivityReader.IValue<ProcessingElementReference> convert(final @NonNull ProcessingElementReference @NonNull [] pes) {
            return new IAnalysisActivityReader.IValue<ProcessingElementReference>(){

                @Override
                public boolean accept(@NonNull IAnalysisActivityReader.IValueVisitor<ProcessingElementReference> visitor) throws IOException {
                    switch (nextItem.type) {
                        case CONTEXT_SWITCH: {
                            return visitor.swtch(this.getChannel(), nextItem.index.timestamp, nextItem.utid, SchedulerTraceActivityStreamReader.adaptActivity(nextItem.utid, applications), SchedulerTraceActivityStreamReader.adaptReason(nextItem.reason));
                        }
                        case THREAD_EXIT: {
                            if (!$assertionsDisabled && nextItem.utid == null) {
                                throw new AssertionError((Object)"Unexpected null utid for thread_exit event");
                            }
                            return visitor.free(nextItem.index.timestamp, nextItem.utid);
                        }
                    }
                    throw new RuntimeException("Unexpected kind of scheduler trace event " + String.valueOf((Object)nextItem.type));
                }

                @Override
                public @NonNull ProcessingElementReference getChannel() {
                    return pes[this.getChannelIndex()];
                }

                @Override
                public int getChannelIndex() {
                    return vmPeOffset + nextItem.deviceNo;
                }

                @Override
                public long getTimestamp() {
                    return nextItem.index.timestamp;
                }

                @Override
                public boolean isSwitch() {
                    return nextItem.type == SchedulerStreamParser.EventKind.CONTEXT_SWITCH;
                }
            };
        }

        @Override
        public long getSequenceNo() {
            return this.nextItem.index.timestamp;
        }

        @Override
        public long getTimestamp() {
            return this.nextItem.index.timestamp;
        }
    }

    public static class VmStream
    implements IThrowingSupplier<PerVmStreamValue, IOException> {
        private final @NonNull IUniqueIds applications;
        private final int deviceNoCount;
        private final int posOfFirstVmPrElement;
        private final StreamValueIterator<SchedulerStreamParser.StreamValue> valueIterator;
        private final long vmuid;

        public VmStream(long vmuid, int posOfFirstVmPrElement, int deviceNoCount, @NonNull IUniqueIds applications, StreamValueIterator<SchedulerStreamParser.StreamValue> valueIterator) {
            this.vmuid = vmuid;
            this.applications = applications;
            this.valueIterator = valueIterator;
            this.posOfFirstVmPrElement = posOfFirstVmPrElement;
            this.deviceNoCount = deviceNoCount;
        }

        public @Nullable PerVmStreamValue get() throws IOException {
            if (!this.valueIterator.hasNext()) {
                return null;
            }
            SchedulerStreamParser.StreamValue nextItem = this.valueIterator.next();
            return new PerVmStreamValue(this.posOfFirstVmPrElement, this.deviceNoCount, this.applications, nextItem);
        }

        public long getVmuid() {
            return this.vmuid;
        }
    }
}

