/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.v3;

import com.arm.streamline.analysis.database.api.icounter.spe.ISpeOperationTypePredicate;
import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingPerChannelReader;
import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingReader;
import com.arm.streamline.analysis.database.api.profiling.IProfileEvent;
import com.arm.streamline.analysis.database.api.profiling.IProfileSource;
import com.arm.streamline.analysis.database.api.profiling.ProfileDataPoint;
import com.arm.streamline.analysis.database.stream.icounter.spe.Messages;
import com.arm.streamline.analysis.database.v3.AbstractDatabaseVmStreamReader;
import com.arm.streamline.analysis.database.v3.metadata.IExecutablePathsMap;
import com.arm.streamline.analysis.dbnative.index.L1IndexIterator;
import com.arm.streamline.analysis.dbnative.io.IFileDataView;
import com.arm.streamline.analysis.dbnative.stream.StreamValueIterator;
import com.arm.streamline.analysis.dbnative.stream.parser.SpeStreamParser;
import com.arm.streamline.analysis.dbnative.types.L0IndexEntry;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.model.icounters.ICounterInstructionCounterMetadata;
import com.arm.streamline.common.xml.spe.SpeCounterProperties;
import com.arm.streamline.common.xml.spe.SpeDataSourceProperties;
import com.arm.streamline.common.xml.spe.SpeOperationTypeClass;
import com.arm.streamline.common.xml.spe.SpePacketEventProperties;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.report.shared.icounter.InstructionCounterMetadataXml;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.IThrowingSupplier;
import gnu.trove.list.TIntList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseSpeReader
extends AbstractDatabaseVmStreamReader<IAnalysisCodeProfilingPerChannelReader.IValue, IStreamValue>
implements IAnalysisCodeProfilingReader {
    public static final @NonNull Integer COLOUR_RBG_CLEAR = 15909950;
    public static final @NonNull Integer COLOUR_RBG_HIT = 7918216;
    public static final @NonNull Integer COLOUR_RBG_MISS = 16761512;
    public static final @NonNull Integer COLOUR_RBG_SET = 7899346;

    public static @Nullable SpeOperationTypeClass mapOpClazz(byte clazz) throws IOException {
        switch (clazz) {
            case 0: {
                return SpeOperationTypeClass.OTHER;
            }
            case 1: {
                return SpeOperationTypeClass.LOAD_STORE;
            }
            case 2: {
                return SpeOperationTypeClass.BRANCH;
            }
        }
        throw new IOException("Unexpected op-type class");
    }

    public DatabaseSpeReader(@NonNull List<@NonNull VmStream> vmStreams) {
        super(vmStreams);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public @Nullable IAnalysisCodeProfilingPerChannelReader.IValue read() throws IOException {
        return (IAnalysisCodeProfilingPerChannelReader.IValue)this.doRead();
    }

    @Override
    protected @NonNull IAnalysisCodeProfilingPerChannelReader.IValue mapStreamValue(@NonNull IStreamValue value) {
        return value;
    }

    public static final class DescriptorTransformer
    implements IDescriptorTransformer {
        protected static final @NonNull IntUnaryOperator DEFAULT_COUNTER_MAPPER = n -> n;
        protected static final @NonNull IntUnaryOperator LOG2_COUNTER_MAPPER = n -> 32 - Integer.numberOfLeadingZeros(n);
        private static final int DP_ID_HIT = 1;
        private static final int DP_ID_MISS = 0;
        private final @NonNull Map<@NonNull Integer, @NonNull PerClusterData> perClusterData = new HashMap<Integer, PerClusterData>();
        private final @NonNull Map<@NonNull SpeTargetDescription, @NonNull IThrowingFunction<@NonNull SpeStreamParser.StreamValue, @NonNull IStreamValue, IOException>> perDescriptorTransforms = new HashMap<SpeTargetDescription, IThrowingFunction<SpeStreamParser.StreamValue, IStreamValue, IOException>>();
        private final @NonNull TLongObjectHashMap<TIntObjectHashMap<IThrowingFunction<@NonNull SpeStreamParser.StreamValue, @NonNull IStreamValue, IOException>>> transformers = new TLongObjectHashMap(0, 0.5f, -1L);

        private static @NonNull IProfileEvent makeCounterEvent(@NonNull SpeCounterProperties properties, @NonNull String targetName, boolean hasMultipleDescriptors, @Nullable Integer clusterID) {
            String title = hasMultipleDescriptors ? String.format("%s (%s)", properties.getName(), targetName) : properties.getName();
            return new IProfileEvent.SimpleProfileEvent(IProfileSource.SPE, (InstructionCounterMetadataXml)new InstructionCounterMetadataXml.CounterInstructionCounterMetadata(title, properties.getDescription(), properties.getUnit(), clusterID, null, switch (properties.getType()) {
                case SpeCounterProperties.Type.ABSOLUTE -> ICounterInstructionCounterMetadata.Mode.DEFAULT;
                case SpeCounterProperties.Type.LATENCY -> ICounterInstructionCounterMetadata.Mode.LOG2_N_PLUS_1;
                default -> throw new AssertionError(properties.getType());
            }));
        }

        private static @NonNull IProfileEvent makeDataSourcesEvent(@NonNull Set<@NonNull SpeDataSourceProperties> dataSources, @NonNull String targetName, boolean hasMultipleDescriptors, @Nullable Integer clusterID) {
            TreeSet<SpeDataSourceProperties> sorted = new TreeSet<SpeDataSourceProperties>(Comparator.comparing(SpeDataSourceProperties::getIndex));
            sorted.addAll(dataSources);
            List dataPoints = sorted.stream().map(ds -> new InstructionCounterMetadataXml.RatioInstructionCounterDataPoint(ds.getIndex(), ds.getName(), null)).collect(Collectors.toList());
            String title = hasMultipleDescriptors ? String.format("%s (%s)", Messages.SpeDataSourceRatioInstructionCounterWriter_DATA_SOURCE_TITLE, targetName) : Messages.SpeDataSourceRatioInstructionCounterWriter_DATA_SOURCE_TITLE;
            return new IProfileEvent.SimpleProfileEvent(IProfileSource.SPE, (InstructionCounterMetadataXml)new InstructionCounterMetadataXml.RatioInstructionCounterMetadata(title, Messages.SpeDataSourceRatioInstructionCounterWriter_DATA_SOURCE_DESCRIPTION, "", clusterID, null, dataPoints));
        }

        private static @NonNull IProfileEvent makeEventEvent(@NonNull SpePacketEventProperties properties, @NonNull String targetName, boolean hasMultipleDescriptors, @Nullable Integer clusterID) {
            String missLabel;
            String hitLabel;
            // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull SpePacketEventProperties.ShowByDefault showByDefault = properties.getShowByDefault();
            boolean useNeutralColours = switch (properties.getSetMode()) {
                case SpePacketEventProperties.SetMode.NEGATIVE -> {
                    hitLabel = properties.getClearLabel();
                    missLabel = properties.getSetLabel();
                    yield false;
                }
                case SpePacketEventProperties.SetMode.NEUTRAL -> {
                    hitLabel = properties.getSetLabel();
                    missLabel = properties.getClearLabel();
                    yield true;
                }
                case SpePacketEventProperties.SetMode.POSITIVE -> {
                    hitLabel = properties.getSetLabel();
                    missLabel = properties.getClearLabel();
                    yield false;
                }
                default -> throw new AssertionError(properties.getSetMode());
            };
            int @Nullable [] dpToShowByDefault = switch (showByDefault) {
                case SpePacketEventProperties.ShowByDefault.CLEAR -> new int[]{1};
                case SpePacketEventProperties.ShowByDefault.SET -> new int[1];
                case SpePacketEventProperties.ShowByDefault.RATIO -> {
                    int[] v0 = new int[2];
                    v0[0] = 1;
                    yield v0;
                }
                default -> throw new AssertionError(showByDefault);
            };
            @NonNull Integer hitColour = useNeutralColours ? COLOUR_RBG_SET : COLOUR_RBG_HIT;
            @NonNull Integer missColour = useNeutralColours ? COLOUR_RBG_CLEAR : COLOUR_RBG_MISS;
            String title = hasMultipleDescriptors ? String.format("%s (%s)", properties.getRatioLabel(), targetName) : properties.getRatioLabel();
            return new IProfileEvent.SimpleProfileEvent(IProfileSource.SPE, (InstructionCounterMetadataXml)new InstructionCounterMetadataXml.RatioInstructionCounterMetadata(title, (String)NullChecking.neverNullOr((Object)properties.getDescription(), (Object)""), "", clusterID, dpToShowByDefault, Arrays.asList(new InstructionCounterMetadataXml.RatioInstructionCounterDataPoint(0, missLabel, missColour), new InstructionCounterMetadataXml.RatioInstructionCounterDataPoint(1, hitLabel, hitColour))));
        }

        public DescriptorTransformer(@NonNull TLongObjectHashMap<TIntObjectHashMap<SpeTargetDescription>> speDescriptorMap, @NonNull IClustersInfo clustersInfo) {
            long nDistinctDescriptors = speDescriptorMap.valueCollection().stream().map(TIntObjectHashMap::valueCollection).flatMap(Collection::stream).distinct().count();
            int[] clusters = clustersInfo.getCpuClusterIds().values();
            Range[] cpuRangeIndexedByCluster = new Range[clusters.length];
            int[] nArray = clusters;
            int n = clusters.length;
            int n2 = 0;
            while (n2 < n) {
                int cluster = nArray[n2];
                TIntList devices = clustersInfo.getCores(cluster);
                assert (devices != null);
                IntSummaryStatistics stats = Arrays.stream(devices.toArray()).summaryStatistics();
                cpuRangeIndexedByCluster[cluster] = new Range(stats.getMin(), stats.getMax() + 1);
                ++n2;
            }
            speDescriptorMap.forEachEntry((vm, map) -> {
                if (map == null) {
                    throw new AssertionError((Object)"Invalid / missing SPE target description");
                }
                TIntObjectHashMap vmTransformers = new TIntObjectHashMap(0, 0.5f, -1);
                map.forEachEntry((dev, desc) -> {
                    assert (desc != null);
                    int cluster = clustersInfo.getClusterIndex(dev);
                    Range range = cpuRangeIndexedByCluster[cluster];
                    assert (range != null);
                    IThrowingFunction transformer = this.perDescriptorTransforms.computeIfAbsent((SpeTargetDescription)desc, kv -> this.createDescriptorTransform((SpeTargetDescription)kv, nDistinctDescriptors != 1L, cluster, range));
                    vmTransformers.put(dev, (Object)transformer);
                    return true;
                });
                this.transformers.put(vm, (Object)vmTransformers);
                return true;
            });
        }

        @Override
        public @Nullable IThrowingFunction<@NonNull SpeStreamParser.StreamValue, @NonNull IStreamValue, IOException> createTransformer(long vmUID) throws IOException {
            TIntObjectHashMap map = (TIntObjectHashMap)this.transformers.get(vmUID);
            if (map == null) {
                return null;
            }
            return payload -> {
                IThrowingFunction transformer = (IThrowingFunction)map.get(payload.deviceNo);
                if (transformer == null) {
                    throw new AssertionError((Object)"Expected transformer");
                }
                return (IStreamValue)transformer.apply(payload);
            };
        }

        private @NonNull IDataPointOp createCounterOp(@NonNull SpeCounterProperties properties, @NonNull String targetName, boolean hasMultipleDescriptors, @NonNull Integer clusterID) {
            IProfileEvent event = this.perClusterData.computeIfAbsent((Integer)clusterID, (Function<Integer, PerClusterData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$10(java.lang.Integer ), (Ljava/lang/Integer;)Lcom/arm/streamline/analysis/database/v3/DatabaseSpeReader$DescriptorTransformer$PerClusterData;)()).counterEvents.computeIfAbsent(properties, k -> DescriptorTransformer.makeCounterEvent(k, targetName, hasMultipleDescriptors, clusterID));
            @NonNull IntUnaryOperator mapper = switch (properties.getType()) {
                case SpeCounterProperties.Type.ABSOLUTE -> DEFAULT_COUNTER_MAPPER;
                case SpeCounterProperties.Type.LATENCY -> LOG2_COUNTER_MAPPER;
                default -> throw new AssertionError(properties.getType());
            };
            int index = properties.getIndex();
            return (visitor, value, utid, executablePaths, offsets) -> {
                if (index >= 0 && index < 256 && value.counters.containsKey((byte)index)) {
                    int dp = mapper.applyAsInt(Short.toUnsignedInt(value.counters.get((byte)index)));
                    visitor.backtrace(value.index.timestamp, new ProfileDataPoint(event, dp), utid, executablePaths, offsets, 1L, null);
                }
            };
        }

        private @NonNull IDataPointOp createDataSourceOp(@NonNull Set<@NonNull SpeDataSourceProperties> dataSources, @NonNull String targetName, boolean hasMultipleDescriptors, @NonNull Integer clusterID) {
            IProfileEvent event = this.perClusterData.computeIfAbsent((Integer)clusterID, (Function<Integer, PerClusterData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$13(java.lang.Integer ), (Ljava/lang/Integer;)Lcom/arm/streamline/analysis/database/v3/DatabaseSpeReader$DescriptorTransformer$PerClusterData;)()).dataSourceSetEvents.computeIfAbsent(dataSources, k -> DescriptorTransformer.makeDataSourcesEvent(k, targetName, hasMultipleDescriptors, clusterID));
            return (visitor, value, utid, executablePaths, offsets) -> {
                Short index = value.dataSources;
                if (index != null) {
                    visitor.backtrace(value.index.timestamp, new ProfileDataPoint(event, Short.toUnsignedInt(index)), utid, executablePaths, offsets, 1L, null);
                }
            };
        }

        private @NonNull IThrowingFunction<@NonNull SpeStreamParser.StreamValue, @NonNull IStreamValue, IOException> createDescriptorTransform(@NonNull SpeTargetDescription descriptor, boolean hasMultipleDescriptors, @NonNull Integer clusterID, @Nullable Range range) {
            ArrayList<IDataPointOp> dataPointOps = new ArrayList<IDataPointOp>();
            for (SpeCounterProperties counter : descriptor.getAllSpeCounters()) {
                dataPointOps.add(this.createCounterOp(counter, descriptor.getName(), hasMultipleDescriptors, clusterID));
            }
            dataPointOps.add(this.createDataSourceOp(descriptor.getAllSpeDataSources(), descriptor.getName(), hasMultipleDescriptors, clusterID));
            for (SpePacketEventProperties event : descriptor.getAllSpePacketEvents()) {
                dataPointOps.add(this.createEventOp(event, descriptor.getName(), hasMultipleDescriptors, clusterID));
            }
            return payload -> new IStreamValue((SpeStreamParser.StreamValue)payload, range, dataPointOps){
                private final /* synthetic */ SpeStreamParser.StreamValue val$payload;
                private final /* synthetic */ Range val$range;
                private final /* synthetic */ ArrayList val$dataPointOps;
                {
                    this.val$payload = streamValue;
                    this.val$range = range;
                    this.val$dataPointOps = arrayList;
                }

                @Override
                public boolean accept(@NonNull IAnalysisCodeProfilingPerChannelReader.IValueVisitor visitor) throws IOException, InterruptedException {
                    SpeStreamParser.SpeAddressAndTag address = this.val$payload.pc;
                    Long events = this.val$payload.events;
                    if (events == null) {
                        return true;
                    }
                    if (this.val$range != null && !this.val$range.withinRange(this.val$payload.deviceNo)) {
                        return true;
                    }
                    int utid = this.val$payload.utid != null ? this.val$payload.utid : -1;
                    IExecutablePath[] paths = new IExecutablePath[]{address.path};
                    long[] offsets = new long[]{address.offsetOrAddress};
                    for (IDataPointOp op : this.val$dataPointOps) {
                        op.accept(visitor, this.val$payload, utid, paths, offsets);
                    }
                    return true;
                }

                @Override
                public long getSequenceNo() {
                    return this.val$payload.index.sequenceNo;
                }

                @Override
                public long getTimestamp() {
                    return this.val$payload.index.timestamp;
                }
            };
        }

        private @NonNull IDataPointOp createEventOp(@NonNull SpePacketEventProperties properties, @NonNull String targetName, boolean hasMultipleDescriptors, @NonNull Integer clusterID) {
            IProfileEvent event = this.perClusterData.computeIfAbsent((Integer)clusterID, (Function<Integer, PerClusterData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$17(java.lang.Integer ), (Ljava/lang/Integer;)Lcom/arm/streamline/analysis/database/v3/DatabaseSpeReader$DescriptorTransformer$PerClusterData;)()).eventEvents.computeIfAbsent(properties, k -> DescriptorTransformer.makeEventEvent(k, targetName, hasMultipleDescriptors, clusterID));
            ProfileDataPoint dpHit = new ProfileDataPoint(event, 1);
            ProfileDataPoint dpMiss = new ProfileDataPoint(event, 0);
            @NonNull ISpeOperationTypePredicate operationTypePredicate = (opClass, subclass) -> {
                if (properties.getValidOpTypes().isEmpty()) {
                    return true;
                }
                if (opClass == null) {
                    return false;
                }
                return properties.getValidOpTypes().stream().anyMatch(type -> type.matches(opClass, subclass));
            };
            int bitIndex = properties.getBitPosition();
            @Nullable Integer conditionBit = properties.getConditionBit();
            boolean accessIsClear = properties.isConditionalAccessOnBitClear();
            boolean hitIsClear = switch (properties.getSetMode()) {
                case SpePacketEventProperties.SetMode.NEGATIVE -> true;
                case SpePacketEventProperties.SetMode.NEUTRAL -> false;
                case SpePacketEventProperties.SetMode.POSITIVE -> false;
                default -> throw new AssertionError(properties.getSetMode());
            };
            if (conditionBit != null) {
                int accessBitIndex = conditionBit;
                if (accessBitIndex < 0 || accessBitIndex > 63 || bitIndex < 0 || bitIndex > 63) {
                    throw new IllegalArgumentException();
                }
                long accessMask = 1L << accessBitIndex;
                long mask = 1L << bitIndex;
                return (visitor, value, utid, executablePaths, offsets) -> {
                    Long events = value.events;
                    if (events != null) {
                        byte opSubClass;
                        boolean accessBitSet = (events & accessMask) == accessMask;
                        boolean accessHit = accessIsClear ^ accessBitSet;
                        boolean bitSet = (events & mask) == mask;
                        boolean hit = hitIsClear ^ bitSet;
                        SpeStreamParser.SpeOpTypeTuple opType = value.opType;
                        SpeOperationTypeClass opClass = opType != null ? DatabaseSpeReader.mapOpClazz(opType.clazz) : null;
                        byte by = opSubClass = opType != null ? opType.subclazz : (byte)0;
                        if (accessHit && operationTypePredicate.test(opClass, opSubClass)) {
                            visitor.backtrace(value.index.timestamp, hit ? dpHit : dpMiss, utid, executablePaths, offsets, 1L, null);
                        }
                    }
                };
            }
            if (bitIndex < 0 || bitIndex > 63) {
                throw new IllegalArgumentException();
            }
            long mask = 1L << bitIndex;
            return (visitor, value, utid, executablePaths, offsets) -> {
                Long events = value.events;
                if (events != null) {
                    byte opSubClass;
                    boolean bitSet = (events & mask) == mask;
                    boolean hit = hitIsClear ^ bitSet;
                    SpeStreamParser.SpeOpTypeTuple opType = value.opType;
                    SpeOperationTypeClass opClass = opType != null ? DatabaseSpeReader.mapOpClazz(opType.clazz) : null;
                    byte by = opSubClass = opType != null ? opType.subclazz : (byte)0;
                    if (operationTypePredicate.test(opClass, opSubClass)) {
                        visitor.backtrace(value.index.timestamp, hit ? dpHit : dpMiss, utid, executablePaths, offsets, 1L, null);
                    }
                }
            };
        }

        private static /* synthetic */ PerClusterData lambda$10(Integer k) {
            return new PerClusterData();
        }

        private static /* synthetic */ PerClusterData lambda$13(Integer k) {
            return new PerClusterData();
        }

        private static /* synthetic */ PerClusterData lambda$17(Integer k) {
            return new PerClusterData();
        }

        private record PerClusterData(@NonNull Map<@NonNull SpeCounterProperties, @NonNull IProfileEvent> counterEvents, @NonNull Map<@NonNull Set<@NonNull SpeDataSourceProperties>, @NonNull IProfileEvent> dataSourceSetEvents, @NonNull Map<@NonNull SpePacketEventProperties, @NonNull IProfileEvent> eventEvents) {
            public PerClusterData() {
                this(new HashMap<SpeCounterProperties, IProfileEvent>(), new HashMap<Set<SpeDataSourceProperties>, IProfileEvent>(), new HashMap<SpePacketEventProperties, IProfileEvent>());
            }
        }

        private static class Range {
            private final int startInclusive;
            private final int endExclusive;

            public Range(int startInclusive, int endExclusive) {
                assert (startInclusive < endExclusive);
                this.startInclusive = startInclusive;
                this.endExclusive = endExclusive;
            }

            public boolean withinRange(int value) {
                return value >= this.startInclusive && value < this.endExclusive;
            }
        }
    }

    @FunctionalInterface
    public static interface IDataPointOp {
        public void accept(@NonNull IAnalysisCodeProfilingPerChannelReader.IValueVisitor var1, @NonNull SpeStreamParser.StreamValue var2, int var3, @Nullable IExecutablePath @NonNull [] var4, long @NonNull [] var5) throws IOException, InterruptedException;
    }

    @FunctionalInterface
    public static interface IDescriptorTransformer {
        public @Nullable IThrowingFunction<@NonNull SpeStreamParser.StreamValue, @NonNull IStreamValue, IOException> createTransformer(long var1) throws IOException;
    }

    public static interface IStreamValue
    extends AbstractDatabaseVmStreamReader.IStreamValue,
    IAnalysisCodeProfilingPerChannelReader.IValue {
    }

    public static final class VmStream
    implements IThrowingSupplier<IStreamValue, IOException> {
        private final @NonNull IThrowingFunction<@NonNull SpeStreamParser.StreamValue, @NonNull IStreamValue, IOException> transformer;
        private final @NonNull StreamValueIterator<SpeStreamParser.StreamValue> valueIterator;

        public VmStream(@NonNull IThrowingFunction<@NonNull SpeStreamParser.StreamValue, @NonNull IStreamValue, IOException> transformer, @NonNull IExecutablePathsMap executablePaths, long vmuid, @NonNull List<@NonNull L0IndexEntry> l0Entries, @NonNull IFileDataView view) throws IOException {
            this.transformer = transformer;
            this.valueIterator = new StreamValueIterator<SpeStreamParser.StreamValue>(view, L1IndexIterator.createFromL0Index(view, l0Entries), new SpeStreamParser(executablePaths));
        }

        public @Nullable IStreamValue get() throws IOException {
            if (!this.valueIterator.hasNext()) {
                return null;
            }
            return (IStreamValue)this.transformer.apply((Object)this.valueIterator.next());
        }
    }
}

