/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.v3;

import com.arm.streamline.analysis.database.api.profiling.BacktraceSource;
import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingPerChannelReader;
import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingReader;
import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.database.api.profiling.IProfileEvent;
import com.arm.streamline.analysis.database.api.profiling.IProfileSource;
import com.arm.streamline.analysis.database.api.profiling.ProfileDataPoint;
import com.arm.streamline.analysis.database.stream.UtidToLong;
import com.arm.streamline.analysis.database.v3.AbstractDatabaseVmStreamReader;
import com.arm.streamline.analysis.database.v3.metadata.IExecutablePathsMap;
import com.arm.streamline.analysis.dbnative.index.L1IndexIterator;
import com.arm.streamline.analysis.dbnative.io.IFileDataView;
import com.arm.streamline.analysis.dbnative.stream.StreamValueIterator;
import com.arm.streamline.analysis.dbnative.stream.parser.BacktraceStreamParser;
import com.arm.streamline.analysis.dbnative.stream.parser.ContextSwitchReason;
import com.arm.streamline.analysis.dbnative.stream.parser.ExecutableRelativeRegisterValues;
import com.arm.streamline.analysis.dbnative.stream.parser.OffsetsAddressesWithExecutablePaths;
import com.arm.streamline.analysis.dbnative.stream.parser.PerfSampleRegsAbi;
import com.arm.streamline.analysis.dbnative.stream.parser.SampleClassification;
import com.arm.streamline.analysis.dbnative.stream.parser.SampleCounterValues;
import com.arm.streamline.analysis.dbnative.types.L0IndexEntry;
import com.arm.streamline.analysis.model.metrics.MetricRecord;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.model.icounters.InstructionCounterSourceMetadata;
import com.arm.streamline.report.shared.icounter.InstructionCounterMetadataXml;
import com.arm.utils.ArrayUtils;
import com.arm.utils.collections.ObjLongPair;
import com.arm.utils.collections.Pair;
import com.arm.utils.function.IThrowingSupplier;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseBacktraceReader
extends AbstractDatabaseVmStreamReader<IAnalysisCodeProfilingPerChannelReader.IValue, VmStream.StreamValue>
implements IAnalysisCodeProfilingReader {
    public static final int PERF_REG_ARM32_LR = 14;
    public static final int PERF_REG_ARM32_PC = 15;
    public static final int PERF_REG_ARM64_LR = 30;
    public static final int PERF_REG_ARM64_PC = 32;

    private static @NonNull OffsetsAddressesWithExecutablePaths cleanupCallchain(@NonNull OffsetsAddressesWithExecutablePaths addressesAndPathInfo, @NonNull PerfSampleRegsAbi abi, @Nullable Pair<@NonNull ObjLongPair<@Nullable IExecutablePath>, @NonNull ObjLongPair<@Nullable IExecutablePath>> lrAndPc) {
        IExecutablePath[] callchainPaths = addressesAndPathInfo.getExecutablePaths();
        long[] callchainOffsets = addressesAndPathInfo.getRelOffsetsOrAddresses();
        assert (callchainPaths.length == callchainOffsets.length);
        if (callchainPaths.length <= 1) {
            return addressesAndPathInfo;
        }
        IExecutablePath lrToInsertPath = null;
        long lrToInsertOffset = 0L;
        if (lrAndPc != null) {
            boolean insertRealLr;
            IExecutablePath lrPath = (IExecutablePath)((ObjLongPair)lrAndPc.first).first;
            long lrOffset = ((ObjLongPair)lrAndPc.first).second;
            IExecutablePath pcPath = (IExecutablePath)((ObjLongPair)lrAndPc.second).first;
            long pcOffset = ((ObjLongPair)lrAndPc.second).second;
            boolean lrIsInsertedAlready = callchainPaths.length > 1 && callchainPaths[1] == lrPath && callchainOffsets[1] == lrOffset;
            boolean bl = insertRealLr = callchainPaths[0] == pcPath && callchainOffsets[0] == pcOffset && abi != PerfSampleRegsAbi.none && !lrIsInsertedAlready;
            if (insertRealLr) {
                lrToInsertPath = lrPath;
                lrToInsertOffset = lrOffset;
            }
        }
        IExecutablePath[] newPaths = new IExecutablePath[callchainPaths.length + 1];
        long[] newOffsets = new long[callchainOffsets.length + 1];
        newPaths[0] = callchainPaths[0];
        newOffsets[0] = callchainOffsets[0];
        newPaths[1] = lrToInsertPath;
        newOffsets[1] = lrToInsertOffset;
        System.arraycopy(callchainPaths, 1, newPaths, 2, callchainPaths.length - 1);
        System.arraycopy(callchainOffsets, 1, newOffsets, 2, callchainOffsets.length - 1);
        return new OffsetsAddressesWithExecutablePaths(newPaths, newOffsets);
    }

    private static @Nullable Pair<@NonNull ObjLongPair<@Nullable IExecutablePath>, @NonNull ObjLongPair<@Nullable IExecutablePath>> extractAbiRegisters(@NonNull ExecutableRelativeRegisterValues registersInfo) {
        switch (registersInfo.getAbi()) {
            case abi_32: {
                return DatabaseBacktraceReader.extractRegisters32(registersInfo, registersInfo.isHostIs64Bit());
            }
            case abi_64: {
                assert (registersInfo.isHostIs64Bit());
                return DatabaseBacktraceReader.extractRegisters64(registersInfo);
            }
            case none: {
                if (registersInfo.isHostIs64Bit()) {
                    return DatabaseBacktraceReader.extractRegisters64(registersInfo);
                }
                return DatabaseBacktraceReader.extractRegisters32(registersInfo, false);
            }
        }
        throw new AssertionError((Object)registersInfo.getAbi());
    }

    private static @Nullable Pair<@NonNull ObjLongPair<@Nullable IExecutablePath>, @NonNull ObjLongPair<@Nullable IExecutablePath>> extractRegisters32(@NonNull ExecutableRelativeRegisterValues registersInfo, boolean registersHostIs64bit) {
        Pair<ObjLongPair<IExecutablePath>, ObjLongPair<IExecutablePath>> result64;
        if (registersHostIs64bit && (result64 = DatabaseBacktraceReader.extractRegisters64(registersInfo)) != null) {
            return result64;
        }
        int posLr32 = ArrayUtils.indexOf((long[])registersInfo.getPerfRegisterIndices(), (long)14L);
        int posPc32 = ArrayUtils.indexOf((long[])registersInfo.getPerfRegisterIndices(), (long)15L);
        if (posLr32 >= 0 && posPc32 >= 0) {
            boolean pcZero32;
            IExecutablePath lrPath32 = registersInfo.getExecutablePaths()[posLr32];
            long lrValue32 = registersInfo.getRegisterOffsetsOrAddresses()[posLr32];
            boolean lrZero32 = lrPath32 == null && lrValue32 == 0L;
            IExecutablePath pcPath32 = registersInfo.getExecutablePaths()[posPc32];
            long pcValue32 = registersInfo.getRegisterOffsetsOrAddresses()[posPc32];
            boolean bl = pcZero32 = pcPath32 == null && pcValue32 == 0L;
            if (!lrZero32 && !pcZero32) {
                return new Pair((Object)new ObjLongPair((Object)lrPath32, lrValue32), (Object)new ObjLongPair((Object)pcPath32, pcValue32));
            }
        }
        return null;
    }

    private static @Nullable Pair<@NonNull ObjLongPair<@Nullable IExecutablePath>, @NonNull ObjLongPair<@Nullable IExecutablePath>> extractRegisters64(@NonNull ExecutableRelativeRegisterValues registersInfo) {
        int posLr64 = ArrayUtils.indexOf((long[])registersInfo.getPerfRegisterIndices(), (long)30L);
        int posPc64 = ArrayUtils.indexOf((long[])registersInfo.getPerfRegisterIndices(), (long)32L);
        if (posLr64 >= 0 && posPc64 >= 0) {
            boolean pcZero64;
            IExecutablePath lrPath64 = registersInfo.getExecutablePaths()[posLr64];
            long lrValue64 = registersInfo.getRegisterOffsetsOrAddresses()[posLr64];
            boolean lrZero64 = lrPath64 == null && lrValue64 == 0L;
            IExecutablePath pcPath64 = registersInfo.getExecutablePaths()[posPc64];
            long pcValue64 = registersInfo.getRegisterOffsetsOrAddresses()[posPc64];
            boolean bl = pcZero64 = pcPath64 == null && pcValue64 == 0L;
            if (!lrZero64 && !pcZero64) {
                return new Pair((Object)new ObjLongPair((Object)lrPath64, lrValue64), (Object)new ObjLongPair((Object)pcPath64, pcValue64));
            }
        }
        return null;
    }

    public DatabaseBacktraceReader(@NonNull List<@NonNull VmStream> vmStreams) {
        super(vmStreams);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public @Nullable IAnalysisCodeProfilingPerChannelReader.IValue read() throws IOException {
        return (IAnalysisCodeProfilingPerChannelReader.IValue)this.doRead();
    }

    @Override
    protected @NonNull IAnalysisCodeProfilingPerChannelReader.IValue mapStreamValue(@NonNull VmStream.StreamValue value) {
        return value;
    }

    public static final class VmStream
    implements IThrowingSupplier<StreamValue, IOException> {
        private final @NonNull IntFunction<@Nullable ProfileDataPoint> ebsCounterMapper;
        private final @NonNull IntFunction<@Nullable Set<@NonNull Pair<@Nullable ProfileDataPoint, @NonNull MetricRecord>>> metricCounterMapper;
        private final @NonNull TIntObjectMap<ObjLongPair<@Nullable IExecutablePath>> strobedFunctionAddressesByThread = new TIntObjectHashMap(10, 0.5f, -1);
        private final @NonNull StreamValueIterator<BacktraceStreamParser.StreamValue> valueIterator;

        public VmStream(@NonNull IExecutablePathsMap executablePaths, long vmuid, @NonNull List<@NonNull L0IndexEntry> l0Entries, @NonNull IFileDataView view, @NonNull IntFunction<@Nullable Set<@NonNull Pair<@Nullable ProfileDataPoint, @NonNull MetricRecord>>> metricCounterMapper, @NonNull IntFunction<@Nullable ProfileDataPoint> ebsCounterMapper) throws IOException {
            this.valueIterator = new StreamValueIterator<BacktraceStreamParser.StreamValue>(view, L1IndexIterator.createFromL0Index(view, l0Entries), new BacktraceStreamParser(executablePaths));
            this.metricCounterMapper = metricCounterMapper;
            this.ebsCounterMapper = ebsCounterMapper;
        }

        public @Nullable StreamValue get() throws IOException {
            if (!this.valueIterator.hasNext()) {
                return null;
            }
            return new StreamValue(this.metricCounterMapper, this.ebsCounterMapper, this.strobedFunctionAddressesByThread, this.valueIterator.next());
        }

        public static final class StreamValue
        implements AbstractDatabaseVmStreamReader.IStreamValue,
        IAnalysisCodeProfilingPerChannelReader.IValue {
            public static final @NonNull InstructionCounterMetadataXml METRIC_CYCLES_EVENT_METADATA = new InstructionCounterMetadataXml.RatioInstructionCounterMetadata("Cycle Count", "The cumulative sample cycle count", "cycles", null, null, Arrays.asList(new InstructionCounterMetadataXml.RatioInstructionCounterDataPoint(0, "Cycle Count", null)));
            public static final @NonNull IProfileEvent CONTEXT_SWITCH_CONTENTION = StreamValue.makeContextSwitchEvent("Contended", "Time spend switched out due to CPU contention", null);
            public static final @NonNull ProfileDataPoint CONTEXT_SWITCH_CONTENTION_DP = new ProfileDataPoint(CONTEXT_SWITCH_CONTENTION, 0);
            public static final @NonNull IProfileEvent CONTEXT_SWITCH_IDLE = StreamValue.makeContextSwitchEvent("Idle", "Time spend switched out due to Idle state", null);
            public static final @NonNull ProfileDataPoint CONTEXT_SWITCH_IDLE_DP = new ProfileDataPoint(CONTEXT_SWITCH_IDLE, 0);
            public static final @NonNull IProfileEvent CONTEXT_SWITCH_SCHEDULED = StreamValue.makeContextSwitchEvent("Scheduled", "Time spend switched out due to end of timeslice", null);
            public static final @NonNull ProfileDataPoint CONTEXT_SWITCH_SCHEDULED_DP = new ProfileDataPoint(CONTEXT_SWITCH_SCHEDULED, 0);
            public static final @NonNull IProfileEvent CONTEXT_SWITCH_STOPPED = StreamValue.makeContextSwitchEvent("Stopped", "Time spend switched out due to Stopped state", null);
            public static final @NonNull ProfileDataPoint CONTEXT_SWITCH_STOPPED_DP = new ProfileDataPoint(CONTEXT_SWITCH_STOPPED, 0);
            public static final @NonNull IProfileEvent CONTEXT_SWITCH_WAIT_EVENT = StreamValue.makeContextSwitchEvent("Wait (Event)", "Time spend switched out due to wait-event state", null);
            public static final @NonNull ProfileDataPoint CONTEXT_SWITCH_WAIT_EVENT_DP = new ProfileDataPoint(CONTEXT_SWITCH_WAIT_EVENT, 0);
            public static final @NonNull IProfileEvent CONTEXT_SWITCH_WAIT_IO = StreamValue.makeContextSwitchEvent("Wait (IO)", "Time spend switched out due to wait-io state", null);
            public static final @NonNull ProfileDataPoint CONTEXT_SWITCH_WAIT_IO_DP = new ProfileDataPoint(CONTEXT_SWITCH_WAIT_IO, 0);
            public static final @NonNull IProfileEvent METRIC_SAMPLES_EVENT = new IProfileEvent.SimpleProfileEvent(IProfileSource.METRICS, BacktraceSource.EVENT_METADATA);
            public static final @NonNull ProfileDataPoint METRIC_SAMPLES_DATAPOINT = new ProfileDataPoint(METRIC_SAMPLES_EVENT, 0);
            public static final @NonNull IProfileEvent METRIC_CYCLES_EVENT = new IProfileEvent.SimpleProfileEvent(IProfileSource.METRICS, METRIC_CYCLES_EVENT_METADATA);
            public static final @NonNull ProfileDataPoint METRIC_CYCLES_DATAPOINT = new ProfileDataPoint(METRIC_CYCLES_EVENT, 0);
            public static final @NonNull ProfileDataPoint PERIODIC_SAMPLES = new ProfileDataPoint(IBacktraceSource.PERIODIC_SAMPLES, 0);
            private static final int @NonNull [] A_DP_0 = new int[1];
            private final @NonNull IntFunction<@Nullable ProfileDataPoint> ebsCounterMapper;
            private final @NonNull IntFunction<@Nullable Set<@NonNull Pair<@Nullable ProfileDataPoint, @NonNull MetricRecord>>> metricCounterMapper;
            private final @NonNull BacktraceStreamParser.StreamValue payload;
            private final @NonNull TIntObjectMap<ObjLongPair<@Nullable IExecutablePath>> strobedFunctionAddressesByThread;

            private static @NonNull ProfileDataPoint createProfileDataPoint(@NonNull IntFunction<@Nullable ProfileDataPoint> ebsCounterMapper, @NonNull SampleClassification classification, @NonNull ContextSwitchReason contextSwitchReason, @NonNull SampleCounterValues countersInfo) {
                switch (classification) {
                    case from_context_switch: {
                        switch (contextSwitchReason) {
                            case contention: {
                                return CONTEXT_SWITCH_CONTENTION_DP;
                            }
                            case exited: {
                                return CONTEXT_SWITCH_SCHEDULED_DP;
                            }
                            case idle: {
                                return CONTEXT_SWITCH_IDLE_DP;
                            }
                            case scheduled: {
                                return CONTEXT_SWITCH_SCHEDULED_DP;
                            }
                            case stopped: {
                                return CONTEXT_SWITCH_STOPPED_DP;
                            }
                            case wait_event: {
                                return CONTEXT_SWITCH_WAIT_EVENT_DP;
                            }
                            case wait_io: {
                                return CONTEXT_SWITCH_WAIT_IO_DP;
                            }
                        }
                        throw new AssertionError((Object)contextSwitchReason);
                    }
                    case from_timer: {
                        return PERIODIC_SAMPLES;
                    }
                    case from_counter: {
                        int key;
                        ProfileDataPoint source;
                        if (countersInfo.getLength() > 0 && (source = ebsCounterMapper.apply(key = countersInfo.getGatorKeys()[0])) != null) {
                            return source;
                        }
                        return PERIODIC_SAMPLES;
                    }
                }
                throw new AssertionError((Object)classification);
            }

            private static final @NonNull IProfileEvent makeContextSwitchEvent(@NonNull String name, @NonNull String description, @Nullable Integer colour) {
                return new IProfileEvent.SimpleProfileEvent(IProfileSource.CONTEXT_SWITCH, (InstructionCounterMetadataXml)new InstructionCounterMetadataXml.RatioInstructionCounterMetadata(name, description, "", null, A_DP_0, Arrays.asList(new InstructionCounterMetadataXml.RatioInstructionCounterDataPoint(0, name, colour))));
            }

            public StreamValue(@NonNull IntFunction<@Nullable Set<@NonNull Pair<@Nullable ProfileDataPoint, @NonNull MetricRecord>>> metricCounterMapper, @NonNull IntFunction<@Nullable ProfileDataPoint> ebsCounterMapper, @NonNull TIntObjectMap<ObjLongPair<@Nullable IExecutablePath>> strobedFunctionAddressesByThread, @NonNull BacktraceStreamParser.StreamValue payload) {
                this.metricCounterMapper = metricCounterMapper;
                this.ebsCounterMapper = ebsCounterMapper;
                this.strobedFunctionAddressesByThread = strobedFunctionAddressesByThread;
                this.payload = payload;
            }

            @Override
            public boolean accept(@NonNull IAnalysisCodeProfilingPerChannelReader.IValueVisitor visitor) throws IOException, InterruptedException {
                Pair<ObjLongPair<IExecutablePath>, ObjLongPair<IExecutablePath>> lrAndPc = DatabaseBacktraceReader.extractAbiRegisters(this.payload.registersInfo);
                OffsetsAddressesWithExecutablePaths pathsAndAddresses = DatabaseBacktraceReader.cleanupCallchain(this.payload.addressesAndPathInfo, this.payload.registersInfo.getAbi(), lrAndPc);
                switch (this.payload.classification) {
                    case from_context_switch: {
                        return this.acceptFromContextSwitch(visitor, pathsAndAddresses);
                    }
                    case from_timer: {
                        return this.acceptFromPeriodicSampling(visitor, pathsAndAddresses);
                    }
                    case from_counter: {
                        return this.acceptFromEbsSample(visitor, pathsAndAddresses);
                    }
                    case from_metric: {
                        return this.acceptFromMetricSample(visitor, pathsAndAddresses);
                    }
                }
                throw new AssertionError((Object)this.payload.classification);
            }

            @Override
            public long getSequenceNo() {
                return this.payload.index.sequenceNo;
            }

            @Override
            public long getTimestamp() {
                return this.payload.index.timestamp;
            }

            private boolean acceptFromContextSwitch(@NonNull IAnalysisCodeProfilingPerChannelReader.IValueVisitor visitor, @NonNull OffsetsAddressesWithExecutablePaths pathsAndAddresses) throws IOException, InterruptedException {
                ProfileDataPoint dataPoint = StreamValue.createProfileDataPoint(this.ebsCounterMapper, this.payload.classification, this.payload.contextSwitchReason, this.payload.countersInfo);
                long count = this.payload.duration;
                return visitor.backtrace(this.getTimestamp(), dataPoint, (int)UtidToLong.mapUtid(this.payload.utid), pathsAndAddresses.getExecutablePaths(), pathsAndAddresses.getRelOffsetsOrAddresses(), count, null);
            }

            private boolean acceptFromEbsSample(@NonNull IAnalysisCodeProfilingPerChannelReader.IValueVisitor visitor, @NonNull OffsetsAddressesWithExecutablePaths pathsAndAddresses) throws IOException, InterruptedException {
                ProfileDataPoint dataPoint = StreamValue.createProfileDataPoint(this.ebsCounterMapper, this.payload.classification, this.payload.contextSwitchReason, this.payload.countersInfo);
                long count = 1L;
                return visitor.backtrace(this.getTimestamp(), dataPoint, (int)UtidToLong.mapUtid(this.payload.utid), pathsAndAddresses.getExecutablePaths(), pathsAndAddresses.getRelOffsetsOrAddresses(), 1L, null);
            }

            private boolean acceptFromMetricSample(@NonNull IAnalysisCodeProfilingPerChannelReader.IValueVisitor visitor, @NonNull OffsetsAddressesWithExecutablePaths pathsAndAddresses) throws IOException, InterruptedException {
                ObjLongPair previousSample;
                ArrayList<ObjLongPair> dataPointsToWrite = new ArrayList<ObjLongPair>();
                boolean discarded = false;
                boolean strobed = false;
                boolean seenCycles = false;
                long totalCycles = 0L;
                int n = 0;
                block0: while (n < this.payload.countersInfo.getLength()) {
                    int eventKey = this.payload.countersInfo.getGatorKeys()[n];
                    long eventCount = this.payload.countersInfo.getCounterValues()[n];
                    Set<Pair<ProfileDataPoint, MetricRecord>> dataPoints = this.metricCounterMapper.apply(eventKey);
                    if (dataPoints != null && !dataPoints.isEmpty()) {
                        boolean isCycles = false;
                        for (Pair<ProfileDataPoint, MetricRecord> dataPointAndRecord : dataPoints) {
                            ProfileDataPoint dataPoint = (ProfileDataPoint)dataPointAndRecord.first;
                            MetricRecord metricRecord = (MetricRecord)dataPointAndRecord.second;
                            if (dataPoint != null) {
                                dataPointsToWrite.add(new ObjLongPair((Object)dataPoint, eventCount));
                            }
                            if (metricRecord.samplingEventKey() == eventKey) {
                                seenCycles = true;
                                isCycles = true;
                                if (metricRecord.strobePeriod() <= 0) continue;
                                strobed = true;
                                long strobeLimit = Math.min((metricRecord.samplePeriod() + metricRecord.strobePeriod()) / 2, metricRecord.strobePeriod() * 4);
                                if (this.payload.countersInfo.getCounterValues()[n] <= strobeLimit) continue;
                                discarded = true;
                                break block0;
                            }
                            if (metricRecord.returnEventKey() != eventKey || eventCount <= 1L) continue;
                            discarded = true;
                            break block0;
                        }
                        if (isCycles) {
                            totalCycles += this.payload.countersInfo.getCounterValues()[n];
                        }
                    }
                    ++n;
                }
                int utid = (int)UtidToLong.mapUtid(this.payload.utid);
                if (discarded) {
                    this.strobedFunctionAddressesByThread.put(utid, (Object)new ObjLongPair((Object)pathsAndAddresses.getExecutablePaths()[0], pathsAndAddresses.getRelOffsetsOrAddresses()[0]));
                    return true;
                }
                if (!visitor.backtrace(this.getTimestamp(), METRIC_SAMPLES_DATAPOINT, utid, pathsAndAddresses.getExecutablePaths(), pathsAndAddresses.getRelOffsetsOrAddresses(), 1L, null)) {
                    return false;
                }
                ObjLongPair objLongPair = previousSample = strobed || !seenCycles ? (ObjLongPair)this.strobedFunctionAddressesByThread.remove(utid) : (ObjLongPair)this.strobedFunctionAddressesByThread.put(utid, (Object)new ObjLongPair((Object)pathsAndAddresses.getExecutablePaths()[0], pathsAndAddresses.getRelOffsetsOrAddresses()[0]));
                if (seenCycles && previousSample != null) {
                    if (!visitor.backtrace(this.getTimestamp(), METRIC_CYCLES_DATAPOINT, utid, pathsAndAddresses.getExecutablePaths(), pathsAndAddresses.getRelOffsetsOrAddresses(), totalCycles, (ObjLongPair<IExecutablePath>)previousSample)) {
                        return false;
                    }
                    for (ObjLongPair value : dataPointsToWrite) {
                        if (visitor.backtrace(this.getTimestamp(), (ProfileDataPoint)value.first, utid, pathsAndAddresses.getExecutablePaths(), pathsAndAddresses.getRelOffsetsOrAddresses(), value.second, (ObjLongPair<IExecutablePath>)previousSample)) continue;
                        return false;
                    }
                }
                return true;
            }

            private boolean acceptFromPeriodicSampling(@NonNull IAnalysisCodeProfilingPerChannelReader.IValueVisitor visitor, @NonNull OffsetsAddressesWithExecutablePaths pathsAndAddresses) throws IOException, InterruptedException {
                ProfileDataPoint dataPoint = StreamValue.createProfileDataPoint(this.ebsCounterMapper, this.payload.classification, this.payload.contextSwitchReason, this.payload.countersInfo);
                long count = dataPoint.event.getSource().getProfileSourceMetadata().type == InstructionCounterSourceMetadata.Type.EBS && this.payload.countersInfo.getLength() > 0 ? this.payload.countersInfo.getCounterValues()[0] : 1L;
                return visitor.backtrace(this.getTimestamp(), dataPoint, (int)UtidToLong.mapUtid(this.payload.utid), pathsAndAddresses.getExecutablePaths(), pathsAndAddresses.getRelOffsetsOrAddresses(), count, null);
            }
        }
    }
}

