/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.profiling;

import com.arm.streamline.analysis.database.api.profiling.BacktraceSource;
import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class MetadataReaderWriter {
    private static final @NonNull String ATTR_ID = "id";
    private static final @NonNull String ATTR_NAME = "name";
    private static final @NonNull String FILENAME = "metadata.xml";
    private static final @NonNull String TAG_EBS = "ebs";
    private static final @NonNull String TAG_PERIODIC_SAMPLES = "periodic_samples";
    private static final @NonNull String TAG_ROOT = "metadata";

    public static @NonNull TIntObjectMap<IBacktraceSource> read(@NonNull File directory) throws IOException {
        @NonNull TIntObjectHashMap result = new TIntObjectHashMap();
        @NonNull File dataFile = new File(directory, FILENAME);
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLParser xml = XMLParser.create((File)dataFile);){
            String tag;
            String marker = xml.getMarker();
            block19: while ((tag = xml.nextTag(marker)) != null) {
                switch (tag) {
                    case "metadata": {
                        String innerMarker = xml.getMarker();
                        while ((tag = xml.nextTag(innerMarker)) != null) {
                            if (!xml.hasAttribute(ATTR_ID)) {
                                throw new IOException("Invalid file contents");
                            }
                            int id = xml.getIntegerAttribute(ATTR_ID);
                            switch (tag) {
                                case "ebs": {
                                    String name = xml.getAttribute(ATTR_NAME);
                                    if (name == null) {
                                        throw new IOException("Invalid file contents");
                                    }
                                    result.put(id, (Object)BacktraceSource.ebs(name));
                                    break;
                                }
                                case "periodic_samples": {
                                    result.put(id, (Object)IBacktraceSource.PERIODIC_SAMPLES);
                                    break;
                                }
                                default: {
                                    throw new IOException("Invalid file contents");
                                }
                            }
                        }
                        continue block19;
                    }
                    default: {
                        throw new IOException("Invalid file contents");
                    }
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    public static void write(@NonNull File directory, @NonNull TObjectIntMap<IBacktraceSource> sources) throws IOException {
        @NonNull File dataFile = new File(directory, FILENAME);
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)dataFile);){
            xml.startDocument();
            xml.startTag(TAG_ROOT);
            TObjectIntIterator it = sources.iterator();
            while (it.hasNext()) {
                it.advance();
                IBacktraceSource key = (IBacktraceSource)it.key();
                int value = it.value();
                switch (key.getType()) {
                    case EBS: {
                        xml.startEmptyTag(TAG_EBS);
                        xml.addAttribute(ATTR_NAME, key.getName());
                        break;
                    }
                    case PERIODIC: {
                        assert (key == IBacktraceSource.PERIODIC_SAMPLES);
                        xml.startEmptyTag(TAG_PERIODIC_SAMPLES);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)key.getType());
                    }
                }
                xml.addAttribute(ATTR_ID, value);
            }
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

