/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.profiling;

import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingPerChannelReader;
import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.database.api.profiling.ProfileDataPoint;
import com.arm.streamline.analysis.database.stream.ChannelExecutablePathReader;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.utility.io.Compression;
import gnu.trove.map.TIntObjectMap;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DatabaseCodeProfilerPerChannelEventReader
implements IAnalysisCodeProfilingPerChannelReader {
    private final @NonNull TIntObjectMap<IBacktraceSource> backtraceSources;
    private final @NonNull ChannelExecutablePathReader executablePathReader = new ChannelExecutablePathReader();
    private final @NonNull InputStream inputStream;
    private long lastTimestamp = 0L;

    public DatabaseCodeProfilerPerChannelEventReader(@NonNull File dataFile, long vmUID, @NonNull TIntObjectMap<IBacktraceSource> backtraceSources) throws IOException {
        this.backtraceSources = backtraceSources;
        this.inputStream = new BufferedInputStream(new GZIPInputStream(new FileInputStream(dataFile)));
    }

    DatabaseCodeProfilerPerChannelEventReader(@NonNull InputStream inputStream, long vmUID, @NonNull TIntObjectMap<IBacktraceSource> backtraceSources) {
        this.backtraceSources = backtraceSources;
        this.inputStream = inputStream;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public @Nullable IAnalysisCodeProfilingPerChannelReader.IValue read() throws IOException {
        try {
            long timestamp;
            long delta = Compression.unpackInt((InputStream)this.inputStream);
            final int utid = (int)Compression.unpackInt((InputStream)this.inputStream);
            this.lastTimestamp = timestamp = this.lastTimestamp + delta;
            int sourceId = (int)Compression.unpackInt((InputStream)this.inputStream);
            int length = (int)Compression.unpackInt((InputStream)this.inputStream);
            final @Nullable IExecutablePath[] offsetExecutablePaths = new IExecutablePath[length];
            final long[] offsets = new long[length];
            int i = 0;
            while (i < length) {
                offsetExecutablePaths[i] = this.executablePathReader.readExecutablePath(this.inputStream);
                offsets[i] = Compression.unpackInt((InputStream)this.inputStream);
                ++i;
            }
            final @NonNull IBacktraceSource backtraceSource = this.getBacktraceSource(sourceId);
            return new IAnalysisCodeProfilingPerChannelReader.IValue(){

                @Override
                public boolean accept(@NonNull IAnalysisCodeProfilingPerChannelReader.IValueVisitor visitor) throws IOException, InterruptedException {
                    return visitor.backtrace(timestamp, new ProfileDataPoint(backtraceSource, 0), utid, offsetExecutablePaths, offsets, 1L, null);
                }

                @Override
                public long getTimestamp() {
                    return timestamp;
                }
            };
        }
        catch (EOFException e) {
            return null;
        }
    }

    private @NonNull IBacktraceSource getBacktraceSource(int sourceId) throws IOException {
        @Nullable IBacktraceSource result = (IBacktraceSource)this.backtraceSources.get(sourceId);
        if (result == null) {
            throw new IOException("Invalid date file contents");
        }
        return result;
    }
}

