/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.profiling;

import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingPerChannelWriter;
import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingWriter;
import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.database.stream.AbstractDynamicAllocatedChannelWriter;
import com.arm.streamline.analysis.database.stream.profiling.DatabaseCodeProfilerPerChannelEventWriter;
import com.arm.streamline.analysis.database.stream.profiling.MetadataReaderWriter;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.function.IThrowingConsumer;
import com.arm.utils.function.IThrowingLongFunction;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseCodeProfilerEventWriter
extends AbstractDynamicAllocatedChannelWriter<IAnalysisCodeProfilingPerChannelWriter, Long>
implements IAnalysisCodeProfilingWriter {
    private final @NonNull TObjectIntMap<IBacktraceSource> backtraceSources = new TObjectIntHashMap<IBacktraceSource>(10, 0.5f, -1){
        {
            this.put(IBacktraceSource.PERIODIC_SAMPLES, 0);
        }
    };
    private final @NonNull IThrowingLongFunction<@NonNull IAnalysisCodeProfilingPerChannelWriter, IOException> channelWriterFactory;
    private final @NonNull IThrowingConsumer<@NonNull TObjectIntMap<IBacktraceSource>, IOException> metadataConsumer;

    public DatabaseCodeProfilerEventWriter(@NonNull File profilerPath) throws IOException {
        super(Long.class);
        this.channelWriterFactory = uid -> new DatabaseCodeProfilerPerChannelEventWriter(profilerPath, uid);
        this.metadataConsumer = sources -> MetadataReaderWriter.write(profilerPath, (TObjectIntMap<IBacktraceSource>)sources);
    }

    DatabaseCodeProfilerEventWriter(@NonNull IThrowingLongFunction<@NonNull IAnalysisCodeProfilingPerChannelWriter, IOException> channelWriterFactory, @NonNull IThrowingConsumer<@NonNull TObjectIntMap<IBacktraceSource>, IOException> metadataConsumer) {
        super(Long.class);
        this.channelWriterFactory = channelWriterFactory;
        this.metadataConsumer = metadataConsumer;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.metadataConsumer.accept(this.backtraceSources);
    }

    @Override
    public void consumeBacktrace(long time, @NonNull IBacktraceSource backtraceSource, @NonNull IUniqueThreadID utid, @Nullable IExecutablePath @NonNull [] offsetExecutablePaths, long @NonNull [] offsets) throws IOException {
        @NonNull IAnalysisCodeProfilingPerChannelWriter channelWriter = this.getOrCreateChannel(utid);
        int source = this.getBacktraceSource(backtraceSource);
        channelWriter.consumeBacktrace(time, source, utid, offsetExecutablePaths, offsets);
    }

    @Override
    protected Comparator<@NonNull Long> comparator() {
        return Long::compare;
    }

    @Override
    protected @NonNull IAnalysisCodeProfilingPerChannelWriter createNewChannel(@NonNull Long channel) throws IOException {
        return (IAnalysisCodeProfilingPerChannelWriter)this.channelWriterFactory.apply(channel.longValue());
    }

    @Override
    protected boolean validChannel(@NonNull Long channel) {
        return true;
    }

    private int getBacktraceSource(@NonNull IBacktraceSource backtraceSource) {
        return this.backtraceSources.adjustOrPutValue((Object)backtraceSource, 0, this.backtraceSources.size());
    }

    @Override
    private @NonNull IAnalysisCodeProfilingPerChannelWriter getOrCreateChannel(@NonNull IUniqueThreadID utid) throws IOException {
        return (IAnalysisCodeProfilingPerChannelWriter)this.getOrCreateChannel(utid.getVmUID());
    }
}

