/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.icounter.spe;

import com.arm.streamline.analysis.database.api.icounter.IAnalysisCounterInstructionCounterWriter;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisRatioInstructionCounterWriter;
import com.arm.streamline.analysis.database.api.icounter.spe.ISpeCounterValueConsumer;
import com.arm.streamline.analysis.database.api.icounter.spe.ISpeDataSourceConsumer;
import com.arm.streamline.analysis.database.api.icounter.spe.ISpeEventsInstructionCounterConsumer;
import com.arm.streamline.analysis.database.api.icounter.spe.ISpeOperationTypePredicate;
import com.arm.streamline.analysis.database.stream.icounter.spe.ISpeInstructionCounterConsumerFactory;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.xml.spe.SpeOperationTypeClass;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SpeInstructionCounterConsumerFactory
implements ISpeInstructionCounterConsumerFactory {
    @Override
    public @NonNull ISpeEventsInstructionCounterConsumer createConditionalHitMissConsumer(final @NonNull IAnalysisRatioInstructionCounterWriter<@NonNull Boolean> writer, final @NonNull ISpeOperationTypePredicate operationTypePredicate, int accessBitIndex, final boolean accessIsClear, int bitIndex, final boolean hitIsClear) {
        if (accessBitIndex < 0 || accessBitIndex > 63 || bitIndex < 0 || bitIndex > 63) {
            throw new IllegalArgumentException();
        }
        final long accessMask = 1L << accessBitIndex;
        final long mask = 1L << bitIndex;
        return new ISpeEventsInstructionCounterConsumer(){

            @Override
            public void close() throws IOException {
                writer.close();
            }

            @Override
            public void consume(long timestamp, @NonNull ProcessingElementReference procesingElement, @NonNull IUniqueThreadID utid, @Nullable IExecutablePath executablePath, long offsetOrAddress, @Nullable SpeOperationTypeClass opClass, byte subClass, long events) throws IOException {
                boolean hit;
                boolean accessBitSet = (events & accessMask) == accessMask;
                boolean accessHit = accessIsClear && !accessBitSet || accessBitSet && !accessIsClear;
                boolean bitSet = (events & mask) == mask;
                boolean bl = hit = hitIsClear && !bitSet || bitSet && !hitIsClear;
                if (accessHit && operationTypePredicate.test(opClass, subClass)) {
                    writer.consumeCounterValue(timestamp, procesingElement, utid, executablePath, offsetOrAddress, hit);
                }
            }
        };
    }

    @Override
    public @NonNull ISpeEventsInstructionCounterConsumer createHitMissConsumer(final @NonNull IAnalysisRatioInstructionCounterWriter<@NonNull Boolean> writer, final @NonNull ISpeOperationTypePredicate operationTypePredicate, int bitIndex, final boolean hitIsClear) {
        if (bitIndex < 0 || bitIndex > 63) {
            throw new IllegalArgumentException();
        }
        final long mask = 1L << bitIndex;
        return new ISpeEventsInstructionCounterConsumer(){

            @Override
            public void close() throws IOException {
                writer.close();
            }

            @Override
            public void consume(long timestamp, @NonNull ProcessingElementReference procesingElement, @NonNull IUniqueThreadID utid, @Nullable IExecutablePath executablePath, long offsetOrAddress, @Nullable SpeOperationTypeClass opClass, byte subClass, long events) throws IOException {
                boolean hit;
                boolean bitSet = (events & mask) == mask;
                boolean bl = hit = hitIsClear && !bitSet || bitSet && !hitIsClear;
                if (operationTypePredicate.test(opClass, subClass)) {
                    writer.consumeCounterValue(timestamp, procesingElement, utid, executablePath, offsetOrAddress, hit);
                }
            }
        };
    }

    @Override
    public @NonNull ISpeCounterValueConsumer createCounterConsumer(final @NonNull IAnalysisCounterInstructionCounterWriter writer) {
        return new ISpeCounterValueConsumer(){

            @Override
            public void close() throws IOException {
                writer.close();
            }

            @Override
            public void consume(long timestamp, @NonNull ProcessingElementReference procesingElement, @NonNull IUniqueThreadID utid, @Nullable IExecutablePath executablePath, long offsetOrAddress, short count) throws IOException {
                writer.consumeCounterValue(timestamp, procesingElement, utid, executablePath, offsetOrAddress, Short.toUnsignedLong(count));
            }
        };
    }

    @Override
    public @NonNull ISpeDataSourceConsumer createDataSourceConsumer(final @NonNull IAnalysisRatioInstructionCounterWriter<@NonNull Short> writer) {
        return new ISpeDataSourceConsumer(){

            @Override
            public void close() throws IOException {
                writer.close();
            }

            @Override
            public void consume(long timestamp, @NonNull ProcessingElementReference procesingElement, @NonNull IUniqueThreadID utid, @Nullable IExecutablePath executablePath, long offsetOrAddress, short dataSource) throws IOException {
                writer.consumeCounterValue(timestamp, procesingElement, utid, executablePath, offsetOrAddress, dataSource);
            }
        };
    }
}

