/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.icounter;

import com.arm.streamline.analysis.database.api.icounter.IAnalysisRatioInstructionCounterChannelWriter;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisRatioInstructionCounterWriter;
import com.arm.streamline.analysis.database.stream.AbstractDynamicAllocatedChannelWriter;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseRatioInstructionCounterChannelWriter;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.collections.Pair;
import com.arm.utils.function.IThrowingObjIntBiFunction;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseRatioInstructionCounterWriter<T>
extends AbstractDynamicAllocatedChannelWriter<IAnalysisRatioInstructionCounterChannelWriter<T>, Pair<ProcessingElementReference, T>>
implements IAnalysisRatioInstructionCounterWriter<T> {
    private final @NonNull IThrowingObjIntBiFunction<@NonNull ProcessingElementReference, @NonNull IAnalysisRatioInstructionCounterChannelWriter<T>, IOException> channelWriterFactory;
    private final @NonNull ToIntFunction<T> dataPointUniqueIDMapper;
    private final @NonNull BiPredicate<@NonNull ProcessingElementReference, T> validateChannel;

    private static <T> @NonNull Class<Pair<@NonNull ProcessingElementReference, T>> pairClass() {
        return Pair.class;
    }

    public DatabaseRatioInstructionCounterWriter(@NonNull File directory, @NonNull BiPredicate<@NonNull ProcessingElementReference, T> validateChannel, @NonNull ToIntFunction<T> dataPointUniqueIDMapper) {
        super(DatabaseRatioInstructionCounterWriter.pairClass());
        this.validateChannel = validateChannel;
        this.dataPointUniqueIDMapper = dataPointUniqueIDMapper;
        this.channelWriterFactory = (peReference, channelID) -> new DatabaseRatioInstructionCounterChannelWriter(directory, (ProcessingElementReference)peReference, channelID);
    }

    DatabaseRatioInstructionCounterWriter(@NonNull BiPredicate<@NonNull ProcessingElementReference, T> validateChannel, @NonNull ToIntFunction<T> dataPointUniqueIDMapper, @NonNull IThrowingObjIntBiFunction<@NonNull ProcessingElementReference, @NonNull IAnalysisRatioInstructionCounterChannelWriter<T>, IOException> channelWriterFactory) {
        super(DatabaseRatioInstructionCounterWriter.pairClass());
        this.validateChannel = validateChannel;
        this.dataPointUniqueIDMapper = dataPointUniqueIDMapper;
        this.channelWriterFactory = channelWriterFactory;
    }

    @Override
    public void consumeCounterValue(long time, @NonNull ProcessingElementReference peReference, @NonNull IUniqueThreadID utid, @Nullable IExecutablePath executablePath, long offsetOrAddress, T dataPoint) throws IOException {
        if (peReference.vmUID != utid.getVmUID()) {
            throw new IllegalArgumentException();
        }
        @NonNull IAnalysisRatioInstructionCounterChannelWriter channelWriter = (IAnalysisRatioInstructionCounterChannelWriter)this.getOrCreateChannel(new Pair((Object)peReference, dataPoint));
        channelWriter.consumeCounterValue(time, utid, executablePath, offsetOrAddress);
    }

    @Override
    protected @Nullable Comparator<@NonNull Pair<@NonNull ProcessingElementReference, T>> comparator() {
        return null;
    }

    @Override
    protected @NonNull IAnalysisRatioInstructionCounterChannelWriter<T> createNewChannel(@NonNull Pair<@NonNull ProcessingElementReference, T> channel) throws IOException {
        return (IAnalysisRatioInstructionCounterChannelWriter)this.channelWriterFactory.apply((Object)((ProcessingElementReference)channel.first), this.dataPointUniqueIDMapper.applyAsInt(channel.second));
    }

    @Override
    protected boolean validChannel(@NonNull Pair<@NonNull ProcessingElementReference, T> channel) {
        if (!((ProcessingElementReference)channel.first).deviceType.isCPU()) {
            return false;
        }
        return this.validateChannel.test((ProcessingElementReference)channel.first, (ProcessingElementReference)channel.second);
    }

    public static final class MappingUniqueIdAllocator<T>
    implements ToLongFunction<T> {
        private final @NonNull TObjectIntMap<T> dataPointUniqueIdMap = new TObjectIntHashMap(10, 0.5f, 0);

        @Override
        public long applyAsLong(T value) {
            if (value == null) {
                return 0L;
            }
            return this.dataPointUniqueIdMap.adjustOrPutValue(value, 0, this.dataPointUniqueIdMap.size() + 1);
        }
    }
}

