/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.icounter;

import com.arm.streamline.analysis.database.api.icounter.IAnalysisCounterInstructionCounterChannelReader;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisCounterInstructionCounterReader;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisRatioInstructionCounterChannelReader;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisRatioInstructionCounterReader;
import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingPerChannelReader;
import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingReader;
import com.arm.streamline.analysis.database.api.profiling.IProfileEvent;
import com.arm.streamline.analysis.database.api.profiling.IProfileSource;
import com.arm.streamline.analysis.database.api.profiling.ProfileDataPoint;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseCounterInstructionCounterReader;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseRatioInstructionCounterReader;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.report.shared.icounter.InstructionCounterMetadataXml;
import com.arm.utils.function.IThrowingFunction;
import java.io.File;
import java.io.IOException;
import java.util.function.LongToIntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseInstructionCounterReaderFactory {
    protected static final @NonNull LongToIntFunction LOG2_COUNTER_MAPPER = n -> 64 - Long.numberOfLeadingZeros(n);
    protected static final @NonNull LongToIntFunction DEFAULT_COUNTER_MAPPER = Math::toIntExact;

    public static @NonNull IAnalysisCodeProfilingReader createCodeProfilingReader(final @NonNull File path, final @NonNull IThrowingFunction<@NonNull File, @NonNull IAnalysisRatioInstructionCounterReader<@NonNull Integer>, IOException> ratioReaderFactory, final @NonNull IThrowingFunction<@NonNull File, @NonNull IAnalysisCounterInstructionCounterReader, IOException> counterReaderFactory, @NonNull IThrowingFunction<@NonNull File, @NonNull InstructionCounterMetadataXml, IOException> metaDataLoader) throws IOException {
        File metaDataPath = new File(path, "metadata.xml");
        InstructionCounterMetadataXml metaData = (InstructionCounterMetadataXml)metaDataLoader.apply((Object)metaDataPath);
        final ProfileEvent event = new ProfileEvent(path, metaData);
        return (IAnalysisCodeProfilingReader)metaData.accept((InstructionCounterMetadataXml.IInstructionCounterMetadataXmlVisitor)new InstructionCounterMetadataXml.IInstructionCounterMetadataXmlVisitor<Void, IAnalysisCodeProfilingReader, IOException>(){

            public IAnalysisCodeProfilingReader visit(// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata value, Void data) throws IOException {
                return new RatioReader((IAnalysisRatioInstructionCounterReader)ratioReaderFactory.apply((Object)path), event);
            }

            public IAnalysisCodeProfilingReader visit(// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull InstructionCounterMetadataXml.CounterInstructionCounterMetadata value, Void data) throws IOException {
                LongToIntFunction mapper;
                block5: {
                    block4: {
                        // Could not load outer class - annotation placement on inner may be incorrect
                         @Nullable ICounterInstructionCounterMetadata.Mode mappingMode = value.getMode();
                        if (mappingMode == null) break block4;
                        switch (mappingMode) {
                            case DEFAULT: {
                                mapper = DEFAULT_COUNTER_MAPPER;
                                break block5;
                            }
                            case LOG2_N_PLUS_1: {
                                mapper = LOG2_COUNTER_MAPPER;
                                break block5;
                            }
                            default: {
                                throw new AssertionError(value.getMode());
                            }
                        }
                    }
                    mapper = DEFAULT_COUNTER_MAPPER;
                }
                return new CounterReader((IAnalysisCounterInstructionCounterReader)counterReaderFactory.apply((Object)path), event, mapper);
            }

            public @NonNull IAnalysisCodeProfilingReader visit(// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull InstructionCounterMetadataXml.MetricInstructionCounterMetadata value, Void data) throws IOException {
                throw new AssertionError((Object)"Unexpected");
            }
        }, null);
    }

    public static @NonNull IAnalysisCodeProfilingReader createCodeProfilingReader(@NonNull File path, @NonNull ProcessingElementReferenceSet peReferenceSet) throws IOException {
        return DatabaseInstructionCounterReaderFactory.createCodeProfilingReader(path, (IThrowingFunction<File, IAnalysisRatioInstructionCounterReader<Integer>, IOException>)((IThrowingFunction)p -> new DatabaseRatioInstructionCounterReader((File)p, peReferenceSet, Integer::valueOf)), (IThrowingFunction<File, IAnalysisCounterInstructionCounterReader, IOException>)((IThrowingFunction)p -> new DatabaseCounterInstructionCounterReader((File)p, peReferenceSet)), (IThrowingFunction<File, InstructionCounterMetadataXml, IOException>)((IThrowingFunction)InstructionCounterMetadataXml::load));
    }

    private static class CounterReader
    implements IAnalysisCodeProfilingReader {
        private final @NonNull IProfileEvent event;
        private final @NonNull IAnalysisCounterInstructionCounterReader reader;
        private final @NonNull LongToIntFunction dataPointIdMapper;

        CounterReader(@NonNull IAnalysisCounterInstructionCounterReader reader, @NonNull IProfileEvent event, @NonNull LongToIntFunction dataPointIdMapper) {
            this.reader = reader;
            this.event = event;
            this.dataPointIdMapper = dataPointIdMapper;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public @Nullable IAnalysisCodeProfilingPerChannelReader.IValue read() throws IOException {
            IAnalysisCounterInstructionCounterChannelReader.Value value = (IAnalysisCounterInstructionCounterChannelReader.Value)this.reader.read();
            if (value == null) {
                return null;
            }
            long v = value.n;
            int dataPointId = this.dataPointIdMapper.applyAsInt(v);
            return new Value(value.timestamp, new ProfileDataPoint(this.event, dataPointId), value.uid, new IExecutablePath[]{value.executablePath}, new long[]{value.offsetOrAddress});
        }
    }

    private static class ProfileEvent
    implements IProfileEvent {
        private final @NonNull InstructionCounterMetadataXml metaData;
        private final @NonNull File path;

        public ProfileEvent(@NonNull File path, @NonNull InstructionCounterMetadataXml metaData) {
            this.path = path;
            this.metaData = metaData;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProfileEvent other = (ProfileEvent)obj;
            return this.path.equals(other.path);
        }

        @Override
        public @NonNull InstructionCounterMetadataXml getProfileEventMetadata() {
            return this.metaData;
        }

        @Override
        public @NonNull IProfileSource getSource() {
            return IProfileSource.SPE;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.path.hashCode();
            return result;
        }
    }

    private static class RatioReader
    implements IAnalysisCodeProfilingReader {
        private final @NonNull IProfileEvent event;
        private final @NonNull IAnalysisRatioInstructionCounterReader<@NonNull Integer> reader;

        RatioReader(@NonNull IAnalysisRatioInstructionCounterReader<@NonNull Integer> reader, @NonNull IProfileEvent event) {
            this.reader = reader;
            this.event = event;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public @Nullable IAnalysisCodeProfilingPerChannelReader.IValue read() throws IOException {
            @NonNull IAnalysisRatioInstructionCounterChannelReader.Value value = (IAnalysisRatioInstructionCounterChannelReader.Value)this.reader.read();
            if (value == null) {
                return null;
            }
            return new Value(value.timestamp, new ProfileDataPoint(this.event, (Integer)value.dataPoint), value.uid, new IExecutablePath[]{value.executablePath}, new long[]{value.offsetOrAddress});
        }
    }

    private static class Value
    implements IAnalysisCodeProfilingPerChannelReader.IValue {
        private final @NonNull ProfileDataPoint event;
        private final @Nullable IExecutablePath @NonNull [] offsetExecutablePaths;
        private final long @NonNull [] offsets;
        private final long timestamp;
        private final int utid;

        public Value(long timestamp, @NonNull ProfileDataPoint event, int utid, @Nullable IExecutablePath @NonNull [] offsetExecutablePaths, long @NonNull [] offsets) {
            this.timestamp = timestamp;
            this.event = event;
            this.utid = utid;
            this.offsetExecutablePaths = offsetExecutablePaths;
            this.offsets = offsets;
        }

        @Override
        public boolean accept(@NonNull IAnalysisCodeProfilingPerChannelReader.IValueVisitor visitor) throws IOException, InterruptedException {
            return visitor.backtrace(this.timestamp, this.event, this.utid, this.offsetExecutablePaths, this.offsets, 1L, null);
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

