/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.icounter;

import com.arm.streamline.analysis.database.api.IAnalysisReaderFactoryV2;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterReader;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisCounterInstructionCounterChannelReader;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisRatioInstructionCounterChannelReader;
import com.arm.streamline.analysis.database.stream.counters.DatabaseCounterReader;
import com.arm.streamline.analysis.database.stream.counters.IDatabaseCounterChannelReader;
import com.arm.streamline.analysis.database.stream.icounter.Messages;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterMode;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.Ternary;
import com.arm.streamline.report.shared.icounter.InstructionCounterMetadataXml;
import com.arm.utils.ArrayUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.ObjIntPair;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.Throwing;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseHardwareCounterReaderForInstructionCounterFactory {
    public static @NonNull Stream<@NonNull IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream> createHardwareCounterReaderCreatorForInstructionCounter(final @NonNull File path, final @NonNull IInstructionCounterChannelReaderSupplier instructionCounterChannelReaderSupplier, @NonNull IThrowingFunction<@NonNull File, @NonNull InstructionCounterMetadataXml, IOException> metaDataLoader) throws IOException {
        File metaDataPath = new File(path, "metadata.xml");
        InstructionCounterMetadataXml metaData = (InstructionCounterMetadataXml)metaDataLoader.apply((Object)metaDataPath);
        return (Stream)metaData.accept((InstructionCounterMetadataXml.IInstructionCounterMetadataXmlVisitor)new InstructionCounterMetadataXml.IInstructionCounterMetadataXmlVisitor<Void, Stream<IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream>, IOException>(){

            public @NonNull Stream<@NonNull IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream> visit(// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull InstructionCounterMetadataXml.CounterInstructionCounterMetadata value, Void data) throws IOException {
                return DatabaseHardwareCounterReaderForInstructionCounterFactory.counter(path, value, instructionCounterChannelReaderSupplier);
            }

            public @NonNull Stream<@NonNull IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream> visit(// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata value, Void data) throws IOException {
                return DatabaseHardwareCounterReaderForInstructionCounterFactory.ratio(path, value, instructionCounterChannelReaderSupplier);
            }

            public @NonNull Stream<@NonNull IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream> visit(// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull InstructionCounterMetadataXml.MetricInstructionCounterMetadata value, Void data) throws IOException {
                throw new AssertionError((Object)"Unexpected");
            }
        }, null);
    }

    private static @NonNull Stream<@NonNull IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream> counter(final @NonNull File path, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull InstructionCounterMetadataXml.CounterInstructionCounterMetadata metadata, final @NonNull IInstructionCounterChannelReaderSupplier creator) {
        final @NonNull CounterRecord counterRecord = DatabaseHardwareCounterReaderForInstructionCounterFactory.makeCounterRecord(Messages.DatabaseHardwareCounterReaderForInstructionCounterFactory_SPE_LATENCY, metadata.getTitle(), metadata.getDescription(), metadata.getUnit(), CounterClass.ABSOLUTE, GraphRenderingType.LINE, SeriesComposition.OVERLAY, metadata.getColourRGB(), creator.enumerateCounterChannels(path), false, metadata.getClusterID());
        final ProcessingElementReference[] channels = (ProcessingElementReference[])NullChecking.neverNull((Object[])counterRecord.getChannelDescriptions());
        return Stream.of(new IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream(){

            private final @NonNull IDatabaseCounterChannelReader createPerChannelReader(final int channelIndex) throws IOException {
                final IAnalysisCounterInstructionCounterChannelReader reader = creator.createCounterChannelReader(path, channels[channelIndex]);
                return new IDatabaseCounterChannelReader(){
                    long sequenceCounter = 0L;

                    @Override
                    public void close() throws IOException {
                        reader.close();
                    }

                    public @Nullable IAnalysisHardwareCounterReader.Value get() throws IOException {
                        IAnalysisCounterInstructionCounterChannelReader.Value value = (IAnalysisCounterInstructionCounterChannelReader.Value)reader.read();
                        if (value == null) {
                            return null;
                        }
                        return new IAnalysisHardwareCounterReader.Value(channelIndex, value.timestamp, this.sequenceCounter++, 0L, value.uid, value.n);
                    }
                };
            }

            @Override
            public @NonNull CounterRecord getCounterRecord() {
                return counterRecord;
            }

            @Override
            public @NonNull String getStreamName() {
                return path.getPath();
            }

            @Override
            public int getChannelCount() {
                return channels.length;
            }

            @Override
            public @NonNull IAnalysisHardwareCounterReader createReader() throws IOException {
                return (IAnalysisHardwareCounterReader)Throwing.closeIfThrows(t -> new DatabaseCounterReader((IDatabaseCounterChannelReader[])ArrayUtils.createNonNull(IDatabaseCounterChannelReader[]::new, (int)channels.length, i -> (IDatabaseCounterChannelReader)t.track((Closeable)this.createPerChannelReader(i)))));
            }
        });
    }

    private static @NonNull Stream<@NonNull IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream> ratio(final @NonNull File path, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata metadata, final @NonNull IInstructionCounterChannelReaderSupplier creator) {
        Map<@NonNull Integer, @NonNull List<@NonNull T>> pesByDp = creator.enumerateRatioChannels(path).stream().collect(Collectors.groupingBy(peAndDp -> peAndDp.second, Collectors.mapping(peAndDp -> (ProcessingElementReference)peAndDp.first, Collectors.toList())));
        return metadata.getDataPoints().stream().map(dpMetadata -> {
            final int dpId = dpMetadata.getID();
            int @Nullable [] dpIdsShownByDefault = metadata.getDataPointIDsShownByDefault();
            boolean hideByDefault = dpIdsShownByDefault != null && ArrayUtils.indexOf((int[])dpIdsShownByDefault, (int)dpId) == -1;
            @NonNull List pes = (List)NullChecking.neverNullOr((Object)((List)pesByDp.get(dpId)), Collections.emptyList());
            final @NonNull CounterRecord counterRecord = DatabaseHardwareCounterReaderForInstructionCounterFactory.makeCounterRecord(metadata.getTitle(), dpMetadata.getName(), metadata.getDescription(), metadata.getUnit(), CounterClass.INCIDENT, GraphRenderingType.BAR, SeriesComposition.STACKED, dpMetadata.getColourRGB(), pes, hideByDefault, metadata.getClusterID());
            final ProcessingElementReference[] channels = (ProcessingElementReference[])NullChecking.neverNull((Object[])counterRecord.getChannelDescriptions());
            return new IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream(){

                private final @NonNull IDatabaseCounterChannelReader createPerChannelReader(final int channelId) throws IOException {
                    final IAnalysisRatioInstructionCounterChannelReader<?> reader = creator.createRatioChannelReader(path, channels[channelId], dpId);
                    return new IDatabaseCounterChannelReader(){
                        long sequenceCounter = 0L;

                        @Override
                        public void close() throws IOException {
                            reader.close();
                        }

                        public @Nullable IAnalysisHardwareCounterReader.Value get() throws IOException {
                            IAnalysisRatioInstructionCounterChannelReader.Value value = (IAnalysisRatioInstructionCounterChannelReader.Value)reader.read();
                            if (value == null) {
                                return null;
                            }
                            return new IAnalysisHardwareCounterReader.Value(channelId, value.timestamp, this.sequenceCounter++, 0L, value.uid, 1L);
                        }
                    };
                }

                @Override
                public @NonNull CounterRecord getCounterRecord() {
                    return counterRecord;
                }

                @Override
                public @NonNull String getStreamName() {
                    return path.getPath() + ": " + dpId;
                }

                @Override
                public int getChannelCount() {
                    return channels.length;
                }

                @Override
                public @NonNull IAnalysisHardwareCounterReader createReader() throws IOException {
                    return (IAnalysisHardwareCounterReader)Throwing.closeIfThrows(t -> new DatabaseCounterReader((IDatabaseCounterChannelReader[])ArrayUtils.createNonNull(IDatabaseCounterChannelReader[]::new, (int)channels.length, i -> (IDatabaseCounterChannelReader)t.track((Closeable)this.createPerChannelReader(i)))));
                }
            };
        });
    }

    public static @NonNull CounterRecord makeCounterRecord(@NonNull String title, @NonNull String name, @NonNull String description, @NonNull String unit, @NonNull CounterClass counterClass, @NonNull GraphRenderingType renderingType, @NonNull SeriesComposition seriesComposition, Integer color, @NonNull Collection<@NonNull ProcessingElementReference> pes, boolean hideByDefault, @Nullable Integer clusterId) {
        return DatabaseHardwareCounterReaderForInstructionCounterFactory.makeCounterRecord(title, name, description, unit, counterClass, renderingType, seriesComposition, color, pes.toArray(new ProcessingElementReference[pes.size()]), hideByDefault, clusterId);
    }

    public static @NonNull CounterRecord makeCounterRecord(@NonNull String title, @NonNull String name, @NonNull String description, @NonNull String unit, @NonNull CounterClass counterClass, @NonNull GraphRenderingType renderingType, @NonNull SeriesComposition seriesComposition, Integer color, @NonNull ProcessingElementReference @NonNull [] pes, boolean hideByDefault, @Nullable Integer clusterId) {
        CounterRecord record = new CounterRecord("unused", Messages.DatabaseHardwareCounterReaderForInstructionCounterFactory_SPE_PREFIX + title, name, description, null);
        record.setCounterClass(counterClass);
        record.setUnits(unit);
        record.setProc(Ternary.TRUE);
        record.setColor(color);
        record.setRenderingType(renderingType);
        record.setSeriesComposition(seriesComposition);
        record.setChannelDescriptions(pes);
        record.setDeviceType(DeviceType.CPU);
        record.setMode(CounterMode.PER_CORE);
        record.setHideByDefault(hideByDefault);
        record.setIsAvailableLive(false);
        record.setCluster(clusterId);
        return record;
    }

    public static interface IInstructionCounterChannelReaderSupplier {
        public @NonNull IAnalysisCounterInstructionCounterChannelReader createCounterChannelReader(@NonNull File var1, @NonNull ProcessingElementReference var2) throws IOException;

        public @NonNull IAnalysisRatioInstructionCounterChannelReader<?> createRatioChannelReader(@NonNull File var1, @NonNull ProcessingElementReference var2, int var3) throws IOException;

        public @NonNull List<@NonNull ProcessingElementReference> enumerateCounterChannels(@NonNull File var1);

        public @NonNull List<@NonNull ObjIntPair<@NonNull ProcessingElementReference>> enumerateRatioChannels(@NonNull File var1);
    }
}

