/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.icounter;

import com.arm.streamline.analysis.database.api.IEventReader;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisCounterInstructionCounterChannelReader;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisCounterInstructionCounterReader;
import com.arm.streamline.analysis.database.stream.AbstractEventReader;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseCounterInstructionCounterChannelReader;
import com.arm.streamline.analysis.database.stream.icounter.DatabaseCounterInstructionCounterChannelWriter;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingBiFunction;
import com.arm.utils.function.Throwing;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseCounterInstructionCounterReader
extends AbstractEventReader<IAnalysisCounterInstructionCounterChannelReader.Value, IAnalysisCounterInstructionCounterChannelReader.Value, IAnalysisCounterInstructionCounterChannelReader>
implements IAnalysisCounterInstructionCounterReader {
    public static @NonNull List<@NonNull ProcessingElementReference> enumerateChannels(@NonNull File directory, @NonNull ProcessingElementReferenceSet peReferenceSet) {
        @NonNull File @Nullable [] allFiles = directory.listFiles();
        @NonNull ArrayList<@NonNull ProcessingElementReference> channels = new ArrayList<ProcessingElementReference>();
        if (allFiles != null) {
            File[] fileArray = allFiles;
            int n = allFiles.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher matcher;
                File file = fileArray[n2];
                if (file.isFile() && (matcher = DatabaseCounterInstructionCounterChannelWriter.FILE_PATTERN.matcher(file.getName())).matches()) {
                    @NonNull String vmStr = (String)NullChecking.neverNull((Object)matcher.group(1));
                    @NonNull String cpuStr = (String)NullChecking.neverNull((Object)matcher.group(2));
                    long vmUID = Long.parseLong(vmStr);
                    int deviceNumber = Integer.parseInt(cpuStr);
                    @NonNull ProcessingElementReference peReference = peReferenceSet.get(DeviceType.CPU, vmUID, deviceNumber);
                    channels.add(peReference);
                }
                ++n2;
            }
        }
        return channels;
    }

    protected static @NonNull IAnalysisCounterInstructionCounterChannelReader @NonNull [] createChannelReadersFor(@NonNull File directory, @NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull IThrowingBiFunction<@NonNull File, @NonNull ProcessingElementReference, @NonNull IAnalysisCounterInstructionCounterChannelReader, IOException> factory) throws IOException {
        @NonNull ArrayList<@NonNull IAnalysisCounterInstructionCounterChannelReader> channelReaders = new ArrayList<IAnalysisCounterInstructionCounterChannelReader>();
        try {
            for (ProcessingElementReference peReference : DatabaseCounterInstructionCounterReader.enumerateChannels(directory, peReferenceSet)) {
                File file = DatabaseCounterInstructionCounterChannelWriter.getFile(directory, peReference);
                channelReaders.add((IAnalysisCounterInstructionCounterChannelReader)factory.apply((Object)file, (Object)peReference));
            }
            return channelReaders.toArray(new IAnalysisCounterInstructionCounterChannelReader[channelReaders.size()]);
        }
        catch (Throwable t) {
            Throwing.closeAll((Iterable[])new Iterable[]{channelReaders});
            throw t;
        }
    }

    public DatabaseCounterInstructionCounterReader(@NonNull File directory, @NonNull ProcessingElementReferenceSet peReferenceSet) throws IOException {
        this(DatabaseCounterInstructionCounterReader.createChannelReadersFor(directory, peReferenceSet, (IThrowingBiFunction<File, ProcessingElementReference, IAnalysisCounterInstructionCounterChannelReader, IOException>)((IThrowingBiFunction)DatabaseCounterInstructionCounterChannelReader::new)));
    }

    DatabaseCounterInstructionCounterReader(@NonNull IAnalysisCounterInstructionCounterChannelReader @NonNull [] channelReaders) {
        super((IEventReader[])channelReaders);
    }

    @Override
    protected @NonNull IAnalysisCounterInstructionCounterChannelReader.Value adaptPerChannelValue(int channelIndex, @NonNull IAnalysisCounterInstructionCounterChannelReader.Value readValue) throws IOException {
        return readValue;
    }
}

