/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.icounter;

import com.arm.streamline.analysis.database.api.icounter.IAnalysisCounterInstructionCounterChannelReader;
import com.arm.streamline.analysis.database.stream.ChannelExecutablePathReader;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.io.Compression;
import com.arm.utils.function.Throwing;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseCounterInstructionCounterChannelReader
implements IAnalysisCounterInstructionCounterChannelReader {
    private final @NonNull ChannelExecutablePathReader executablePathReader = new ChannelExecutablePathReader();
    private final @NonNull InputStream inputStream;
    private long lastTimestamp;
    private final @NonNull ProcessingElementReference processingElement;

    public DatabaseCounterInstructionCounterChannelReader(@NonNull File dataFile, @NonNull ProcessingElementReference processingElement) throws FileNotFoundException, IOException {
        this.processingElement = processingElement;
        this.inputStream = (InputStream)Throwing.closeIfThrows(BufferedInputStream::new, (Object)((GZIPInputStream)Throwing.closeIfThrows(GZIPInputStream::new, (Object)((FileInputStream)Throwing.closeIfThrows(FileInputStream::new, (Object)dataFile, (Closeable[])new Closeable[0])), (Closeable[])new Closeable[0])), (Closeable[])new Closeable[0]);
    }

    DatabaseCounterInstructionCounterChannelReader(@NonNull InputStream inputStream, @NonNull ProcessingElementReference processingElement) {
        this.inputStream = inputStream;
        this.processingElement = processingElement;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public @Nullable IAnalysisCounterInstructionCounterChannelReader.Value read() throws IOException {
        try {
            long timestamp;
            long delta = Compression.unpackInt((InputStream)this.inputStream);
            int utid = (int)Compression.unpackInt((InputStream)this.inputStream);
            this.lastTimestamp = timestamp = this.lastTimestamp + delta;
            @Nullable IExecutablePath executablePath = this.executablePathReader.readExecutablePath(this.inputStream);
            long offsetOrAddress = Compression.unpackInt((InputStream)this.inputStream);
            long n = Compression.unpackInt((InputStream)this.inputStream);
            return new IAnalysisCounterInstructionCounterChannelReader.Value(this.processingElement, timestamp, utid, executablePath, offsetOrAddress, n);
        }
        catch (EOFException e) {
            return null;
        }
    }
}

