/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.factory;

import com.arm.streamline.analysis.database.api.icounter.IAnalysisCounterInstructionCounterWriter;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisRatioInstructionCounterWriter;
import com.arm.streamline.analysis.database.api.icounter.spe.ISpeCounterValueConsumer;
import com.arm.streamline.analysis.database.api.icounter.spe.ISpeDataSourceConsumer;
import com.arm.streamline.analysis.database.api.icounter.spe.ISpeEventsInstructionCounterConsumer;
import com.arm.streamline.analysis.database.api.icounter.spe.ISpeOperationTypePredicate;
import com.arm.streamline.analysis.database.stream.icounter.spe.ISpeInstructionCounterConsumerFactory;
import com.arm.streamline.analysis.database.stream.icounter.spe.ISpeInstructionCounterWriterFactory;
import com.arm.streamline.analysis.database.stream.icounter.spe.Messages;
import com.arm.streamline.analysis.database.stream.icounter.spe.SpeHitMissRatioInstructionCounterWriter;
import com.arm.streamline.common.xml.spe.SpeCounterProperties;
import com.arm.streamline.common.xml.spe.SpeDataSourceProperties;
import com.arm.streamline.common.xml.spe.SpePacketEventProperties;
import com.arm.utils.NullChecking;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SpeCounterConsumerUtility {
    private final @NonNull ISpeInstructionCounterConsumerFactory consumerFactory;
    private final @NonNull ISpeInstructionCounterWriterFactory writerFactory;

    public SpeCounterConsumerUtility(@NonNull ISpeInstructionCounterConsumerFactory consumerFactory, @NonNull ISpeInstructionCounterWriterFactory writerFactory) {
        this.consumerFactory = consumerFactory;
        this.writerFactory = writerFactory;
    }

    public @NonNull ISpeCounterValueConsumer createCounterConsumer(@NonNull File path, @NonNull SpeCounterProperties properties) {
        IAnalysisCounterInstructionCounterWriter writer = this.writerFactory.createCounterWriter(path, properties.getName(), properties.getDescription(), properties.getUnit(), properties.getClusterID(), properties.getType());
        return this.consumerFactory.createCounterConsumer(writer);
    }

    public @NonNull ISpeDataSourceConsumer createDataSourceConsumer(@NonNull File path, @NonNull Set<@NonNull SpeDataSourceProperties> properties) {
        TIntObjectHashMap namesByIndex = new TIntObjectHashMap(properties.size());
        properties.forEach(arg_0 -> SpeCounterConsumerUtility.lambda$0((TIntObjectMap)namesByIndex, arg_0));
        IAnalysisRatioInstructionCounterWriter<@NonNull Short> writer = this.writerFactory.createDataSourceWriter(path, Messages.SpeDataSourceRatioInstructionCounterWriter_DATA_SOURCE_TITLE, Messages.SpeDataSourceRatioInstructionCounterWriter_DATA_SOURCE_DESCRIPTION, "", (TIntObjectMap<String>)namesByIndex);
        return this.consumerFactory.createDataSourceConsumer(writer);
    }

    public @NonNull ISpeEventsInstructionCounterConsumer createEventConsumer(@NonNull File path, @NonNull SpePacketEventProperties properties) {
        boolean hitIsClear;
        String missLabel;
        String hitLabel;
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull SpePacketEventProperties.ShowByDefault showByDefault = properties.getShowByDefault();
        @Nullable Integer conditionBit = properties.getConditionBit();
        boolean accessIsClear = properties.isConditionalAccessOnBitClear();
        IAnalysisRatioInstructionCounterWriter<@NonNull Boolean> writer = this.writerFactory.createHitMissRatioWriter(path, properties.getRatioLabel(), (String)NullChecking.neverNullOr((Object)properties.getDescription(), (Object)""), "", hitLabel, missLabel, switch (showByDefault) {
            case SpePacketEventProperties.ShowByDefault.RATIO -> SpeHitMissRatioInstructionCounterWriter.ShowWhat.SHOW_RATIO_BY_DEFAULT;
            case SpePacketEventProperties.ShowByDefault.CLEAR -> SpeHitMissRatioInstructionCounterWriter.ShowWhat.SHOW_HIT_BY_DEFAULT;
            case SpePacketEventProperties.ShowByDefault.SET -> SpeHitMissRatioInstructionCounterWriter.ShowWhat.SHOW_MISS_BY_DEFAULT;
            default -> throw new AssertionError((Object)("ShowByDefault should be one of RATIO/CLEAR/SET, but was" + String.valueOf(showByDefault)));
        }, switch (properties.getSetMode()) {
            case SpePacketEventProperties.SetMode.NEGATIVE -> {
                hitLabel = properties.getClearLabel();
                missLabel = properties.getSetLabel();
                hitIsClear = true;
                yield false;
            }
            case SpePacketEventProperties.SetMode.NEUTRAL -> {
                hitLabel = properties.getSetLabel();
                missLabel = properties.getClearLabel();
                hitIsClear = false;
                yield true;
            }
            case SpePacketEventProperties.SetMode.POSITIVE -> {
                hitLabel = properties.getSetLabel();
                missLabel = properties.getClearLabel();
                hitIsClear = false;
                yield false;
            }
            default -> throw new AssertionError(properties.getSetMode());
        });
        @NonNull ISpeOperationTypePredicate operationTypePredicate = (opClass, subclass) -> {
            if (properties.getValidOpTypes().isEmpty()) {
                return true;
            }
            if (opClass == null) {
                return false;
            }
            return properties.getValidOpTypes().stream().anyMatch(type -> type.matches(opClass, subclass));
        };
        if (conditionBit != null) {
            return this.consumerFactory.createConditionalHitMissConsumer(writer, operationTypePredicate, conditionBit, accessIsClear, properties.getBitPosition(), hitIsClear);
        }
        return this.consumerFactory.createHitMissConsumer(writer, operationTypePredicate, properties.getBitPosition(), hitIsClear);
    }

    private static /* synthetic */ void lambda$0(TIntObjectMap tIntObjectMap, SpeDataSourceProperties p) {
        Object object = tIntObjectMap.put(p.getIndex(), (Object)p.getName());
    }
}

