/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.factory;

import com.arm.streamline.analysis.database.DBPropertiesReaderWriter;
import com.arm.streamline.analysis.model.DBProperties;
import com.arm.utils.function.IThrowingConsumer;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DatabaseLayout {
    public static final @NonNull String ALL_COUNTERS_FILE = "all_counters.xml";
    public static final @NonNull String APPLICATIONS_FILE = "applications.xml";
    public static final @NonNull String CORES_FILE = "cores.xml";
    public static final @NonNull String KALLSYMS_FILE = "kernel-symbols.xml";
    public static final @NonNull String METADATA_XML_FILENAME = "metadata.xml";
    public static final @NonNull String PE_REFERENCES_FILE = "pe-references.xml";
    public static final @NonNull String STATE_FILE = "state.xml";
    public static final @NonNull String VM_STATE_FILE = "virtual-machines.xml";
    private static final @NonNull String ACTIVITY_COUNTER_NAME_PREFIX = "activity-";
    private static final @NonNull String ACTIVITY_COUNTERS_PATH = "events";
    private static final @NonNull String ANNOTATIONS_PATH = "annotations";
    private static final @NonNull String CAM_VIEWS_PATH = "cam";
    private static final @NonNull String CODE_PROFILING_PATH = "profiling";
    private static final @NonNull String COUNTER_NAME_PREFIX = "counter-";
    private static final @NonNull String INSTRUCTION_COUNTER_NAME_PREFIX = "instruction-counter-";
    private static final @NonNull String COUNTERS_PATH = "hcounters";
    private static final @NonNull String IDLE_STATE_PATH = "idle";
    private static final @NonNull Pattern INT_STRING = Pattern.compile("[0-9]+");
    private static final @NonNull String ROOT_PATH = "db";
    private static final @NonNull String SCHEDULER_ACTIVITY_NAME = "scheduler";
    private static final @NonNull String INSTRUCTION_COUNTER_PATH = "instruction-counters";

    public static <E extends Throwable> void enumerateActivityDirectories(@NonNull File dbDirectory, @NonNull IActivityConsumer<E> consumer) throws E {
        File directory = new File(dbDirectory, ACTIVITY_COUNTERS_PATH);
        if (!directory.isDirectory()) {
            return;
        }
        @NonNull File @Nullable [] paths = directory.listFiles(f -> f.isDirectory() && (f.getName().equals(SCHEDULER_ACTIVITY_NAME) || f.getName().startsWith(ACTIVITY_COUNTER_NAME_PREFIX)));
        if (paths == null) {
            return;
        }
        File[] fileArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            File path = fileArray[n2];
            consumer.accept(path, path.getName().equals(SCHEDULER_ACTIVITY_NAME));
            ++n2;
        }
    }

    public static <E extends Throwable> void enumerateCAMDirectories(@NonNull File dbDirectory, @NonNull ICAMViewConsumer<E> consumer) throws E {
        File camDirector = new File(dbDirectory, CAM_VIEWS_PATH);
        if (!camDirector.isDirectory()) {
            return;
        }
        @NonNull File @Nullable [] vmUIDPaths = camDirector.listFiles(f -> f.isDirectory() && INT_STRING.matcher(f.getName()).matches());
        if (vmUIDPaths == null) {
            return;
        }
        File[] fileArray = vmUIDPaths;
        int n = vmUIDPaths.length;
        int n2 = 0;
        while (n2 < n) {
            File vmUIDPath = fileArray[n2];
            long vmUID = Long.parseLong(vmUIDPath.getName());
            @NonNull File @Nullable [] viewUIDPaths = vmUIDPath.listFiles(f -> f.isDirectory() && INT_STRING.matcher(f.getName()).matches());
            if (viewUIDPaths != null) {
                File[] fileArray2 = viewUIDPaths;
                int n3 = viewUIDPaths.length;
                int n4 = 0;
                while (n4 < n3) {
                    File viewUIDPath = fileArray2[n4];
                    int viewUID = Integer.parseInt(viewUIDPath.getName());
                    consumer.accept(viewUIDPath, vmUID, viewUID);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public static <E extends Throwable> void enumerateCounterDirectories(@NonNull File dbDirectory, @NonNull IThrowingConsumer<@NonNull File, E> consumer) throws E {
        File directory = new File(dbDirectory, COUNTERS_PATH);
        if (!directory.isDirectory()) {
            return;
        }
        @NonNull File @Nullable [] paths = directory.listFiles(f -> f.isDirectory() && f.getName().startsWith(COUNTER_NAME_PREFIX));
        if (paths == null) {
            return;
        }
        File[] fileArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            File path = fileArray[n2];
            consumer.accept((Object)path);
            ++n2;
        }
    }

    public static @NonNull Stream<@NonNull File> enumerateInstructionCounterDirectories(@NonNull File dbDirectory) {
        File directory = new File(dbDirectory, INSTRUCTION_COUNTER_PATH);
        if (!directory.isDirectory()) {
            return Stream.empty();
        }
        @NonNull File @Nullable [] paths = directory.listFiles(f -> f.isDirectory() && f.getName().startsWith(INSTRUCTION_COUNTER_NAME_PREFIX));
        if (paths == null) {
            Stream.empty();
        }
        return Arrays.stream(paths);
    }

    public static @NonNull File getActivityEventsPath(@NonNull File dbDirectory, int n, boolean create) throws IOException {
        return DatabaseLayout.getActivityEventsPath(dbDirectory, ACTIVITY_COUNTER_NAME_PREFIX + n, create);
    }

    public static @NonNull File getAnnotationsPath(@NonNull File dbDirectory, boolean create) throws IOException {
        return DatabaseLayout.makeDirectory(new File(dbDirectory, ANNOTATIONS_PATH), create);
    }

    public static @NonNull File getInstructionCounterPath(@NonNull File dbDirectory, int count, boolean create) throws IOException {
        return DatabaseLayout.makeDirectory(new File(new File(dbDirectory, INSTRUCTION_COUNTER_PATH), INSTRUCTION_COUNTER_NAME_PREFIX + count), create);
    }

    public static @NonNull File getCAMJobsPath(@NonNull File dbDirectory, long vmUID, int viewUID, boolean create) throws IOException {
        return DatabaseLayout.makeDirectory(new File(new File(new File(dbDirectory, CAM_VIEWS_PATH), Long.toString(vmUID)), Integer.toString(viewUID)), create);
    }

    public static @NonNull File getCodeProfilingEventsPath(@NonNull File dbDirectory, boolean create) throws IOException {
        return DatabaseLayout.makeDirectory(new File(dbDirectory, CODE_PROFILING_PATH), create);
    }

    public static @NonNull File getCounterPath(@NonNull File dbDirectory, int n, boolean create) throws IOException {
        return DatabaseLayout.makeDirectory(new File(new File(dbDirectory, COUNTERS_PATH), COUNTER_NAME_PREFIX + n), create);
    }

    public static @NonNull File getDatabaseRoot(@NonNull File apcDirectory) {
        return new File(apcDirectory, ROOT_PATH);
    }

    public static @NonNull File getIdleStateEventsPath(@NonNull File dbDirectory, boolean create) throws IOException {
        return DatabaseLayout.makeDirectory(new File(dbDirectory, IDLE_STATE_PATH), create);
    }

    public static @NonNull File getSchedulerEventsPath(@NonNull File dbDirectory, boolean create) throws IOException {
        return DatabaseLayout.getActivityEventsPath(dbDirectory, SCHEDULER_ACTIVITY_NAME, create);
    }

    public static @NonNull DBProperties readDatabaseProperties(@NonNull File dbDirectory) throws IOException {
        return DBPropertiesReaderWriter.create(new File(dbDirectory, STATE_FILE));
    }

    private static @NonNull File getActivityEventsPath(@NonNull File dbDirectory, @NonNull String name, boolean create) throws IOException {
        return DatabaseLayout.makeDirectory(new File(new File(dbDirectory, ACTIVITY_COUNTERS_PATH), name), create);
    }

    private static @NonNull File makeDirectory(@NonNull File directory, boolean create) throws IOException {
        if (create && !directory.isDirectory() && !directory.mkdirs()) {
            throw new IOException("Cannot make " + directory.getAbsolutePath());
        }
        return directory;
    }

    @FunctionalInterface
    public static interface IActivityConsumer<E extends Throwable> {
        public void accept(@NonNull File var1, boolean var2) throws E;
    }

    @FunctionalInterface
    public static interface ICAMViewConsumer<E extends Throwable> {
        public void accept(@NonNull File var1, long var2, int var4) throws E;
    }
}

