/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.factory;

import com.arm.streamline.analysis.database.api.IAnalysisWriterFactoryV2;
import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityWriter;
import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsWriter;
import com.arm.streamline.analysis.database.api.cam.IAnalysisCAMWriter;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterWriter;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisCounterInstructionCounterWriter;
import com.arm.streamline.analysis.database.api.icounter.IAnalysisRatioInstructionCounterWriter;
import com.arm.streamline.analysis.database.api.icounter.spe.ISpeCounterValueConsumer;
import com.arm.streamline.analysis.database.api.icounter.spe.ISpeDataSourceConsumer;
import com.arm.streamline.analysis.database.api.icounter.spe.ISpeEventsInstructionCounterConsumer;
import com.arm.streamline.analysis.database.api.idle.IAnalysisIdleStateWriter;
import com.arm.streamline.analysis.database.api.idle.IdleState;
import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingWriter;
import com.arm.streamline.analysis.database.api.scheduler.IAnalysisSchedulerTraceWriter;
import com.arm.streamline.analysis.database.stream.activity.DatabaseActivityEventWriterV2;
import com.arm.streamline.analysis.database.stream.activity.DatabaseSchedulerTraceWriter;
import com.arm.streamline.analysis.database.stream.annotations.DatabaseAnnotationEventWriter;
import com.arm.streamline.analysis.database.stream.cam.DatabaseCAMJobEventWriter;
import com.arm.streamline.analysis.database.stream.counters.DatabaseCounterWriter;
import com.arm.streamline.analysis.database.stream.counters.DatabaseThreadCounterWriter;
import com.arm.streamline.analysis.database.stream.factory.IAnalysisDatabaseWriterStateTracker;
import com.arm.streamline.analysis.database.stream.factory.SpeCounterConsumerUtility;
import com.arm.streamline.analysis.database.stream.icounter.spe.ISpeInstructionCounterWriterFactory;
import com.arm.streamline.analysis.database.stream.icounter.spe.SpeCounterInstructionCounterWriter;
import com.arm.streamline.analysis.database.stream.icounter.spe.SpeDataSourceRatioInstructionCounterWriter;
import com.arm.streamline.analysis.database.stream.icounter.spe.SpeHitMissRatioInstructionCounterWriter;
import com.arm.streamline.analysis.database.stream.icounter.spe.SpeInstructionCounterConsumerFactory;
import com.arm.streamline.analysis.database.stream.idle.DatabaseIdleStateWriter;
import com.arm.streamline.analysis.database.stream.profiling.DatabaseCodeProfilerEventWriter;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.xml.spe.SpeCounterProperties;
import com.arm.streamline.common.xml.spe.SpeDataSourceProperties;
import com.arm.streamline.common.xml.spe.SpePacketEventProperties;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.MapUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.function.Throwing;
import gnu.trove.TCollections;
import gnu.trove.map.TByteObjectMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AnalysisDatabaseWriterFactoryV2
implements IAnalysisWriterFactoryV2 {
    private static final @NonNull TLongSet EMPTY_VMUID_SET = TCollections.unmodifiableSet((TLongSet)new TLongHashSet());
    private final @NonNull Set<@NonNull Closeable> closeables = new HashSet<Closeable>();
    private final @NonNull TIntObjectMap<TLongSet> countersAttributableByTid;
    private final @NonNull IAnalysisDatabaseWriterStateTracker stateTracker;
    private final @NonNull IWriterFactory writerFactory;

    public AnalysisDatabaseWriterFactoryV2(@NonNull IAnalysisDatabaseWriterStateTracker stateTracker, @NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull TIntObjectMap<TLongSet> countersAttributableByTid) throws IOException {
        this.stateTracker = stateTracker;
        this.countersAttributableByTid = countersAttributableByTid;
        this.writerFactory = this.trackCloseable(new DefaultWriterFactoryImpl(peReferenceSet, stateTracker.getIdleStateEventsPath(), stateTracker.getSchedulerEventsPath()));
    }

    AnalysisDatabaseWriterFactoryV2(@NonNull IAnalysisDatabaseWriterStateTracker stateTracker, @NonNull IWriterFactory writerFactory, @NonNull TIntObjectMap<TLongSet> countersAttributableByTid) {
        this.stateTracker = stateTracker;
        this.writerFactory = writerFactory;
        this.countersAttributableByTid = countersAttributableByTid;
    }

    @Override
    public void close() throws IOException {
        try {
            Throwing.closeAll((Iterable[])new Iterable[]{this.closeables});
        }
        finally {
            this.closeables.clear();
        }
    }

    @Override
    public @NonNull IAnalysisActivityWriter createActivityWriter(@NonNull ICounterSeriesKey key) throws IOException {
        @NonNull File counterPath = this.stateTracker.trackActivityStreamPath(key);
        return this.trackCloseable(this.writerFactory.createActivityWriter(counterPath, key.getDeviceTypeOrDefault()));
    }

    @Override
    public @NonNull IAnalysisAnnotationsWriter createAnnotationsWriter() throws IOException {
        return this.trackCloseable(this.writerFactory.createAnnotationsWriter(this.stateTracker.getAnnotationsPath()));
    }

    @Override
    public @NonNull IAnalysisCAMWriter createCAMJobWriter(long vmUID, int viewUID) throws IOException {
        return this.trackCloseable(this.writerFactory.createCAMJobWriter(this.stateTracker.trackCAMJobsPath(vmUID, viewUID)));
    }

    @Override
    public @NonNull IAnalysisCodeProfilingWriter createCodeProfilingWriter() throws IOException {
        return this.trackCloseable(this.writerFactory.createCodeProfilingWriter(this.stateTracker.getCodeProfilingEventsPath()));
    }

    @Override
    public @NonNull IAnalysisHardwareCounterWriter createCounterWriter(@NonNull ICounterSeriesKey key) throws IOException {
        File counterPath = this.stateTracker.trackCounterPath(key);
        Integer keyNo = key.getKeyIfHas();
        TLongSet attributableByVm = (TLongSet)NullChecking.neverNullOr(keyNo != null ? (TLongSet)this.countersAttributableByTid.get(keyNo.intValue()) : null, (Object)EMPTY_VMUID_SET);
        if (!key.getDeviceTypeOrDefault().isCPU()) {
            return this.trackCloseable(this.writerFactory.createBasicCounterWriter(counterPath, key.getDeviceTypeOrDefault()));
        }
        if (key.isThreadCounter()) {
            if (key.isDeltaCounter()) {
                return this.trackCloseable(this.writerFactory.createCpuThreadDeltaCounterWriter(counterPath, key.getDeviceTypeOrDefault()));
            }
            return this.trackCloseable(this.writerFactory.createBasicCounterWriter(counterPath, key.getDeviceTypeOrDefault()));
        }
        if (!key.isSourceFilterable()) {
            return this.trackCloseable(this.writerFactory.createBasicCounterWriter(counterPath, key.getDeviceTypeOrDefault()));
        }
        if (key.isDeltaCounter()) {
            return this.trackCloseable(this.writerFactory.createCpuAttributableDeltaCounterWriter(counterPath, key.getDeviceTypeOrDefault(), key.isCpuPmuCounter(), attributableByVm));
        }
        return this.trackCloseable(this.writerFactory.createCpuAttributableIncidentCounterWriter(counterPath, key.getDeviceTypeOrDefault(), attributableByVm));
    }

    @Override
    public @NonNull IAnalysisIdleStateWriter createIdleStateWriter() throws IOException {
        return this.writerFactory.getIdleStateWriter();
    }

    @Override
    public @NonNull IAnalysisSchedulerTraceWriter createSchedulerTraceWriter() throws IOException {
        return this.writerFactory.getSchedulerTraceWriter();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @Nullable IAnalysisWriterFactoryV2.SpeWriters createSpeWriter(int key) throws IOException {
        @Nullable SpeTargetDescription speTargetDescription = this.stateTracker.getSpeTargetDescription(key);
        if (speTargetDescription == null) {
            return null;
        }
        @NonNull ArrayList<@NonNull ISpeEventsInstructionCounterConsumer> eventsWriters = new ArrayList<ISpeEventsInstructionCounterConsumer>();
        for (SpePacketEventProperties event : speTargetDescription.getAllSpePacketEvents()) {
            @NonNull File path = this.stateTracker.trackInstructionCounterPath(new SpeEventKey(speTargetDescription.getId(), event.getBitPosition()));
            eventsWriters.add(this.trackCloseable(this.writerFactory.createSpeEventConsumer(path, event)));
        }
        @NonNull @NonNull TByteObjectHashMap counterValueConsumers = new TByteObjectHashMap();
        for (SpeCounterProperties counter : speTargetDescription.getAllSpeCounters()) {
            @NonNull File path = this.stateTracker.trackInstructionCounterPath(new SpeCounterKey(speTargetDescription.getId(), counter.getIndex()));
            counterValueConsumers.put((byte)counter.getIndex(), (Object)this.trackCloseable(this.writerFactory.createSpeCounterConsumer(path, counter)));
        }
        @NonNull File dataSourcePath = this.stateTracker.trackInstructionCounterPath(new SpeDataSourceKey(speTargetDescription.getId()));
        return new IAnalysisWriterFactoryV2.SpeWriters(eventsWriters, this.trackCloseable(this.writerFactory.createSpeDataSourceConsumer(dataSourcePath, speTargetDescription.getAllSpeDataSources())), (TByteObjectMap<ISpeCounterValueConsumer>)counterValueConsumers);
    }

    private <T extends Closeable> @NonNull T trackCloseable(@NonNull T closeable) {
        this.closeables.add(closeable);
        return closeable;
    }

    static /* synthetic */ TLongSet access$0() {
        return EMPTY_VMUID_SET;
    }

    private static final class DefaultWriterFactoryImpl
    implements IWriterFactory,
    Closeable {
        private final @NonNull Map<@NonNull File, @NonNull IAnalysisActivityWriter> activityWriters = new HashMap<File, IAnalysisActivityWriter>();
        private final @NonNull Map<@NonNull File, @NonNull IAnalysisAnnotationsWriter> annotationWriters = new HashMap<File, IAnalysisAnnotationsWriter>();
        private final @NonNull Map<@NonNull File, @NonNull IAnalysisCAMWriter> camJobWriters = new HashMap<File, IAnalysisCAMWriter>();
        private final @NonNull Map<@NonNull File, @NonNull IAnalysisCodeProfilingWriter> codeProfilingWriters = new HashMap<File, IAnalysisCodeProfilingWriter>();
        private final @NonNull Map<@NonNull File, @NonNull IAnalysisHardwareCounterWriter> counterWriters = new HashMap<File, IAnalysisHardwareCounterWriter>();
        private final @NonNull ProcessingElementReferenceSet peReferenceSet;
        private final @NonNull SchedIdleCounterAdapter schedIdleTraceAdapter;
        private final @NonNull SpeCounterConsumerUtility speConsumerFactory = new SpeCounterConsumerUtility(new SpeInstructionCounterConsumerFactory(), new ISpeInstructionCounterWriterFactory(){

            @Override
            public @NonNull IAnalysisCounterInstructionCounterWriter createCounterWriter(@NonNull File path, @NonNull String title, @NonNull String description, @NonNull String unit, @Nullable Integer clusterID, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull SpeCounterProperties.Type type) {
                return new SpeCounterInstructionCounterWriter(path, title, description, unit, clusterID, type);
            }

            @Override
            public @NonNull IAnalysisRatioInstructionCounterWriter<@NonNull Short> createDataSourceWriter(@NonNull File path, @NonNull String title, @NonNull String description, @NonNull String unit, @NonNull TIntObjectMap<String> dataSourceNamesByIndex) {
                return new SpeDataSourceRatioInstructionCounterWriter(path, title, description, unit, dataSourceNamesByIndex);
            }

            @Override
            public @NonNull IAnalysisRatioInstructionCounterWriter<@NonNull Boolean> createHitMissRatioWriter(@NonNull File path, @NonNull String title, @NonNull String description, @NonNull String unit, @NonNull String hitLabel, @NonNull String missLabel, @NonNull SpeHitMissRatioInstructionCounterWriter.ShowWhat showWhatByDefault, boolean useNeutralColours) {
                return new SpeHitMissRatioInstructionCounterWriter(path, title, description, unit, null, hitLabel, missLabel, showWhatByDefault, useNeutralColours);
            }
        });
        private final @NonNull Map<@NonNull File, @NonNull ISpeCounterValueConsumer> speCounterConsumers = new HashMap<File, ISpeCounterValueConsumer>();
        private final @NonNull Map<@NonNull File, @NonNull ISpeDataSourceConsumer> speDataSourceConsumers = new HashMap<File, ISpeDataSourceConsumer>();
        private final @NonNull Map<@NonNull File, @NonNull ISpeEventsInstructionCounterConsumer> speEventConsumers = new HashMap<File, ISpeEventsInstructionCounterConsumer>();

        public DefaultWriterFactoryImpl(@NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull File idleStatePath, @NonNull File schedulerTracePath) {
            this.peReferenceSet = peReferenceSet;
            this.schedIdleTraceAdapter = new SchedIdleCounterAdapter(peReferenceSet, idleStatePath, schedulerTracePath);
        }

        @Override
        public void close() throws IOException {
            this.schedIdleTraceAdapter.close();
        }

        @Override
        public @NonNull IAnalysisActivityWriter createActivityWriter(@NonNull File counterPath, @NonNull DeviceType deviceType) {
            return (IAnalysisActivityWriter)MapUtils.computeIfAbsentThrows(this.activityWriters, (Object)counterPath, p -> new DatabaseActivityEventWriterV2(counterPath, deviceType, this.peReferenceSet));
        }

        @Override
        public @NonNull IAnalysisAnnotationsWriter createAnnotationsWriter(@NonNull File annotationsPath) throws IOException {
            return (IAnalysisAnnotationsWriter)MapUtils.computeIfAbsentThrows(this.annotationWriters, (Object)annotationsPath, p -> new DatabaseAnnotationEventWriter(annotationsPath));
        }

        @Override
        public @NonNull IAnalysisCAMWriter createCAMJobWriter(@NonNull File camPath) throws IOException {
            return (IAnalysisCAMWriter)MapUtils.computeIfAbsentThrows(this.camJobWriters, (Object)camPath, p -> new DatabaseCAMJobEventWriter(camPath));
        }

        @Override
        public @NonNull IAnalysisCodeProfilingWriter createCodeProfilingWriter(@NonNull File profilingPath) throws IOException {
            return (IAnalysisCodeProfilingWriter)MapUtils.computeIfAbsentThrows(this.codeProfilingWriters, (Object)profilingPath, p -> new DatabaseCodeProfilerEventWriter(profilingPath));
        }

        @Override
        public @NonNull IAnalysisHardwareCounterWriter createCpuAttributableIncidentCounterWriter(@NonNull File counterPath, @NonNull DeviceType deviceType, @NonNull TLongSet vmUIDsWhereSuppliedTidShouldBeUsedInsteadOfScheduler) {
            if (!deviceType.isCPU()) {
                throw new IllegalArgumentException(deviceType.toString());
            }
            return (IAnalysisHardwareCounterWriter)MapUtils.computeIfAbsentThrows(this.counterWriters, (Object)counterPath, p -> this.schedIdleTraceAdapter.track(new DatabaseThreadCounterWriter(DatabaseThreadCounterWriter.Mode.USE_SCHED_OR_SUP_TID, vmUIDsWhereSuppliedTidShouldBeUsedInsteadOfScheduler, false, deviceType, counterPath), false));
        }

        @Override
        public @NonNull IAnalysisHardwareCounterWriter createBasicCounterWriter(@NonNull File counterPath, @NonNull DeviceType deviceType) {
            return (IAnalysisHardwareCounterWriter)MapUtils.computeIfAbsentThrows(this.counterWriters, (Object)counterPath, p -> new DatabaseCounterWriter(counterPath, deviceType));
        }

        @Override
        public @NonNull IAnalysisHardwareCounterWriter createCpuAttributableDeltaCounterWriter(@NonNull File counterPath, @NonNull DeviceType deviceType, boolean includeCpuIdleEvents, @NonNull TLongSet vmUIDsWhereSuppliedTidShouldBeUsedInsteadOfScheduler) {
            if (!deviceType.isCPU()) {
                throw new IllegalArgumentException(deviceType.toString());
            }
            return (IAnalysisHardwareCounterWriter)MapUtils.computeIfAbsentThrows(this.counterWriters, (Object)counterPath, p -> this.schedIdleTraceAdapter.track(new DatabaseThreadCounterWriter(DatabaseThreadCounterWriter.Mode.USE_SCHED_OR_SUP_TID, vmUIDsWhereSuppliedTidShouldBeUsedInsteadOfScheduler, true, deviceType, counterPath), includeCpuIdleEvents));
        }

        @Override
        public @NonNull IAnalysisHardwareCounterWriter createCpuThreadDeltaCounterWriter(@NonNull File counterPath, @NonNull DeviceType deviceType) {
            if (!deviceType.isCPU()) {
                throw new IllegalArgumentException(deviceType.toString());
            }
            return (IAnalysisHardwareCounterWriter)MapUtils.computeIfAbsentThrows(this.counterWriters, (Object)counterPath, p -> this.schedIdleTraceAdapter.track(new DatabaseThreadCounterWriter(DatabaseThreadCounterWriter.Mode.USE_SUPPLIED_TID, EMPTY_VMUID_SET, true, deviceType, counterPath), false));
        }

        @Override
        public @NonNull ISpeCounterValueConsumer createSpeCounterConsumer(@NonNull File path, @NonNull SpeCounterProperties properties) {
            return (ISpeCounterValueConsumer)MapUtils.computeIfAbsentThrows(this.speCounterConsumers, (Object)path, p -> this.speConsumerFactory.createCounterConsumer(path, properties));
        }

        @Override
        public @NonNull ISpeDataSourceConsumer createSpeDataSourceConsumer(@NonNull File path, @NonNull Set<@NonNull SpeDataSourceProperties> properties) {
            return (ISpeDataSourceConsumer)MapUtils.computeIfAbsentThrows(this.speDataSourceConsumers, (Object)path, p -> this.speConsumerFactory.createDataSourceConsumer(path, properties));
        }

        @Override
        public @NonNull ISpeEventsInstructionCounterConsumer createSpeEventConsumer(@NonNull File path, @NonNull SpePacketEventProperties properties) {
            return (ISpeEventsInstructionCounterConsumer)MapUtils.computeIfAbsentThrows(this.speEventConsumers, (Object)path, p -> this.speConsumerFactory.createEventConsumer(path, properties));
        }

        @Override
        public @NonNull IAnalysisIdleStateWriter getIdleStateWriter() {
            return this.schedIdleTraceAdapter;
        }

        @Override
        public @NonNull IAnalysisSchedulerTraceWriter getSchedulerTraceWriter() {
            return this.schedIdleTraceAdapter;
        }

        private static final class SchedIdleCounterAdapter
        implements IAnalysisIdleStateWriter,
        IAnalysisSchedulerTraceWriter {
            private final @NonNull IAnalysisIdleStateWriter idleWriter;
            private final @NonNull Set<@NonNull IAnalysisIdleStateWriter> idleWriters = new HashSet<IAnalysisIdleStateWriter>();
            private final @NonNull IAnalysisSchedulerTraceWriter schedTracer;
            private final @NonNull Set<@NonNull IAnalysisSchedulerTraceWriter> schedTracers = new HashSet<IAnalysisSchedulerTraceWriter>();

            public SchedIdleCounterAdapter(@NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull File idleStatePath, @NonNull File schedulerTracePath) {
                this.idleWriter = new DatabaseIdleStateWriter(idleStatePath);
                this.schedTracer = (IAnalysisSchedulerTraceWriter)Throwing.closeIfThrows(p -> new DatabaseSchedulerTraceWriter((File)p, peReferenceSet), (Object)schedulerTracePath, (Closeable[])new Closeable[]{this.idleWriter});
                this.idleWriters.add(this.idleWriter);
                this.schedTracers.add(this.schedTracer);
            }

            @Override
            public void close() throws IOException {
                Throwing.closeAll((Closeable[])new Closeable[]{this.idleWriter, this.schedTracer});
            }

            @Override
            public void consumeIdleEvent(@NonNull ProcessingElementReference peReference, long time, @NonNull IdleState state) throws IOException {
                for (IAnalysisIdleStateWriter idleWriter : this.idleWriters) {
                    idleWriter.consumeIdleEvent(peReference, time, state);
                }
            }

            @Override
            public void consumeSchedFree(@NonNull IUniqueThreadID utid, long time) throws IOException {
                for (IAnalysisSchedulerTraceWriter schedTracer : this.schedTracers) {
                    schedTracer.consumeSchedFree(utid, time);
                }
            }

            @Override
            public void consumeSchedSwitch(@NonNull ProcessingElementReference peReference, @Nullable IUniqueThreadID utid, long time, int state) throws IOException {
                for (IAnalysisSchedulerTraceWriter schedTracer : this.schedTracers) {
                    schedTracer.consumeSchedSwitch(peReference, utid, time, state);
                }
            }

            public <T extends IAnalysisIdleStateWriter & IAnalysisSchedulerTraceWriter> @NonNull T track(@NonNull T writer, boolean includingIdle) {
                this.schedTracers.add(writer);
                if (includingIdle) {
                    this.idleWriters.add(writer);
                }
                return writer;
            }
        }
    }

    public static interface IWriterFactory {
        public @NonNull IAnalysisActivityWriter createActivityWriter(@NonNull File var1, @NonNull DeviceType var2);

        public @NonNull IAnalysisAnnotationsWriter createAnnotationsWriter(@NonNull File var1) throws IOException;

        public @NonNull IAnalysisHardwareCounterWriter createCpuAttributableDeltaCounterWriter(@NonNull File var1, @NonNull DeviceType var2, boolean var3, @NonNull TLongSet var4);

        public @NonNull IAnalysisCAMWriter createCAMJobWriter(@NonNull File var1) throws IOException;

        public @NonNull IAnalysisCodeProfilingWriter createCodeProfilingWriter(@NonNull File var1) throws IOException;

        public @NonNull IAnalysisHardwareCounterWriter createCpuAttributableIncidentCounterWriter(@NonNull File var1, @NonNull DeviceType var2, @NonNull TLongSet var3);

        public @NonNull IAnalysisHardwareCounterWriter createBasicCounterWriter(@NonNull File var1, @NonNull DeviceType var2);

        public @NonNull ISpeCounterValueConsumer createSpeCounterConsumer(@NonNull File var1, @NonNull SpeCounterProperties var2);

        public @NonNull ISpeDataSourceConsumer createSpeDataSourceConsumer(@NonNull File var1, @NonNull Set<@NonNull SpeDataSourceProperties> var2);

        public @NonNull ISpeEventsInstructionCounterConsumer createSpeEventConsumer(@NonNull File var1, @NonNull SpePacketEventProperties var2);

        public @NonNull IAnalysisHardwareCounterWriter createCpuThreadDeltaCounterWriter(@NonNull File var1, @NonNull DeviceType var2);

        public @NonNull IAnalysisIdleStateWriter getIdleStateWriter();

        public @NonNull IAnalysisSchedulerTraceWriter getSchedulerTraceWriter();
    }

    private static class SpeCounterKey
    implements IAnalysisDatabaseWriterStateTracker.IInstructionCounterKey {
        private final int id;
        private final @NonNull String speKey;

        public SpeCounterKey(@NonNull String speKey, int id) {
            this.speKey = speKey;
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SpeCounterKey other = (SpeCounterKey)obj;
            if (this.id != other.id) {
                return false;
            }
            return this.speKey.equals(other.speKey);
        }

        public int hashCode() {
            int prime = 31;
            int result = this.getClass().hashCode();
            result = 31 * result + this.id;
            result = 31 * result + this.speKey.hashCode();
            return result;
        }
    }

    private static class SpeDataSourceKey
    implements IAnalysisDatabaseWriterStateTracker.IInstructionCounterKey {
        private final @NonNull String speKey;

        public SpeDataSourceKey(@NonNull String speKey) {
            this.speKey = speKey;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SpeDataSourceKey other = (SpeDataSourceKey)obj;
            return this.speKey.equals(other.speKey);
        }

        public int hashCode() {
            int prime = 31;
            int result = this.getClass().hashCode();
            result = 31 * result + this.speKey.hashCode();
            return result;
        }
    }

    private static class SpeEventKey
    implements IAnalysisDatabaseWriterStateTracker.IInstructionCounterKey {
        private final int id;
        private final @NonNull String speKey;

        public SpeEventKey(@NonNull String speKey, int id) {
            this.speKey = speKey;
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SpeEventKey other = (SpeEventKey)obj;
            if (this.id != other.id) {
                return false;
            }
            return this.speKey.equals(other.speKey);
        }

        public int hashCode() {
            int prime = 31;
            int result = this.getClass().hashCode();
            result = 31 * result + this.id;
            result = 31 * result + this.speKey.hashCode();
            return result;
        }
    }
}

